#include <Ark/ArkSystem.h>

#include <Client/UIStyle.h>

namespace Client
{
   Style::Style(UIRenderer *ui) :
      m_Textures(UI_DECORATIONS_NBR),
      m_Placements(UI_DECORATIONS_NBR)
   {
      struct
      {
	    uchar Anchor;
	    const char *Name;
      } textures[] = 
	 {
	    {UI_BACKGROUND, "Background"},
	    {UI_RIGHT, "BorderRight"},
	    {UI_LEFT, "BorderLeft"},
	    {UI_TOP, "BorderTop" },
	    {UI_BOTTOM, "BorderBottom"},

	    {UI_UPLEFT, "BorderUpLeft"},
	    {UI_UPRIGHT, "BorderUpRight"},
	    {UI_DOWNLEFT, "BorderDownLeft"},
	    {UI_DOWNRIGHT, "BorderDownRight"},

	    {UI_UPLEFT+4, "SBorderUpLeft"},
	    {UI_UPRIGHT+4, "SBorderUpRight"},
	    {UI_DOWNLEFT+4, "SBorderDownLeft"},
	    {UI_DOWNRIGHT+4, "SBorderDownRight"}
	 };

      Ark::Config cfg; cfg.Load("{game}/data/misc/uistyle.cfg");
      for (size_t i = 0; i < UI_DECORATIONS_NBR; ++i)
      {
	 uchar Anchor = textures[i].Anchor;
	 Ark::String name = Ark::String("UI::") + textures[i].Name;
	 SetTextureAt (ui, Anchor, cfg.GetStr(name, ""));

	 m_Placements[Anchor].x = cfg.GetInt(name + "::PlacementX", 0);
	 m_Placements[Anchor].y = cfg.GetInt(name + "::PlacementY", 0);
      }
   }

   Style::~Style()
   {
   }

   /**************************************************************************
    **
    *************************************************************************/
   bool Style::SetTextureAt(UIRenderer* Renderer, uchar Anch,
			    const Ark::String &path)
   {
      if (Anch > m_Textures.size())
	 return false;

      Ark::TexturePtr tex;
      Renderer->Rdr()->GetCache().Get(Ark::V_TEXTURE, path, tex);

      if (!tex)
      {
	 // some warning here...
	  std::cerr << "Could not load texture " << path << std::endl;
	 return false;
      }

      m_Textures[Anch] = tex;
      m_Textures[Anch]->Configure();

      // the last 4 bitmaps are corner decorations with alpha
      if (Anch > UI_DOWNRIGHT && tex->m_Format != Ark::Image::RGBA_8888)
      {
	 Ark::Sys()->Log("Style texture %d: '%s' is not RGBA_8888\n",
			 (int)Anch, path.c_str());
      }
    
      return true;
   }
  
   void	Style::RenderSkin(UIRenderer* Renderer, int X, int Y, int W, int H)
   {
      // cycle for every part of skin
      for (size_t i = 0; i < UI_DECORATIONS_NBR; ++i)
      {
	 int tx = X, ty = Y, tw = m_Textures[i]->m_Width,
	    th = m_Textures[i]->m_Height;
	
	 switch (i)
	 {
	    case UI_BACKGROUND: tw = W; th = H; break;
	    
	    // sides
	    case UI_LEFT: th = H; break;
	    case UI_RIGHT: tx += W; th = H; break;
	    case UI_TOP: tw = W; break;
	    case UI_BOTTOM: ty += H; tw = W; break;

	    // corners
	    case UI_UPLEFT: break;
	    case UI_UPRIGHT: tx += W; break;
	    case UI_DOWNLEFT: ty += H; break;
	    case UI_DOWNRIGHT: tx += W; ty += H; break;

	    // corners
	    case UI_UPRIGHT + 4: tx += W; break;
	    case UI_UPLEFT + 4: break;
	    case UI_DOWNRIGHT + 4: tx += W; ty += H; break;
	    case UI_DOWNLEFT + 4: ty += H; break;
	 }

	 tx += m_Placements[i].x;
	 ty += m_Placements[i].y;

	 Renderer->SetTexture(m_Textures[i]);
	 Renderer->DrawTexturedRectangle(tx, ty, tw, th);
	 Renderer->Flush();
      }
   }
}
