/* $Id: Engine.h,v 1.12 2002/10/18 01:04:32 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ENGINE_UPDATER_H
#define ENGINE_UPDATER_H

#include <Ark/ArkWorldUpd.h>
#include <Ark/ArkCollision.h>

#include <Engine/ArkEngine.h>
#include <Engine/Script.h>
#include <Engine/Entity.h>

#include <vector>

#ifdef WIN32
 #undef LoadLibrary
#endif

namespace Ark
{
   class ARKENGINE_DLL_API Engine : public WorldUpdater
   {
	 friend class EngineEntity;

	 Script *m_Script;
	 World *m_World;
	 Cache *m_Cache;
	 String m_WorldName;

	 std::vector<Vector3> m_PlayerStarts;

      public:
	 Engine (Cache *cache, bool server = false);
	 virtual ~Engine ();

	 bool Update (scalar delta_time);

	 /** Load the world whose path is \c name.
	  */
	 virtual void LoadWorld (const String &name);

	 /** Try to 'login' an entity. This means that the world part in
	  * which this entity lay is loaded, then all entity states are
	  * loaded ; finally the entity is returned. The \c password might
	  * be used for a networked game.
	  */
	 virtual Entity *Login (const String &login,
				const String &password);


     public:
	 // Network stuff
	 virtual void HintEntityRemoved (int entityID);
	 virtual void HintEntityAdded (int entityID);

	 bool IsServer () const {return m_IsServer;}
	 bool WriteDelta (WriteStream &stream);
	 bool WriteFull (WriteStream &stream);
	 void ResetDelta ();
	 
	 const String &GetWorldName() const {return m_WorldName;}

     private:
	 bool m_IsServer;
	 std::vector<int> m_AddedEntities;
	 std::vector<int> m_RemovedEntities;
	 
	 
      public:
	 Script *GetScript() {return m_Script;}
	 World *GetWorld() {return m_World;}
   };

   extern ARKENGINE_DLL_API Engine *GetEngine();

} // namespace Ark

#include <Ark/ArkFactoryDef.h>
ARK_REGISTER_DEF(ARKENGINE_DLL_API);


#endif // ENGINE_UPDATER_H
