/* $Id: LuaListTable.h,v 1.1 2002/12/18 20:10:46 tharibo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef LUA_LISTTABLE_H
#define LUA_LISTTABLE_H

extern "C"
{
#include <lua.h>
}

#include "LuaTable.h"

namespace Ark
{

  /**
   * \brief Simple table which is a simple list of elements
   * \author tharibo tharibo@nekeme.net
   *
   * This class is used to handle simple lists of elements in Lua. This is done
   * with a table whith no explicit key. In fact, the keys are numbers, but this
   * is handled automatically by Lua.
   *
   * It should be destroyed at the end of the function.
   */
  class ARKLUA_DLL_API LuaListTable : public LuaTable
  {
    public:
      
      /**
       * Construct a LuaTable, the table being at the given index.
       */
      LuaListTable(lua_State* L, int index = -1);

      /**
       * Destructor
       */
      virtual ~LuaListTable();

      /**
       * Add an element to the list
       *
       * \param element The element to add.
       */
      void addElement(double element);

      /**
       * Add an element to the list
       *
       * \param element The element to add.
       */
      void addElement(const char* element);

      /**
       * Add an element to the list
       *
       * \param element The element to add.
       */
      void addElement(void* element);

      /**
       * Add an element to the list
       *
       * \param element The element to add.
       */
      void addElement(const LuaTable& element);

      // TODO: add the functions to destroy elements of the list...
      
      /**
       * Constructs a LuaListTable from scratch. This creates a new table on the
       * stack.
       *
       * \param L The lua state where we are going to create the table.
       */
      static LuaListTable* createTable(lua_State* L);

    protected:
      /**
       * Index (key) of the last element in the list.
       *
       * -1 means there is no element in the list.
       */
      int m_LastIndex;
  };
}

#endif
