/*
 * Copyright (c) 1995 - 2000 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <nnpfs/nnpfs_locl.h>

RCSID("$Id: nnpfs_syscalls-wrap-osf.c,v 1.8 2002/09/07 10:45:20 lha Exp $");

/*
 * NNPFS system calls.
 */

#include <nnpfs/nnpfs_syscalls.h>
#include <nnpfs/nnpfs_message.h>
#include <nnpfs/nnpfs_fs.h>
#include <nnpfs/nnpfs_dev.h>
#include <nnpfs/nnpfs_node.h>
#include <nnpfs/nnpfs_deb.h>

#include <kafs.h>

int nosys(struct proc *, ...);

static int
try_install_syscall(int callno,
		    int (*call)(struct proc *, ...), 
		    int narg, 
		    int parallel)
{
    if(sysent[callno].sy_call == nosys) {
	sysent[callno].sy_call = call;
#ifdef HAVE_STRUCT_SYSENT_SY_INFO
	sysent[callno].sy_info = narg;
#else
	sysent[callno].sy_narg = narg; 
	sysent[callno].sy_parallel = parallel; 
#endif
	return callno;
    }
    return -1;
}

static void
del_syscall(int syscall)
{
    sysent[syscall].sy_call = nosys;
#ifdef HAVE_STRUCT_SYSENT_SY_INFO
    sysent[syscall].sy_info = 1;
#else
    sysent[syscall].sy_narg = 1;
    sysent[syscall].sy_parallel = 1;
#endif
}

int nnpfs_syscall_num;

static struct sysent old_setgroups;

int (*osf_old_setgroups_func)(struct proc *, void *);

static int
wrap_old_setgroups_func (struct proc *proc, void *varg, int *return_value)
{
    return (*osf_old_setgroups_func) (proc, varg);
}

/* XXX */

#define AFS_SYSCALL	232
#define AFS_SYSCALL2	258

void
nnpfs_install_syscall(void)
{
    int i;

    old_setgroups = sysent[SYS_setgroups];
    osf_old_setgroups_func = old_setgroups.sy_call;
    old_setgroups_func = wrap_old_setgroups_func;
    sysent[SYS_setgroups].sy_call = nnpfs_setgroups;

    /* first try fixed values */
    nnpfs_syscall_num = try_install_syscall(AFS_SYSCALL, nnpfspioctl, 5, 0);
    if(nnpfs_syscall_num != -1)
	return;
    nnpfs_syscall_num = try_install_syscall(AFS_SYSCALL2, nnpfspioctl, 5, 0);
    if(nnpfs_syscall_num != -1)
	return;
    /* if that fails, fall back to any free syscall */
    for(i = 1; i < nsysent; i++) {
	nnpfs_syscall_num = try_install_syscall(i, nnpfspioctl, 5, 0);
	if(nnpfs_syscall_num != -1)
	    return;
    }
}

void
nnpfs_uninstall_syscall(void)
{
    del_syscall(nnpfs_syscall_num);
    sysent[SYS_setgroups] = old_setgroups;
}
