/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "tConsole.h"
#include "defs.h"
#include <string.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <iostream.h>
#include "nNetwork.h"


// a sample message receiver: print all the shorts stored in m.
void sample_message_handler(nMessage &m){
  con << "x\n";
  int i=1;
  while(!m.End()){
    short out;
    m >> out;
    con << i << " :\t" << out << '\n';
    i++;
  }
  con << '\n';
}

// the descriptor
nDescriptor message_test(31,&sample_message_handler,"message_test");

unsigned short client_gamestate[MAXCLIENTS+2];


void server(){
  int loop=100000; // a long delay loop

  sn_SetNetState(nSERVER); // initialise server mode

  while(loop>0 && sn_GetNetState()!=nSTANDALONE){ // and loop a while
    sn_Receive();
    loop--;
    usleep(10000);
  }
 
  sn_SetNetState(nSTANDALONE); // exit.
  usleep(10000);
  sn_Receive();
}


void client(const tString &serv){
  sn_Connect(serv); // initialise client state and connect to the given server

  if (sn_GetNetState()!=nCLIENT){
    con << "Login failed.\n";
    return;
  }

  con << "\n\nFirst, we send a single short (17) to the server:\n";

  nMessage *m=new nMessage(message_test);
  (*m) << (short)17;
  m->BroadCast();
  sn_Receive();

  usleep(3000000);

  con << "\n\nThen, we try three shorts(56,1,7):\n";

  m=new nMessage(message_test);
  (*m) << (short)57;
  (*m) << (short)1;
  (*m) << (short)7;
  m->BroadCast();
  sn_Receive();

  usleep(3000000);

  con << "\n\nLet's see what happens if we forget the type cast\n"
      <<  "and send our number (17) as int:\n";

  m=new nMessage(message_test);
  (*m) << 17;
  m->BroadCast();
  sn_Receive();

  // wait before we exit, getting messages and repeating lost ones
  for(int i=300;i>=0;i--){
    sn_Receive();
    usleep(1000);
  }

  con << "\nAha. Thought so :-> It arrives as two shorts.\n\n\n";

  sn_SetNetState(nSTANDALONE);
  usleep(1000);
  sn_Receive();
}



int main(int argnum,char **arglist){
  if (argnum<=1){
    server();
  }
  else{
    client(arglist[1]);
  }
}
