/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_NET_H
#define ArmageTron_NET_H

#include "tString.h"
#include "tHeap.h"
#include "tLinkedList.h"
#include "tCallback.h"
//#include "tCrypt.h"

class nMessage;
class tCrypt;

extern tString sn_bigBrotherString; // the string that is sent
// to the server for system information

// message of day presented to clients logging in; consists of four lines
extern tString sn_greeting[4]; 

extern tString sn_programVersion; // our version


extern int sn_defaultDelay;

// rate control
extern int sn_maxRateIn,sn_maxRateOut;

// exception that is thrown on any unexpected network error;
// causes the owner of the current nNetObject or the sender of
// the currently processed netmessage to be killed.

class nKillHim{
public:
  nKillHim(){};
};

// call this function on any error occuring while reading a message:
void nReadError();


#define MAXCLIENTS 16

// We can be single player, multiplayer server/client.
typedef enum {nSTANDALONE,nSERVER,nCLIENT} nNetState;

// set/get the state
nNetState sn_GetNetState();
void sn_SetNetState(nNetState x);
void sn_KillUser(int i);


struct nConnectionInfo     // everything that is needed to manage a connection
{
  int                    socket;             // the network UDP socket
  int                    ackPending;   
  REAL                   ping;
  tCrypt*                crypt;
  tArray<unsigned short> sendBuffer;

  // rate control
  REAL                   rateControlPlanned;
  REAL                   rateControl;
  unsigned short         rate;

  // ack messages
  nMessage*              ackMess;

  nConnectionInfo();
  ~nConnectionInfo();

  void Clear();
};

extern nConnectionInfo sn_Connections[MAXCLIENTS+2];

extern int sn_maxNoAck;
//extern int sn_ackPending[MAXCLIENTS+2];
//extern int sn_sockets[MAXCLIENTS+2]; 
//extern REAL sn_ping[MAXCLIENTS+2];

// go to client mode and connect to server
void sn_Connect(const tString &server);

extern int sn_myNetID; // our network identification:  0: server
 //                                                1..MAXCLIENTS: client

// Network messages and functions that know how to handle them:

class nMessage;
typedef void nHandler(nMessage &m);


// types of network messages
class nDescriptor:public tListItem<nDescriptor>{
  friend class nMessage;

  static unsigned short s_nextID;

  unsigned short id;     // our id
  nHandler *handler;  // function responsible for our type of message

  const char *name;
public:
  nDescriptor(unsigned short identification,nHandler *handle
		,const char *name);
  //  nDescriptor(nHandler *handle,
  //		const char *name);
  static void HandleMessage(nMessage &message);
  
  unsigned short ID(){return id;}
};

// register the routine that gives the peer the server/client information
// (game type, number of players online....)
void RequestInfoHandler(nHandler *handle);

// the first sn_myNetID available for external use (give some room!)
#define NET_ID_FIRST 100

// Network messages. Allways to be created with new, get deleted automatically.

class nMessage{
  //friend class nMessage_planned_send;
  friend class tControlledPTR<nMessage>;
  int refCtr;
   
  friend class nDescriptor;
  friend class nNetObject;
  friend class nWaitForAck;
 
   void AddRef();
   void Release();
   
 protected:
  unsigned short descriptor;    // the network message id
  unsigned short messageID;     // number of the message for ack; zero for no ack.
  short          senderID;      // sender's identification 
  tArray<unsigned short> data;  // assuming ints are 32 bit wide...

  unsigned int readOut;

 public:
 unsigned short Descriptor(){
    return descriptor;
 }

 unsigned short SenderID(){
    return senderID;
 }

 unsigned short MessageID(){
    return messageID;
 }

  unsigned short DataLen(){
    return data.Len();
  }

  unsigned short Data(unsigned short n){
    return data(n);
  }
  

  nMessage(const nDescriptor &);  // create a new message
  nMessage(unsigned short*& buffer,short sn_myNetID);
  // read a message from the network stream
  
  ~nMessage();

  // immediately send the message WITHOUT the queue; dangerous!
  void SendImmediately(int peer,bool ack=true);

  // send it to anyone who is interested
  // (the server in client mode, all clients in server mode)
  void BroadCast(bool ack=true); 

  // put the message into the send heap
  void Send(int peer,REAL priority=0,bool ack=true);

  void Write(const unsigned short &x){
    data[data.Len()]=x;
  }

  void operator<< (const REAL &x);
  void operator>> (REAL &x);

  void operator<< (const unsigned short &x){Write(x);}
  void operator>> (unsigned short &x){Read(x);}

  void operator<< (const double &x){
    operator<<(REAL(x));
  }

  void operator>> (double &x){
    REAL y;
    operator>>(y);
    x=y;
  }

  void operator >> (tString &s);
  void operator << (const tString &s);


  template<class T> void BinWrite (const T &x){
    for(unsigned int i=0;i<sizeof(T)/2;i++)
      Write((reinterpret_cast<const unsigned short *>(&x))[i]);
  }

  bool End(){return readOut>=static_cast<unsigned int>(data.Len());}

  void Reset(){readOut=0;}

  void Read(unsigned short &x);

  template<class T> void BinRead (const T &x){
    for(unsigned int i=0;i<sizeof(T)/2;i++)
      Read(reinterpret_cast<unsigned short *>(&x)[i]);
  }


  void operator<< (const short &x);
  void operator>> (short &x);

  void operator<< (const int &x);
  void operator>> (int &x);
  
  void operator<< (const bool &x);
  void operator>> (bool &x);
};



// the class that is responsible for getting acknowleEdgement for
// netmessages

class nWaitForAck{
protected:
  int id;
  tCONTROLLED_PTR(nMessage) message;  // the message
  int        receiver;  // the computer who should send the ack
  REAL       timeSendAgain; // for timeout
  REAL       timeFirstSent; // for ping calculation
  REAL       timeLastSent; // for ping calculation
  int        timeouts;
  
public:
  nWaitForAck(nMessage* m,int rec);
  virtual ~nWaitForAck();
  
  virtual void AckExtraAction(){};

  static void Ackt(unsigned short id,unsigned short peer);
   
  static void AckAllPeer(unsigned short peer);
  
  static void Resend();
};


// process the messages from all hosts and send acks
void sn_Receive();

// attempts to sync with server/all clients (<=> wait for all acks)
void sn_Sync(REAL timeout,bool sync_sn_netObjects=false); // defined in nNetObject.C

// causes the connected clients to print a message
void sn_ConsoleOut(const tString &message,int client=-1);

// causes the connected clients to print a message in the center of the screeen
void sn_CenterMessage(const tString &message,int client=-1);


// **********************************************


class nCallbackLoginLogout: public tCallback{
  static int  user;
  static bool login;
 public:
  static int User(){return user;}
  static int Login(){return login;}

  nCallbackLoginLogout(VOIDFUNC *f);
  static void UserLoggedIn(int user);
  static void UserLoggedOut(int user);
};

void sn_SendPlanned();
int sn_QueueLen(int user);

void sn_Statistics();

#endif




