/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#ifndef ArmageTron_explosion_H
#define ArmageTron_explosion_H

#include "eSound.h"
#include "eGameObject.h"

class gExplosion: public eGameObject{ // Boom!
  eSoundPlayer sound;

  REAL         createTime;

  REAL         r,g,b; // color
private:
public:
  gExplosion(eGrid *grid, const eCoord &pos,REAL time,REAL r,REAL g,REAL b);
  virtual ~gExplosion();

  virtual bool Timestep(REAL currentTime); 

  virtual void InteractWith(eGameObject *target,REAL time,int recursion=1);

  virtual void PassEdge(const eWall *w,REAL time,REAL a,int recursion=1);

  virtual void Kill();
#ifndef DEDICATED
  virtual void Render(const eCamera *cam);

  virtual void SoundMix(Uint8 *dest,unsigned int len,
			int viewer,REAL rvol,REAL lvol); 
#endif
};
#endif
