/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gMenus.h"
#include "ePlayer.h"
#include "rScreen.h"
#include "nConfig.h"
#include "rConsole.h"
#include "tToDo.h"
#include "rGL.h"
#include "eTimer.h"
#include "rRender.h"

static tConfItem<int>   tm0("TEXTURE_MODE_0","floor texture mode",TextureMode[0]);
static tConfItem<int>   tm1("TEXTURE_MODE_1","eWall texture mode",TextureMode[1]);
static tConfItem<int>   tm2("TEXTURE_MODE_2","object texture mode",TextureMode[2]);
static tConfItem<int>   tm3("TEXTURE_MODE_3","font texture mode",TextureMode[3]);



uMenu sg_screenMenu("Display Settings");

uMenu screen_menu_detail("Detail Settings");
uMenu screen_menu_tweaks("Performance Tweaks");
uMenu screen_menu_mode("Screen Mode");
uMenu screen_menu_prefs("Preferences");

static uMenuItemSubmenu smm(&sg_screenMenu,&screen_menu_mode,
			    "Screen resolution and stuff.");
static uMenuItemSubmenu smt(&sg_screenMenu,&screen_menu_tweaks,
			    "Settings that may improve game performace, "
			    "but do not work on all systems.");
static uMenuItemSubmenu smp(&sg_screenMenu,&screen_menu_prefs,
			    "Options that depend more on your personal "
			    "preferences than on performance issues.");
static uMenuItemSubmenu smd(&sg_screenMenu,&screen_menu_detail,
			    "Allows you to adjust the graphical detail "
			    "to your system's performance.");


static tConfItemLine c_ext("GL_EXTENSIONS","",gl_extensions);
static tConfItemLine c_ver("GL_VERSION","",gl_version);
static tConfItemLine c_rEnd("GL_RENDERER","",gl_renderer);
static tConfItemLine c_vEnd("GL_VENDOR","",gl_vendor);
static tConfItemLine a_ver("ARMAGETRON_VERSION","",sn_programVersion);
static tConfItemLine a_mod_1("MESSAGE_OF_DAY_1","Message sent to the clients",sn_greeting[0]);
static tConfItemLine a_mod_2("MESSAGE_OF_DAY_2","",sn_greeting[1]);
static tConfItemLine a_mod_3("MESSAGE_OF_DAY_3","",sn_greeting[2]);
static tConfItemLine a_mod_4("MESSAGE_OF_DAY_4","",sn_greeting[3]);

class ArmageTron_feature_menuitem: public uMenuItemSelection<int>{
  void NewChoice(uSelectItem<bool> *){};
  void NewChoice(char *,bool ){};
public:
  ArmageTron_feature_menuitem(uMenu *m,char *tit,const char *help,int &targ)
    :uMenuItemSelection<int>(m,tit,help,targ){
    uMenuItemSelection<int>::NewChoice("Off",
						   "\nFeature is currently "
						   "disabled.",
						   rFEAT_OFF);
    uMenuItemSelection<int>::NewChoice("System Default",
						   "\nYour system decides "
						   "what to do with it.",
						  rFEAT_DEFAULT);
    uMenuItemSelection<int>::NewChoice("On",
						   "\nFeature is currently "
						   "activated.",
						   rFEAT_ON);
  }

  ~ArmageTron_feature_menuitem(){};
};


class ArmageTron_texmode_menuitem: public uMenuItemSelection<int>{
  void NewChoice(uSelectItem<bool> *){};
  void NewChoice(char *,bool ){};
public:
  ArmageTron_texmode_menuitem(uMenu *m,char *tit,int &targ,
			      bool force=false)
    :uMenuItemSelection<int>
  (m,tit,"Selects the texture mapping mode; note how it affects the "
   "menu background. The curent state is:\n",targ){

    if(!force)
      uMenuItemSelection<int>::NewChoice
	("Off","No textures at all",-1);
#ifndef DEDICATED
    uMenuItemSelection<int>::NewChoice
      ("Nearest","Fastest but ugliest: no filtering or detail "
       "level selection is performed. Not recommended.",GL_NEAREST);

    uMenuItemSelection<int>::NewChoice
      ("Bilinear","Still ugly: textures are filtered, but still no "
       "detail level is selected. Not recommended.",GL_LINEAR);

    uMenuItemSelection<int>::NewChoice
      ("Mipmap Nearest","No filtering, but detail level (MipMap) selection. "
       "If you use software rendering and want to see textures, use this mode."
       ,GL_NEAREST_MIPMAP_NEAREST);
    uMenuItemSelection<int>::NewChoice
      ("Mipmap Bilinear","Filtering and detail level selection. Not "
       "perfect, but usable on older 3D-accelerators."
       ,GL_LINEAR_MIPMAP_NEAREST);
    uMenuItemSelection<int>::NewChoice
      ("Mipmap Trilinear","Filtering and interpolation between detail levels. "
       "Looks smoothest and is as fast as \"Mipmap Bilinear\" on most newer "
       "3D-cards. Some renderers ignore this feature.",
       GL_LINEAR_MIPMAP_LINEAR);
    #endif
  }

  ~ArmageTron_texmode_menuitem(){};
};

static tConfItem<int>     la("LINE_ANITALIAS","Enable line antialiasing",sr_lineAntialias);
static tConfItem<int>     pa("POLY_ANITALIAS","Enable polygon antialiasing",sr_polygonAntialias);
static tConfItem<int>     pc("PERSP_CORRECT","Enable perspective correction",sr_perspectiveCorrection);
static tConfItem<bool>    ab("ALPHA_BLEND","Enable alpha blending",sr_alphaBlend);
static tConfItem<bool>    ss("SMOOTH_SHADING","Enable smooth shading",sr_smoothShading);
static tConfItem<bool>    to("TEXT_OUT","Enable console text output",sr_textOut);
static tConfItem<bool>    fps("SHOW_FPS","Enable fps display",sr_FPSOut);
// tConfItem<> ("",&);
static tConfItem<int> fm("FLOOR_MIRROR","Floor mirror mode",sr_floorMirror);
static tConfItem<int> fd("FLOOR_DETAIL","Floor detail settings",sr_floorDetail);
static tConfItem<bool> hr("HIGH_RIM","Draw high rim eWalls",sr_highRim);
static tConfItem<bool> dt("DITHER","Use dithering",sr_dither);
static tConfItem<bool> us("UPPER_SKY","Draw upper sky plane",sr_upperSky);
static tConfItem<bool> ls("LOWER_SKY","Draw lower sky plane",sr_lowerSky);
static tConfItem<bool> wos("SKY_WOBBLE","Sky animation",sr_skyWobble);
static tConfItem<bool> ip("INFINITY_PLANE","Use infinite points"
#ifdef WIN32
" (Does not work properly on most Windows systems)"
#endif
,sr_infinityPlane);

static tConfItem<bool> lm("LAG_O_METER","Draw Lagg-O-Meter in network play",sr_laggometer);
static tConfItem<bool> po("PREDICT_OBJECTS","predict cycle movement in network play",sr_predictObjects);
static tConfItem<bool> t32("TEXTURES_HI","Use high color textures",sr_texturesTruecolor);

#ifndef SDL_OPENGL
#ifndef DIRTY
#define DIRTY
#endif
#endif

static uMenuItemFunction appl
(&screen_menu_mode,"Apply Changes",
 "Tries to enable the settings in this menu without exiting Armagetron. "
 "Use at your own risk.",
 &sr_ReinitDisplay);


#ifdef SDL_OPENGL
#ifdef DIRTY
static uMenuItemToggle sdl_t
(&screen_menu_mode,"Use SDL OpenGL",
 "Toggles use of the clean OpenGL initialisation routines; if disabled, "
 "Armagetron will use the dirty method that was neccesary with SDL 1.0.",
 currentScreensetting.useSDL);
#endif
#endif

static uMenuItemToggle tc_t
(&screen_menu_mode,"TrueColor",
 "Choose between 32 (on) and 16 (off) bit color depth."
 "You have to exit and reenter Armagetron or select \"Apply Changes\" " 
 "(If it is there) for "
 "this to have an effect. ",
 currentScreensetting.truecolor);

static uMenuItemToggle fs_t
(&screen_menu_mode,"Fullscreen",
"This toggles fullscreen and window mode. As with resolution changes. "
"You have to exit and reenter Armagetron or select \"Apply Changes\" " 
"(If it is there) for "
"this to have an effect. ",
 currentScreensetting.fullscreen);


static uMenuItemSelection<rResolution> res_men
(&screen_menu_mode,"Screen Resolution:",
"Selects the screen resolution. Changes will be be applied the next time "
"you start Armagetron or when you select \"Apply Changes\" (If it is there) "
"below.",
currentScreensetting.res);


static uSelectEntry<rResolution> a(res_men,"320x200","",ArmageTron_320_200);
 static uSelectEntry<rResolution> b(res_men,"320x240","",ArmageTron_320_240);
static uSelectEntry<rResolution> c(res_men,"400x300","",ArmageTron_400_300);
static uSelectEntry<rResolution> d(res_men,"512x384","",ArmageTron_512_384);
static uSelectEntry<rResolution> e(res_men,"640x480","",ArmageTron_640_480);
static uSelectEntry<rResolution> f(res_men,"800x600","",ArmageTron_800_600);
static uSelectEntry<rResolution> g(res_men,"1024x768","",ArmageTron_1024_768);
static uSelectEntry<rResolution> h(res_men,"1280x1024","",ArmageTron_1280_1024);
static uSelectEntry<rResolution> i(res_men,"1600x1200","",ArmageTron_1600_1200);
static uSelectEntry<rResolution> j(res_men,"2048x1572","",ArmageTron_2048_1572);
static uSelectEntry<rResolution> jj(res_men,"Custom",
"\nSet the variables CUSTOM_SCREEN_WIDTH and CUSTOM_SCREEN_HEIGHT in "
#ifdef WIN32
"artr.cfg "
#else
"~/.ArmageTronrc "
#endif
"to adjust you custom screen size."
,ArmageTron_Custom);

static uMenuItemToggle gm(
&screen_menu_mode,"Grab Mouse:",
"If activated, the mouse pointer is centered after every move; thus, "
"it is unable to leave the window. This option is only useful when "
"you play Armagetron in a window on a 3dfx-card; then, the display you "
"see is fullscreen, in reality you still are using only a "
"window. If you leave this window with the pointer and click, you loose "
"control over Armagetron. ",
su_mouseGrab);


static uMenuItemSelection<int> mfm
(&screen_menu_detail,
 "Floor Mirror:",
 "Which objects should have reflections on the floor?\n",
sr_floorMirror);
static uSelectEntry<int> mfma(mfm,"Off","None",rMIRROR_OFF);


static uSelectEntry<int> mfmb(mfm,"Objects only",
			      "All moving objects",
			      rMIRROR_OBJECTS);

static uSelectEntry<int> mfmc(mfm,"Objects and Walls",
			      "Everything that is important in the game",
			      rMIRROR_WALLS);

static uSelectEntry<int> mfme(mfm,"Everything!","(Currently no difference to "
"\"Objects and Walls\".)",rMIRROR_ALL);

static uMenuItemToggle fs_dither
(&screen_menu_detail,"Dithering:",
"If the color depth of your current graphic mode does not directly allow "
"the color that is to be drawn, it is simulated by mixing other colors. "
"Turning it of will improve software rendering performance on some systems; "
"in low resolution modes, turning it off will even improve the visual "
"quality (IMHO).",
 sr_dither);

static uMenuItemSelection<int> mfd
(&screen_menu_detail,"Floor Detail:",
"ArmageTron has several ways to draw the floor and the grid; "
"the better looking ones will cost you some FPS (Frames Per Second).\n",
sr_floorDetail);

static uSelectEntry<int> mfda(mfd,"No Floor",
			      "Draw nothing at all. Fastest possibility.",
			      rFLOOR_OFF);
static uSelectEntry<int> mfdb(mfd,"Just Grid",
			      "Only a grid of lines is drawn. "
			      "This option is your choice if you use "
			      "software rendering.",
			      rFLOOR_GRID);
static uSelectEntry<int> mfdc(mfd,"Textured Plane",
			      "An infinite plane is drawn, with the texture "
			      "of the grid painted on it. Recomended for "
			      "all 3D-card owners. Problem: "
			      "looking at the horizon, the grid "
			      "will loose its sharpness too fast.",
			      rFLOOR_TEXTURE);
static uSelectEntry<int> mfdd(mfd,"Dual Texture Plane",
			      "Just as in \"Textured Plane\", the floor "
			      "is an infinite textured plane. "
			      "But here, the two groups of lines are drawn "
			      "in two separate rendering steps, resulting "
			      "in a much sharper image.",
			      rFLOOR_TWOTEXTURE);


static ArmageTron_feature_menuitem pam
(&screen_menu_detail,"Polygon Antial.:",
 "Shall the contours of objects be smoothed to avoid ugly pixel stairs? "
 "Not implemented on most systems.\n",
 sr_polygonAntialias);

static ArmageTron_feature_menuitem lam
(&screen_menu_detail,"Line Antialiasing:",
"Should lines be smoothed to avoid pixel stairs?",
sr_lineAntialias);

static uMenuItemToggle  abm
(&screen_menu_detail,"Alpha Blending:",
"Alpha blending is used to display half-transparent objects such as "
"explosions and the eWalls rising behind the cycles. It does not cost "
"extra with most 3D-cards, but slows software rendering down quite a bit.",
sr_alphaBlend);

static uMenuItemToggle  ssm
(&screen_menu_detail,"Smooth Shading:",
"Makes edges appear \"round\" by adding a color gradient to the "
"surfaces. Even software rendering is not slowed down by activating this.",
sr_smoothShading);

static ArmageTron_feature_menuitem pcm
(&screen_menu_detail,"Persp. Correction:",
"Most renderers ignore this feature; if really turned off, the eWall "
"textures will be displayed horribly deformed. I really don't know why "
"I let you choose this... :)",
 sr_perspectiveCorrection);

// from cyle.C
extern bool crash_sparks;
static tConfItem<bool> cs2("SPARKS","Draw sparks when going too close to a eWall",crash_sparks);

static uMenuItemToggle  t32b
(&screen_menu_detail,"TrueColor Textures:",
"Stores the textures with 32 bit color depth instead of the default of 16 bit."
,sr_texturesTruecolor);


static ArmageTron_texmode_menuitem tmm0(&screen_menu_detail,
					TextureGroupDescription[0],
					TextureMode[0]);

static ArmageTron_texmode_menuitem tmm1(&screen_menu_detail,
					TextureGroupDescription[1],
					TextureMode[1]);

static ArmageTron_texmode_menuitem tmm2(&screen_menu_detail,
					TextureGroupDescription[2],
					TextureMode[2]);

static ArmageTron_texmode_menuitem tmm3(&screen_menu_detail,
					TextureGroupDescription[3],
					TextureMode[3],true);


static uMenuItemToggle s2
(&screen_menu_prefs,"High Rim",
 "If enabled, the rim walls will have infinite height. If not, they will "
 "be just as high as player walls.",sr_highRim);

static uMenuItemToggle us2
(&screen_menu_prefs,"Upper Sky",
 "Toggles the display of the upper sky, a solid plane similar to "
 "the floor. Turning both sky planes on hurts performance.",
sr_upperSky);

static uMenuItemToggle ls2
(&screen_menu_prefs,"Lower Sky",
 "Toggles the display of the lower sky plane, a plasma cloud. "
 "Turning both sky planes on hurts performance.",
 sr_lowerSky);

static uMenuItemToggle ws2
(&screen_menu_prefs,"Sky Movement",
 "Toggles the animation of the lower sky plane.",
 sr_skyWobble);

static uMenuItemToggle cs
(&screen_menu_prefs,"Sparks",
 "Glowing sparks fly from your vehicle whenever you nearly crash.",
 crash_sparks);


static uMenuItemToggle zt
(&screen_menu_tweaks,"Ztrick",
 "A speedup that works on most systems: instead of clearing the "
 "screen after each frame, we just draw the backgroud (floor and rim eWalls)."
 "Enable it if you do not see any problems.",sr_ZTrick);

static uMenuItemToggle infp
(&screen_menu_tweaks,"Infinity",
"Some planes (grid, sky...) have an infinite extension; if "
"this feature is enabled, they are really drawn as infinite planes. "
"Some OpenGL renderers do not seem to like this (all Windows versions I have "
"seen...); disable it if the floor or sky textures are screwed up." 
,sr_infinityPlane);


static uMenuItemFunction defaul
(&sg_screenMenu,"Load Defaults",
"This will reset all this options to the ones that suit your system best. "
"(In the opinion of this stupid program...)",
&sr_LoadDefaultConfig);




static tConfItem<bool> WRAP("WRAP_MENU","If set, you leave a menu to the top and reenter it at the bottom.",uMenu::wrap);



#ifndef DEDICATED

class gMemuItemConsole: uMenuItemString{
public:
  gMemuItemConsole(uMenu *M,tString &c):
    uMenuItemString(M,"Con:","",c){}

  virtual ~gMemuItemConsole(){}

  //virtual void Render(REAL x,REAL y,REAL alpha=1,bool selected=0);

  virtual bool Event(SDL_Event &e){
    if (e.type==SDL_KEYDOWN && 
	(e.key.keysym.sym==SDLK_KP_ENTER || e.key.keysym.sym==SDLK_RETURN)){

      con << ColorString(.5,.5,1) << " > " << *content << '\n';
      istrstream s(&((*content)[0]));
      tConfItemBase::LoadAll(s);
      
      MyMenu()->Exit();
      return true;
    }
    else if (e.type==SDL_KEYDOWN && 
	     uActionGlobal::IsBreakingGlobalBind(e.key.keysym.sym))
      return su_HandleEvent(e);
    else
      return uMenuItemString::Event(e);
  }
};

void do_con(){
  se_ChatState(true);
  sr_con.SetHeight(20,false);
  se_SetShowScoresAuto(false);
  tString c;
  
  uMenu con_menu("",false);
  gMemuItemConsole s(&con_menu,c);
  con_menu.SetCenter(-.75);
  con_menu.SetBot(-2);
  con_menu.SetTop(-.7);
  con_menu.Enter();
  
  se_ChatState(false);
  
  se_SetShowScoresAuto(true);
  sr_con.SetHeight(7,false);
}
#endif

void sg_ConsoleInput(){
#ifndef DEDICATED
  st_ToDo(&do_con);
#endif
}















class ArmageTron_viewport_menuitem:public uMenuItemInt{
public:
  ArmageTron_viewport_menuitem(uMenu *m):
    uMenuItemInt(m,"Viewports",
				"Would you like a singe player game or "
				"split the screen to allow multiplayer games?",
				rViewportConfiguration::next_conf_num,
			   0,rViewportConfiguration::s_viewportNumConfigurations-1){
    m->RequestSpaceBelow(.9);
  }

  virtual REAL SpaceRight(){return 1;}

  virtual void RenderBackground(){
    uMenuItem::RenderBackground();

    if (rViewportConfiguration::next_conf_num<0) rViewportConfiguration::next_conf_num=0;
    if (rViewportConfiguration::next_conf_num>=rViewportConfiguration::s_viewportNumConfigurations) 
      rViewportConfiguration::next_conf_num=rViewportConfiguration::s_viewportNumConfigurations-1;
    
    tString  titles[MAX_VIEWPORTS];
    
    for(int i=MAX_VIEWPORTS-1;i>=0;i--)
      titles[i] << i+1;
#ifndef DEDICATED
    rViewportConfiguration::DemonstrateViewport(titles);
#endif
  }

  virtual void Render(REAL x,REAL y,REAL alpha=1,bool selected=0){
    if (rViewportConfiguration::next_conf_num<0) rViewportConfiguration::next_conf_num=0;
    if (rViewportConfiguration::next_conf_num>=rViewportConfiguration::s_viewportNumConfigurations) 
      rViewportConfiguration::next_conf_num=rViewportConfiguration::s_viewportNumConfigurations-1;

    tString disp;
    
    disp << "Viewports : "; 
    disp << rViewportConfiguration::s_viewportConfigurationNames[rViewportConfiguration::next_conf_num];
    DisplayText(x-.02,y,disp,selected,alpha);
  }
  
};



class ArmageTronPlayer_to_viewport_menuitem:public uMenuItemInt{
  int    vp;
public:
  ArmageTronPlayer_to_viewport_menuitem(uMenu *m,int v):
    uMenuItemInt(m,"",
				"Wich player is displayed in this part of the "
				"screen?",
			   s_newViewportBelongsToPlayer[v],
			   0,MAX_PLAYERS-1),vp(v){
    m->RequestSpaceBelow(.9);
  }

  virtual REAL SpaceRight(){return 1;}

  virtual void LeftRight(int x){
    rViewport::SetDirectionOfCorrection(vp,x);
    target=(target + MAX_PLAYERS + x) % MAX_PLAYERS;
  }

  virtual void RenderBackground(){
    rViewport::CorrectViewport(vp, MAX_PLAYERS);

    uMenuItem::RenderBackground();
    
    tString titles[MAX_VIEWPORTS];
    for(int i=MAX_VIEWPORTS-1;i>=0;i--){
      titles[i] << s_newViewportBelongsToPlayer[i]+1;
      titles[i] << " (";
      titles[i] << ePlayer::PlayerConfig(s_newViewportBelongsToPlayer[i])->Name();
      titles[i] << ")";
    }
#ifndef DEDICATED
    rViewportConfiguration::DemonstrateViewport(titles);
#endif
  }
  
  virtual void Render(REAL x,REAL y,REAL alpha=1,bool selected=0){

    tString disp;
    
    disp << "Viewport ";
    disp << vp+1;
    disp << " belongs to Player ";
    disp << s_newViewportBelongsToPlayer[vp]+1;
    disp << " (";
    disp << ePlayer::PlayerConfig(s_newViewportBelongsToPlayer[vp])->Name();
    disp << ")"; 
    DisplayText(x-.02,y,disp,selected,alpha);
  }
  
};

#include "rSysdep.h"
extern void Render(int);


class ArmageTron_color_menuitem:public uMenuItemInt{
protected:
  int *rgb;
  unsigned short me;
public:
  ArmageTron_color_menuitem(uMenu *m,const char *tit,
			    const char *help, int *RGB,int Me)
    :uMenuItemInt(m,tit,help,RGB[Me],0,15),
     rgb(RGB),me(Me) {
    m->RequestSpaceBelow(.2);
  }

  ~ArmageTron_color_menuitem(){};

  virtual REAL SpaceRight(){return .2;}


  virtual void RenderBackground(){
    static int count=0;
    while(rgb[0]+rgb[1]+rgb[2]<13){
      if (rgb[count]<15)
	rgb[count]++;
      count++;
      if (count>2)
	count=0;
    }
#ifndef DEDICATED
    if (!sr_glOut)
      return;
    uMenuItem::RenderBackground();
    glColor3f(rgb[0]/15.0,rgb[1]/15.0,rgb[2]/15.0);
    glRectf(.8,-.8,.98,-.98);
#endif
  }

};



void sg_PlayerMenu(int Player){
  tString name;
  name << "Player " << Player+1 << " Settings\0" ;
  uMenu playerMenu(name);
  uMenu camera_menu("Camera Setup");
  uMenu chat_menu("Instant Chat");
  name.Clear();

  uMenuItemString *ic[MAX_INSTANT_CHAT];

  ePlayer *p = ePlayer::PlayerConfig(Player);
  if (!p)
    return;

  int i;
  for(i=MAX_INSTANT_CHAT-1;i>=0;i--){
    tString name;
    name << "Instant Chat " << i+1 << " :";
    ic[i]=new uMenuItemString
      (&chat_menu,name,
       "Sets one of the instant chat macros that can be said with one "
       "keystroke.",
       p->instantChatString[i]);
  }


  ArmageTron_color_menuitem B(&playerMenu,"Blue",
				"Lets you choose the blue component of your "
				"color.",
				p->rgb,2);

  ArmageTron_color_menuitem G(&playerMenu,"Green",
				"Lets you choose the green component of your "
				"color.",
				p->rgb,1);

  ArmageTron_color_menuitem R(&playerMenu,"Red",
			      "Lets you choose the red component of your "
			      "color.",
			      p->rgb,0);


  uMenuItemSubmenu chm(&playerMenu,&chat_menu,
				 "Set up your instant chat macros.");

  uMenuItemToggle sp
    (&playerMenu,"Spectator Mode",
     "In spectator mode, you do not control a cycle; you just watch the "
     "game as if you were already dead. The other players don't know at all "
     "that you are there; you don't appear on the score table.",
     p->spectate);
  
  uMenuItemSubmenu cm(&playerMenu,&camera_menu,
				 "Set up your camera preferences.");

  uMenuItemFunctionInt icc(&playerMenu,"Camera Input Configuration",
				     "Setup keyboard and mouse controls "
				     "for this player's camera.",
				     &su_InputConfigCamera,Player);

  uMenuItemFunctionInt inc(&playerMenu,"Input Configuration",
				     "Setup keyboard and mouse controls "
				     "for this player.",
				     &su_InputConfig,Player);




  uMenuItemToggle al_s
    (&camera_menu,
     "Allow Smartcam",
     "when pressing the camera switch button, this enables switching into "
     "the smart camera mode.",
     p->allowCam[CAMERA_SMART]);
  
  uMenuItemToggle al_f
    (&camera_menu,
     "Allow Fixed Cam",
     "when pressing the camera switch button, this enables switching into "
     "the fixed external perspective.",
     p->allowCam[CAMERA_FOLLOW]);
  

  uMenuItemToggle al_fr
    (&camera_menu,
     "Allow Free Cam",
     "when pressing the camera switch button, this enables switching into "
     "the free camera mode.",
     p->allowCam[CAMERA_FREE]);
  
  uMenuItemToggle al_i
    (&camera_menu,
     "Allow Incam",
     "when pressing the camera switch button, this enables switching into "
     "the internal camera perspective.",
     p->allowCam[CAMERA_IN]);

  uMenuItemInt cam_fov
    (&camera_menu,
     "Initial FOV:",
     "Choose your favorite FOV (Field of vision).",
     p->startFOV,30,120,5);
  
  uMenuItemSelection<eCamMode> cam_s
    (&camera_menu,
     "Initial Camera:",
     "Choose your favorite camera perspective here.",
     p->startCamera);

  cam_s.NewChoice("Internal","The view from inside your vehicle.",CAMERA_IN);
  cam_s.NewChoice("Smart","The smart chasecam.",CAMERA_SMART);
  cam_s.NewChoice("External","A fixed external perspective.",CAMERA_FOLLOW);
  cam_s.NewChoice("Free","A free floating camera.",CAMERA_FREE);

  uMenuItemToggle cis(&camera_menu,
				 "Auto Incam",
				 "On: the smartcam switches to "
				 "internal camera if you are in a tunnel\n"
				 "Off: the smartcam moves to a "
				 "top view if you are in a tunnel.",
				 p->autoSwitchIncam);

  uMenuItemToggle cim(&camera_menu,
				 "Int. Camera Movement",
				 "On: the internal camera moves and rocks "
				 "with the cycle; you can get seasick "
				 "from it...\n"
				 "Off: the internal camera stays fixed "
				 "at the position you steered your cycle to.",
				 p->wobbleIncam);

  uMenuItemToggle cic(&camera_menu,
				 "Center Int. Camera",
				 "On: every time you make a turn, the "
				 "internal camera will eFace in the direction "
				 "you turned to. Good for keyboard play.\n"
				 "Off: you alone control the direction you "
				 "look in; it is independent of the "
				 "direction you are driving. Your choice if "
				 "you use Quake-style mouselook.",
				 p->centerIncamOnTurn);

  uMenuItemString n(&playerMenu,"Name:",
			       "The ... in \"Winner: ... \". Use "
			       "cursor <left>/<right>, delete, backspace "
			       "and all the other keys.",
			       p->name);

  playerMenu.Enter();

  for(i=MAX_INSTANT_CHAT-1;i>=0;i--)
    delete ic[i];

}


VOIDFUNC viewport_menu_x;






// from gGame.C
extern int pingCharity;


void sg_PlayerMenu(){
  uMenu Player_men("Player Setup");


  uMenuItemFunction vp_selec(&Player_men,
					"Assign Viewports to Players",
					"Which player's game is seen on "
					"which part of the screen?",
					&viewport_menu_x);

  ArmageTron_viewport_menuitem vp(&Player_men);
  uMenuItemFunctionInt  *names[MAX_PLAYERS];

  int i;
  for(i=MAX_PLAYERS-1;i>=0;i--){
    tString title;
    title << "Player ";
    title << i+1;

    tString help;
    help << "Cycle and camera controls for player " << i+1;

    names[i]=new uMenuItemFunctionInt(&Player_men,
						 title,
						 help,
						 sg_PlayerMenu,i);
  }
  
  Player_men.Enter();

  //  ePlayerNetID::Update();

  for(i=MAX_VIEWPORTS-1;i>=0;i--){
    delete names[i];
  }
}




void viewport_menu_x(void){
  uMenu sg_PlayerMenu("Viewport Setup");
  
  ArmageTronPlayer_to_viewport_menuitem *select[MAX_VIEWPORTS];

  int i;
  for(i=rViewportConfiguration::s_viewportConfigurations[rViewportConfiguration::next_conf_num]->num_viewports-1;i>=0;i--){
    select[i]=new ArmageTronPlayer_to_viewport_menuitem(&sg_PlayerMenu,i);
  }

  // ArmageTron_viewport_menuitem vp(&sg_PlayerMenu);
  
  sg_PlayerMenu.Enter();
 
  for(i=rViewportConfiguration::s_viewportConfigurations[rViewportConfiguration::next_conf_num]->num_viewports-1;i>=0;i--){
    delete select[i];
  }
}


static uActionGlobal con_input("CONSOLE_INPUT","console input",
			       "lets you enter a message for the console system.");


static uActionGlobal screenshot("SCREENSHOT","screenshot",
			   "Makes a screenshot and saves it as "
                           "screenshot_X.bmp");



static bool screenshot_func(REAL x){
  if (x>0){
#ifndef DEDICATED
    sr_screenshotIsPlanned=true;
#endif
  }

  return true;
}

static bool con_func(REAL x){
  if (x>0){
    sg_ConsoleInput();
  }

  return true;
}

static uActionGlobalFunc gaf_ss(&screenshot,&screenshot_func);
static uActionGlobalFunc gaf_md(&con_input,&con_func);

static void display_fps(){
  static int fps       = 60;
  static REAL lastTime = 0;

  if (sr_FPSOut && se_mainGameTimer && 
      se_mainGameTimer->speed > .9 && 
      se_mainGameTimer->speed < 1.1)
    {
      REAL newtime = tSysTimeFloat();
      REAL ts      = newtime - lastTime;
      int newfps   = static_cast<int>(se_AverageFPS());
      if (fabs((newfps-fps)*ts)>4)
	{
	  fps      = newfps;
	  lastTime = newtime;
	}
      
      sr_ResetRenderState(true);
      Color(1,1,1);
      rTextField c(-.9,-.8);
      c << fps << " fps";
    }
}

static rPerFrameTask dfps(&display_fps);
