/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gStuff.h"
#include "eGrid.h"
#include "eWall.h"
#include "math.h"
#include "gCycle.h"
#include "rTexture.h"
#include "eTimer.h"
#include "gGame.h"
#include "rScreen.h"
#include "gWall.h"
#include "rRender.h"
#include "eCamera.h"
#include "tConfiguration.h"


#ifdef _MSC_VER
#include <float.h>
#define finite _finite
#endif

/* **********************************************
   Wall
   ********************************************** */

#ifndef DEDICATED

//texture ArmageTron_invis_eWall("eWall2.png",1,0);
static rTexture gWallRim_text(rTEX_WALL,"textures/rim_wall.png",1,1);
//static rTexture gWallRim_text_moviepack(rTEX_WALL,"moviepack/gWallRim2.png",1,0);
static rTexture gWallRim_a(rTEX_WALL,"moviepack/rim_wall_a.png",0,0);
static rTexture gWallRim_b(rTEX_WALL,"moviepack/rim_wall_b.png",0,0);
static rTexture gWallRim_c(rTEX_WALL,"moviepack/rim_wall_c.png",0,0);
static rTexture gWallRim_d(rTEX_WALL,"moviepack/rim_wall_d.png",0,0);

static rTexture *gWallRim_mp[4]={&gWallRim_a,&gWallRim_b,
				&gWallRim_c,&gWallRim_d};

static rTexture dir_eWall(rTEX_WALL,"textures/dir_wall.png",1,0);
static rTexture dir_eWall_moviepack(rTEX_WALL,"moviepack/dir_wall.png",1,0);

#endif

static REAL mp_eWall_stretch=4;
static tSettingItem<REAL> mpws
("MOVIEPACK_WALL_STRETCH",
 "The distance of the vertical lines on the moviepack walls",mp_eWall_stretch);

#ifndef DEDICATED
static void dir_eWall_select(){
  if (sg_MoviePack()){
    TexMatrix();
    IdentityMatrix();
    ScaleMatrix(1/mp_eWall_stretch,1,1);
    dir_eWall_moviepack.Select();
  }
  else
    dir_eWall.Select();
}


#endif

/* **********************************************
   RimWall
   ********************************************** */

gWallRim::gWallRim(eGrid *grid, bool backface_cull,REAL h)
  :eWallRim(grid, backface_cull, h){}

gWallRim::~gWallRim(){}
  
bool gWallRim::Splittable() const{return 1;}
void gWallRim::Split(eWall *& w1,eWall *& w2,REAL){
  w1=tNEW(gWallRim(grid));
  w2=tNEW(gWallRim(grid));
}

// from display.C
extern REAL lower_height,upper_height;

#ifndef DEDICATED


static void gWallRim_helper(eCoord p1,eCoord p2,REAL tBeg,REAL tEnd,REAL h,
			    REAL Z_SCALE,bool sw){

  if (sg_MoviePack()){
    int t=int(floor((tBeg+tEnd)/2));
    tBeg-=t;
    tEnd-=t;
    t=t%4;
    gWallRim_mp[t]->Select();
  }

  if (sw){
    Swap(p1,p2);
    Swap(tBeg,tEnd);
  }

  if (h>1000){
    if (sr_lowerSky || sg_MoviePack()) h=lower_height;
    if (sr_upperSky && !sg_MoviePack()) h=upper_height;
  }

  if (h<1000 || !sr_infinityPlane){
    BeginQuads();

    IsEdge(false);
    TexVertex(p1.x, p1.y, 0,
	      tBeg      , 1);
    
    IsEdge(true);
    TexVertex(p1.x, p1.y, h,
	      tBeg,       1-h/Z_SCALE);
    
    IsEdge(false);
    TexVertex(p2.x, p2.y, h,
	      tEnd,       1-h/Z_SCALE);

    TexVertex(p2.x, p2.y, 0,
	      tEnd      , 1);

    RenderEnd();
  }

  else{
    BeginTriangles();
    
    IsEdge(false);
    TexVertex(p1.x, p1.y, 0,
	      tBeg,       1);
    
    IsEdge(true);
    TexCoord(0,-1/REAL(Z_SCALE),0,0);
    
#ifndef WIN32
    Vertex(0,0,1,0);
#else  
    Vertex(0.001f,0.001f,1,0); // Windows OpenGL has problems with
    // infitite points perpenticular to the viewing direction
#endif
    
    TexVertex(p2.x, p2.y, 0,
	      tEnd,       1);
    RenderEnd();
  }
}

void gWallRim::RenderReal(){
  if (edge){
    const eCoord *p1=&EndPoint(0);
    const eCoord *p2=&EndPoint(1);

   
    if(bf_cull)
      glDisable(GL_CULL_FACE);

    if (fabs(p1->x - p2->x) < .001)
      Color(.7, .7, .7);
    else
      Color(1, 1, 1);

    REAL X_SCALE=100;
    REAL Z_SCALE=100;


    if (sg_MoviePack()){
      X_SCALE=50;
      Z_SCALE=50;
    }



    REAL tBeg=(p1->x+p1->y)/X_SCALE;
    REAL tEnd=(p2->x+p2->y)/X_SCALE;
    eCoord P1=*p1;
    eCoord P2=*p2;


    if (sg_MoviePack()){
      bool sw=false;
      
      if (tBeg>tEnd){
	Swap(P1,P2);
	Swap(tBeg,tEnd);
	//sw=true;
      }
      

      REAL ta=tBeg;
      eCoord ca=P1;
      for(int i=int(ceil(tBeg));i<tEnd;i++){
	eCoord cb=P1+(P2-P1)*((i-tBeg)/(tEnd-tBeg));
	gWallRim_helper(ca,cb,ta,i,height,Z_SCALE,sw);
      ca=cb;
      ta=i;
      }
      gWallRim_helper(ca,P2,ta,tEnd,height,Z_SCALE,sw);
    }
    else{
      gWallRim_text.Select();
      gWallRim_helper(*p1,*p2,tBeg,tEnd,height,Z_SCALE,false);
    }

  //eWall::Render_helper(edge,(p1->x+p1->y)/SCALE,(p2->x+p2->y)/SCALE,40,height);

    if(bf_cull)
      glEnable(GL_CULL_FACE);
  }
}

#endif

/* **********************************************
   PlayerWall
   ********************************************** */

gPlayerWall::gPlayerWall(gCycle *p,REAL st,REAL et,REAL sp,REAL ep)
  :eWall(p->grid),cycle(p),startTime(st),endTime(et),startPos(sp),endPos(ep),displayList(0)
{
#ifdef DEBUG
  if (!cycle)
    st_Breakpoint();
#endif
  /*
  if (ePlayer)
    ePlayer->AddRef();
  */
}
gPlayerWall::~gPlayerWall(){
#ifndef DEDICATED
  if(displayList!=0)
    glDeleteLists(displayList,1);
#endif
  /*
  if (ePlayer)
    ePlayer->Release();
  */
}
  
//ArmageTron_eWalltype gPlayerWall::type(){return ArmageTron_PLAYERWALL;}
  
void gPlayerWall::Flip(){
  eWall::Flip();
  Swap(endTime,startTime);
}
  
bool gPlayerWall::Splittable() const{return 1;}

bool gPlayerWall::Deletable() const{
  return  (!cycle || (!cycle->Alive() 
			 && se_GameTime()-cycle->deathTime>1));
}

void gPlayerWall::Split(eWall *& w1,eWall *& w2,REAL a){
  w1=tNEW(gPlayerWall(cycle,startTime,Time(a),startPos,Pos(a)));
  w2=tNEW(gPlayerWall(cycle,Time(a),endTime,Pos(a),endPos));
}

//#define gBEG_LEN 2
#define gBEG_LEN 1
#define gCYCLE_LEN 1.9
#define gBEG_OFFSET 1

#ifndef DEDICATED
void gPlayerWall::Render(){
  if (!cycle)
    return;
  RenderList(true);
}

void gPlayerWall::RenderList(bool list){
  if (displayList && cycle->Alive() && list)
    glCallList(displayList);
  else if (edge){  
    dir_eWall_select();
    

    REAL r,g,b;
    if (cycle){
      r=cycle->r;
      g=cycle->g;
      b=cycle->b;
    }
    else
      r=g=b=1;

    REAL a=1;
    eCoord p1=EndPoint(0);
    eCoord p2=EndPoint(1);
    
    if (fabs(p1.x - p2.x) < .5*fabs(p1.y - p2.y)){
      r*=REAL(.7);
      g*=REAL(.7);
      b*=REAL(.7);
    }

    #define SEGLEN 10
    //REAL ta=startTime*3;
    //REAL te=endTime*3;
    REAL ta=startPos/SEGLEN;
    REAL te=endPos/SEGLEN;
    //REAL shift=REAL(floor((ta+te)/20)*10);
    
    //REAL time=ArmageTronTimer*3;
    REAL time;
    if (cycle)
      time=cycle->distance/SEGLEN;
    else
      time=0;

    //ta-=shift;
    //te-=shift;
    //time-=shift;
    
    if (ta>te){
      Swap(ta,te);
      Swap(p1,p2);
    }
    
    if (te+gBEG_LEN<=time){
      /*      if (!ePlayer->Alive())
	RenderNormal(p1,p2,ta,te,r,g,b,a);
      else if (list){
	displayList=glGenLists(1);
	glNewList(displayList,GL_COMPILE_AND_EXECUTE);
	RenderNormal(p1,p2,ta,te,r,g,b,a);
	glEndList();
	}
	else */
	RenderNormal(p1,p2,ta,te,r,g,b,a);
    }
    
    else{ // complicated
      if (ta+gBEG_LEN>=time){
	RenderBegin(p1,p2,ta,te,
			 1+(ta-time)/gBEG_LEN,
			 1+(te-time)/gBEG_LEN,
			 r,g,b,a);
      }
      else{
	REAL s=((time-gBEG_LEN)-ta)/(te-ta);
	eCoord pm=p1+(p2-p1)*s;
	RenderBegin(pm,p2,
			 ta+(te-ta)*s,te,0,
			 1+(te-time)/gBEG_LEN,
			 r,g,b,a);
	RenderNormal(p1,pm,ta,ta+(te-ta)*s,r,g,b,a);
      }
    }
  }
}


bool upperlinecolor(REAL r,REAL g,REAL b){
  if (TextureMode[rTEX_WALL]<0)
    glColor3f(1,1,1);
  else{
    /*
    REAL upperline_alpha=fabs(se_cameraRise*2);
    upperline_alpha-=1;
    if (upperline_alpha>.5)
      upperline_alpha=1;
    if (upperline_alpha<=.5)
      return false;
    glColor4f(r,g,b,upperline_alpha);
    */
    //glDisable(GL_TEXTURE);
    glDisable(GL_TEXTURE_2D);
    glColor3f(r,g,b);
  }
  return true;
}

void gPlayerWall::RenderNormal(const eCoord &p1,const eCoord &p2,REAL ta,REAL te,REAL r,REAL g,REAL b,REAL a){
  REAL hfrac=1;

  if (bool(cycle) && !cycle->Alive()){
    REAL dt=(se_GameTime()-cycle->deathTime)*2;
    if (dt>1) dt=1;
    if (dt<0) dt=0;
    
    REAL ca=REAL(.5/(dt+.5));
    REAL alpha=1-dt;
    if (alpha>1) alpha=1;
    hfrac=1-dt;

    r+=ca;
    b+=ca;
    g+=ca;

    a*=alpha;
  }      
    REAL h=4;


  if (hfrac>0){
    if(upperlinecolor(r,g,b)){
      
      // draw additional upper line
      BeginLines();
      
      sr_DepthOffset(true);
      glVertex3f(p1.x,p1.y,h*hfrac);
      glVertex3f(p2.x,p2.y,h*hfrac);
      sr_DepthOffset(false);
      
      RenderEnd();
      glDisable(GL_POLYGON_OFFSET_LINE);
    }
    
    //glColor4f(r,g,b,a);
    
    dir_eWall_select();
    
    glColor3f(r,g,b);
  
  
    BeginQuads();
    glEdgeFlag(GL_FALSE);
    glTexCoord2f(ta,hfrac);
    glVertex3f(p1.x,p1.y,0);
    
    glEdgeFlag(GL_TRUE);
    glTexCoord2f(ta,0);
    glVertex3f(p1.x,p1.y,h*hfrac);
    
    glEdgeFlag(GL_FALSE);
    glTexCoord2f(te,0);
    glVertex3f(p2.x,p2.y,h*hfrac);
    
    glTexCoord2f(te,hfrac);
    glVertex3f(p2.x,p2.y,0);
    RenderEnd();
  }
}

static inline REAL hfunc(REAL x){return 1-(x*x)/2;}
static inline REAL cfunc(REAL x){return (x*x);}
//static inline REAL afunc(REAL x){return 1-(x*x)/2;}
static inline REAL afunc(REAL x){return 1-(x*x);}
static inline REAL sfunc(REAL x){return (x*x);}
//static inline REAL xfunc(REAL x){return (x+x*x)/2;}
static inline REAL xfunc(REAL x){return REAL((x*.2+x*x)/2);}

void gPlayerWall::RenderBegin(const eCoord &p1,const eCoord &pp2,REAL ta,REAL te,REAL ra,REAL re,REAL r,REAL g,REAL b,REAL a){
  REAL hfrac=1;

  eCoord p2 = pp2;

  if (re > 1){
    if (re > 2)
      return;

    REAL ratio = (1-ra)/(re-ra);
    p2 = p1 + (pp2-p1)*ratio;
    te = ta + (te-ta)*ratio;
    re= 1;
  }

  if (bool(cycle) && !cycle->Alive()){
    REAL dt=(se_GameTime()-cycle->deathTime)*2;
    if (dt>1) dt=1;
    if (dt<0) dt=0;

    REAL ca=REAL(.5/(dt+.5));
    REAL alpha=1-dt;
    if (alpha>1) alpha=1;
    hfrac=1-dt;

    r+=ca;
    b+=ca;
    g+=ca;

    //a*=alpha;
  }      


  REAL h=4;

  eCoord ppos=cycle->pos-cycle->dir*REAL(gCYCLE_LEN*2);

  if (hfrac>0 && upperlinecolor(r,g,b)){
    sr_DepthOffset(true);
    //REAL H=h*hfrac;
#define segs 5
    BeginLineStrip();
    
    for(int i=0;i<=segs;i++){
      REAL frag=i/float(segs);
      REAL rat=ra+frag*(re-ra);
      REAL x=(p1.x+frag*(p2.x-p1.x))*(1-xfunc(rat))+ppos.x*xfunc(rat);
      REAL y=(p1.y+frag*(p2.y-p1.y))*(1-xfunc(rat))+ppos.y*xfunc(rat);
      
      REAL H=h*hfrac*hfunc(rat);
      glVertex3f(x+H*cycle->skew*sfunc(rat)*cycle->dir.y,
		 y-H*cycle->skew*sfunc(rat)*cycle->dir.x,
		 H);//+se_cameraZ*.005);
    }
    RenderEnd();
    sr_DepthOffset(false);
  }
    
  dir_eWall_select();
  
  
  BeginQuadStrip();
    
    
    
    //REAL H=h*hfrac;
    
    //ppos=ePlayer->pos-ePlayer->dir*gCYCLE_LEN*2;
    
  for(int i=0;i<=segs;i++){
    REAL frag=i/float(segs);
    REAL rat=ra+frag*(re-ra);
    REAL x=(p1.x+frag*(p2.x-p1.x))*(1-xfunc(rat))+ppos.x*xfunc(rat);
    REAL y=(p1.y+frag*(p2.y-p1.y))*(1-xfunc(rat))+ppos.y*xfunc(rat);

    // bottom
    glEdgeFlag(GL_FALSE);
    glColor4f(r+cfunc(rat),g+cfunc(rat),b+cfunc(rat),a*afunc(rat));
    glTexCoord2f(ta+(te-ta)*frag,hfrac);
    glVertex3f(x,y,0);

    // top

    glEdgeFlag(GL_TRUE);
    //glTexCoord2f(ta+(te-ta)*frag,hfrac*(1-hfunc(rat)));
    glTexCoord2f(ta+(te-ta)*frag,0);
    REAL H=h*hfrac*hfunc(rat);
    glVertex3f(x+H*cycle->skew*sfunc(rat)*cycle->dir.y,
	       y-H*cycle->skew*sfunc(rat)*cycle->dir.x,
	       H);
  }
  RenderEnd();
}
#endif

void gPlayerWall::SetEndTime(REAL t){
  endTime=t;
}

void gPlayerWall::SetEndPos(REAL ep){
  endPos=ep;
}

REAL gPlayerWall::BlockHeight() const{
  if (bool(cycle) && cycle->Alive()==1)
    return 4;
  else
    return 0;
}

REAL gPlayerWall::SeeHeight() const{
  return BlockHeight();
}


gCycle *gPlayerWall::Cylce() const {return cycle;}

REAL gPlayerWall::Time(REAL a) const{return startTime + a*(endTime-startTime);}

// ************************************************
// ************************************************


List<gNetPlayerWall> sg_netPlayerWalls;
List<gNetPlayerWall> gridded_sg_netPlayerWalls;


void gNetPlayerWall::InitAfterCreation(){
  nNetObject::InitAfterCreation();
  MyInitAfterCreation();
}

void gNetPlayerWall::MyInitAfterCreation(){
  //w=
#ifdef DEBUG
  if (!finite(end.x) || !finite(end.y))
    st_Breakpoint();

  if (!finite(beg.x) || !finite(beg.y))
    st_Breakpoint();
#endif

  e=tNEW(eTempEdge)(beg,
		    end,
		    tNEW(gPlayerWall)
		    (c,
		     tBeg,tEnd,
		     dbegin,REAL(dbegin+sqrt((beg-end).Norm_squared()))));

  assert(Wall() && Wall()->Splittable());

  for(int i=MAX_VIEWERS-1;i>=0;i--)
    Wall()->SetVisHeight(i,0);

  Wall()->Remove();

  id=-1;
  griddedid=-1;
  sg_netPlayerWalls.Add(this,id);

  //  if (e){
  //  e->p[0]->AddRef();
  //  e->Point(1)->AddRef();
  //}

  //c->AddRef();

  /*
  if (sn_GetNetState()==nSERVER)
    RequestSync();
  */

  /*
  if (c && c->currentWall !=this && c->currentWallID==nNetObject::id){
    if(c->currentWall){
      //c->currentWall->CopyIntoGrid();
      c->currentWall->AddRef();
      c->currentWall->Release();
      //delete c->currentWall;
      //con << "eWall auto-entry..\n";
    }
    c->currentWall=this;
  }
  */
  if (!preliminary){
    // delete the appropriate preliminary eWall
    for (int i=sg_netPlayerWalls.Len()-1;i>=0;i--){
      gNetPlayerWall *o=sg_netPlayerWalls[i];
      if (o!=this && o->preliminary && o->dbegin + 40 < dbegin && o->c == c)
	o->real_CopyIntoGrid(c->Grid());
    }
  }
}



gNetPlayerWall::gNetPlayerWall(gCycle *cyc,
		  const eCoord &begi,const eCoord &d,
		  REAL tBegi, REAL dbeg)
  :nNetObject(-1),
   c(cyc),dir(d),dbegin(dbeg),
   beg(begi),end(begi),tBeg(tBegi),tEnd(tBegi),
   inGrid(false){
  dir=dir*REAL(1/sqrt(dir.Norm_squared()));
  preliminary=(sn_GetNetState()==nCLIENT);
  MyInitAfterCreation();
}

void gNetPlayerWall::Update(REAL Tend,REAL dend){
  if (!inGrid){
    tEnd=Tend;
    end=beg + dir*(dend-dbegin);

#ifdef DEBUG
    if (!finite(end.x) || !finite(end.y))
      st_Breakpoint();
#endif

    if (e)
      e->Coord(1) = end;

    gPlayerWall *w = Wall();
    if (w){
      w->SetEndTime(tEnd);
      w->SetEndPos(dend);
      w->CalcLen();
    }
  }
}

void gNetPlayerWall::Update(REAL Tend,const eCoord &pend){
  if (!inGrid){
    tEnd=Tend;
    end=pend;

#ifdef DEBUG
    if (!finite(end.x) || !finite(end.y))
      st_Breakpoint();
#endif
    
    eCoord odir=dir.Turn(0,1);
    REAL x=eCoord::F(odir,(end-beg));
    beg=beg+odir*x;

    if (e && e->Point(0) && e->Point(1)){
      e->Coord(1) = end;
      e->Coord(0) = beg;
    }

    gPlayerWall *w = Wall();

    if (w){
      w->SetEndTime(tEnd);

      if (Cycle())
	w->SetEndPos(REAL(dbegin+sqrt((beg-end).Norm_squared())));
      else
	w->SetEndPos(Cycle()->distance);

      w->CalcLen();
    }
  }
}

void gNetPlayerWall::CopyIntoGrid(bool force){
  if (!inGrid && (force ||
      (sn_GetNetState()!=nCLIENT || preliminary))){
    inGrid=true;
    gridding=REAL(se_GameTime()+.5);
    if (sn_GetNetState()==nSERVER)
      RequestSync();
    else
      gridding=se_GameTime()+2*sn_Connections[0].ping+.5;
  }
}

void gNetPlayerWall::real_CopyIntoGrid(eGrid *grid){
  //  con << "Gridding " << ID() << " : ";
  //con << "from " << *e->Point(0) << " to " << *e->Point(1) << '\n';

#ifdef DEBUG
  grid->Check();
#endif

  if(griddedid<0){
    assert(e);
    assert(Wall());
    assert(Wall()->Splittable());

    if (preliminary){
      //delete this; // get rid of it
      AddRef();Release();
    }
    else{
      gridded_sg_netPlayerWalls.Add(this,griddedid);
      sg_netPlayerWalls.Remove(this,id);
      if (e){
	e->CopyIntoGrid(c->Grid());
	//	Wall()->Insert();
	tDESTROY(e);
      }
    }
    
  }

#ifdef DEBUG
  grid->Check();
#endif

}

void gNetPlayerWall::s_CopyIntoGrid(){
#ifdef DEBUG
  static int maxw=20;
  if (sg_netPlayerWalls.Len()>maxw)
    con << "Many walls: " << (maxw=sg_netPlayerWalls.Len()) << '\n';
#endif

  for(int i=sg_netPlayerWalls.Len()-1;i>=0;i--){
    gNetPlayerWall *w=sg_netPlayerWalls(i);
    if (w->inGrid && w->griddedid<0 && se_GameTime()>w->gridding)
      w->real_CopyIntoGrid(w->c->Grid());
  }
}

void gNetPlayerWall::WriteCreate(nMessage &m){
  nNetObject::WriteCreate(m);
  m.Write(c->ID());
  m << beg;
  m << dir;
  m << dbegin;
  m << tBeg;
  m << static_cast<int>(preliminary);
}

gNetPlayerWall::gNetPlayerWall(nMessage &m)
  :nNetObject(m),
   c(NULL),e(NULL),//w(NULL),
  dir(0,0),dbegin(0),
  beg(0,0),end(0,0),
  tBeg(0),tEnd(0),
  inGrid(0)
{
  unsigned short cid;
  m.Read(cid);
  c=static_cast<gCycle *>(ObjectDangerous(cid));

  if (!c)
    st_Breakpoint();

  m >> beg;
  end=beg;
  m >> dir;
  m >> dbegin;

  m >> tBeg;
  m >> reinterpret_cast<int &>(preliminary);
}

gNetPlayerWall::~gNetPlayerWall(){
  if (c){
    if (c->currentWall==this)
      c->currentWall=NULL;
    if (c->lastWall==this)
      c->lastWall=NULL;
    
    //c->Release();
  }

  // tDESTROY(w);
  
  if (e){
    //    e->Point(0)->Release();
    // e->Point(1)->Release();
    //    ePoint *p1=e->Point(0);
    //    ePoint *p2=e->Point(1);
    tDESTROY(e);  // w will be deleted with e
    //    tDESTROY_PTR(p1); 
    //    tDESTROY_PTR(p2); 
  }

  c=NULL;
  e=NULL;
  //w=NULL;
  sg_netPlayerWalls.Remove(this,id);
  gridded_sg_netPlayerWalls.Remove(this,griddedid);
}

bool gNetPlayerWall::ActionOnQuit(){
  return false;
}

bool gNetPlayerWall::ClearToTransmit(int user) const{
  return GridIsReady(user) && nNetObject::ClearToTransmit(user)
    && bool(c) && c->HasBeenTransmitted(user) && inGrid;
}

void gNetPlayerWall::WriteSync(nMessage &m){
  /*
  con << "Writing sync " << ID() << " : ";
  con << "from " << beg << " to " << end ;
  if (inGrid)
    con << ": gridded\n";
  else
    con << '\n';
  */
  nNetObject::WriteSync(m);

  if (inGrid){
    m << end; // the far end of the eWall
    m << tEnd; // the endTime
  }
  else{
    m << beg;
    m << tBeg;
  }
  m.Write(inGrid);
}

bool gNetPlayerWall::SyncIsNew(nMessage &m){
  return (nNetObject::SyncIsNew(m) && !inGrid);
}

void gNetPlayerWall::ReadSync(nMessage &m){
  nNetObject::ReadSync(m);
  m >> end;
  m >> tEnd;

  Update(tEnd,end);

  unsigned short new_inGrid;
  m.Read(new_inGrid);

  /*
  con << "Read sync " << ID() << " : ";
  con << "from " << beg << " to " << end ;
  if (new_inGrid)
    con << ": gridded\n";
  else
    con << '\n';
  */

  if(Wall() && new_inGrid && !inGrid)
    CopyIntoGrid(true);


}

static nNOInitialisator<gNetPlayerWall> gNetPlayerWall_init(25,"gNetPlayerWall");

nDescriptor &gNetPlayerWall::CreatorDescriptor() const{
  return gNetPlayerWall_init;
}

void gNetPlayerWall::Clear(){
  int i;
  for(i=sg_netPlayerWalls.Len()-1;i>=0;i--){
    sg_netPlayerWalls(i)->owner=sn_myNetID;
    delete sg_netPlayerWalls(i);
  }
  for(i=gridded_sg_netPlayerWalls.Len()-1;i>=0;i--){
    gridded_sg_netPlayerWalls(i)->owner=sn_myNetID;
    delete gridded_sg_netPlayerWalls(i);
  }
}




