/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gAICharacter.h"
#include "tDirectories.h"
#include <fstream>

tArray<gAICharacter> gAICharacter::s_Characters(0);

static REAL weight[AI_PROPERTIES]=
{
  10,
  10,
  10,
  10,
  10,
  10,
  10,
  10,
  10,
  10,
  0,
  0,
  0
};

// load this description from a stream. Return value: success or not?
bool gAICharacter::Load(std::istream& file)
{
  file >> name;

  iq  = 1;
  REAL iqt = 1;

  for (int i=0; i< AI_PROPERTIES; i++)
    {
      file >> properties[i];
      iq  += properties[i] * weight[i];
      iqt += weight[i];
    }
  iq *= 10/iqt;

  if (file.eof())
    return false;

  description.ReadLine(file);
  return true;
}

void gAICharacter::LoadAll(const tString& filename)
{
	std::ifstream f;

	if ( tDirectories::Config().Open( f, filename ) )
	{
		bool goon = true;
  
		while (goon)
		{
			tString s;
			s.ReadLine(f);
			goon = (s[0] == '#');
		}
  
		goon = true;
		while (goon)
		{
			int i = s_Characters.Len();
			gAICharacter& c = s_Characters[i];
			goon = c.Load(f);

			if (!goon)
				s_Characters.SetLen(i);
			else if (f.eof() || !f.good()) 
				goon = false;
		}
	}
}

