/*

*************************************************************************

ArmageTron -- Just another Tron Lightcycle Game in 3D.
Copyright (C) 2000  Manuel Moos (manuel@moosnet.de)

**************************************************************************

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  
***************************************************************************

*/

#include "gExplosion.h"
#include "rModel.h"
#include "rRender.h"
#include "tInitExit.h"
#include "gWall.h"
#include "gCycle.h"

static eWavData explode("moviesounds/dietron.wav","sound/expl.wav");

static tList< gExplosion > sg_Explosions;

int	gExplosion::expansionSteps=5;
REAL gExplosion::expansionTime = 0.2f;

static eCoord s_explosionCoord;
static REAL   s_explosionRadius;
static REAL	  s_explosionTime;

// blow a hole centered at s_explosionCoord with radius s_explosionRadius into wall w
static void S_BlowHoles( eWall * w )
{
	// determine the point closest to s_explosionCoord
	eCoord normal = w->Vec().Conj();
	normal.Normalize();

	eCoord Pos1 = normal.Turn( w->EndPoint(0) - s_explosionCoord );
	eCoord Pos2 = normal.Turn( w->EndPoint(1) - s_explosionCoord );

	tASSERT( fabs( Pos1.y - Pos2.y ) <= fabs( Pos1.y + Pos2.y + .1f ) * .1f ); 

	REAL alpha = Pos1.x / ( Pos1.x - Pos2.x );

	REAL radius = s_explosionRadius * s_explosionRadius - Pos1.y * Pos2.y;

	// wall too far away
	if ( radius < 0 )
		return;

	radius = sqrt( radius );

	// works only for player walls
	gPlayerWall* wall = dynamic_cast<gPlayerWall*>( w );
	if ( ! wall )
		return;

	REAL closestPos = wall->Pos( alpha );

	REAL start = closestPos - radius;
	REAL end = closestPos + radius;

	// only cut away walls that were created before the explosion started
	REAL wallEnd = wall->EndPos();
	REAL wallBeg = wall->BegPos();
	if ( wallEnd <= wallBeg )
	{
		return;
	}
	REAL endAlpha = ( end - wall->BegPos() ) / ( wallEnd - wallBeg );
	REAL endTime = wall->Time( endAlpha );
	if ( endTime > s_explosionTime )
	{
		REAL begTime = wall->BegTime();
		REAL endTime = wall->EndTime();
		REAL timeNorm = endTime - begTime;
		if ( timeNorm != 0.0f )
		{
			endAlpha = ( s_explosionTime - begTime ) / timeNorm;
			end = wall->Pos( endAlpha );
		}
	}

	if ( end > start )
	{
		wall->BlowHole ( start, end );
	}
}

/*
// synchronize walls affected by explosion
static void S_Sync( eWall * w )
{
	// works only for player walls
	gPlayerWall* wall = dynamic_cast<gPlayerWall*>( w );
	if ( ! wall )
		return;

	wall->RequestSync ();
}
*/

gExplosion::gExplosion(eGrid *grid, const eCoord &pos,REAL time, gRealColor& color)
	:eGameObject(grid, pos, eCoord(0,0), NULL, true),
	 sound(explode),
	 createTime(time),
	 expansion(0),
	 listID(-1)
{
	sound.Reset();
	sg_Explosions.Add( this, listID );
}

gExplosion::~gExplosion(){
	sg_Explosions.Remove( this, listID );

	if ( s_explosionRadius > 0 )
	{
		/*
		s_explosionCoord  = pos;
		s_explosionRadius = gCycle::ExplosionRadius()*1.5f;

		grid->ProcessWallsInRange( &S_Sync,
								   s_explosionCoord,
								   s_explosionRadius,
								   this->CurrentFace() );
		*/
	}
}

// virtual eGameObject_type type();

bool gExplosion::Timestep(REAL currentTime){
	lastTime=currentTime;

	int currentExpansion = int(REAL( expansionSteps )*((currentTime - createTime)/expansionTime)) + 1;
	if ( currentExpansion > expansionSteps )
		currentExpansion = expansionSteps;

	if ( currentExpansion > expansion )
	{
		expansion = currentExpansion;

		s_explosionCoord  = pos;
		REAL factor = expansion / REAL( expansionSteps );
		s_explosionRadius = gCycle::ExplosionRadius() * sqrt(factor);
		s_explosionTime = createTime;

		if ( s_explosionRadius > 0 )
		{
			grid->ProcessWallsInRange( &S_BlowHoles,
									   s_explosionCoord,
									   s_explosionRadius,
									   this->CurrentFace() );
		}

	}

/*
	// see every once in a while if all cycles did a turn since the expl was created
	if ( expansion >= expansionSteps )
	{
		currentExpansion = expansionSteps + 1 + int( REAL( expansion ) * ( currentTime - createTime ) );
	}
	if ( currentExpansion > expansion )
	{
		expansion = currentExpansion;
		REAL time = createTime + 5.0f;
		
		const tList<eGameObject>& gameObjects = this->Grid()->GameObjects();
		for ( int i = gameObjects.Len() - 1; i>=0; --i )
		{
			eGameObject* o = gameObjects( i );

			gCycle* c = dynamic_cast< gCycle* >( o );
			if ( c && c->Alive() )
			{
				const gPlayerWall* w = c->CurrentWall();

				if ( !w	|| w->BegTime() < time || w->EndTime() < time )
				{	
					// c has not made a turn; we need to stay around some more
					return false;
				}
			}
		}
	}
*/

	if (currentTime>createTime+4)
		return true;
	else
		return false;
}

void gExplosion::InteractWith(eGameObject *,REAL ,int){}

void gExplosion::PassEdge(const eWall *,REAL ,REAL ,int){}

void gExplosion::Kill(){createTime=lastTime-100;}

void gExplosion::OnNewWall( eWall* w )
{
	for ( int i = sg_Explosions.Len() - 1; i>=0; --i )
	{
		const gExplosion* e = sg_Explosions(i);
		if ( e->expansion >= expansionSteps )
		{
			// e is a already completed explosion
			s_explosionCoord  = e->pos;
			s_explosionRadius = gCycle::ExplosionRadius();
			s_explosionTime = e->createTime;

			S_BlowHoles( w );
		}
	}
}

static tArray<Vec3> expvec;

static void init_exp(){
	int i=0;
	expvec[i++]=Vec3(0,0,1);
	expvec[i++]=Vec3(0,1,1);
	expvec[i++]=Vec3(0,-1,1);
	expvec[i++]=Vec3(1,0,1);
	expvec[i++]=Vec3(-1,0,1);
	expvec[i++]=Vec3(1,1,1);
	expvec[i++]=Vec3(-1,1,1);
	expvec[i++]=Vec3(1,-1,1);
	expvec[i++]=Vec3(-1,-1,1);

	const REAL fak=7;

	for(int j=i;j<40;j++){
		expvec[i++]=Vec3(fak*(rand()/static_cast<REAL>(RAND_MAX)-.5f),
						 fak*(rand()/static_cast<REAL>(RAND_MAX)-.5f),
						 1);
	}

	for(int k=expvec.Len()-1;k>=0;k--)
		expvec[k]=expvec[k]*(1/expvec[k].Norm());
}

static tInitExit ie_exp(&init_exp);

#ifndef DEDICATED
void gExplosion::Render(const eCamera *cam){
	REAL a1=(lastTime-createTime)+.2;
	REAL e=a1-1;

	if (e<0) e=0;

	REAL fade=(2-a1);
	if (fade<0) fade=0;
	if (fade>1) fade=1;

	a1*=100;
	e*=100;

	ModelMatrix();
	glPushMatrix();
	glTranslatef(pos.x,pos.y,0);
  
	//glDisable(GL_TEXTURE);
	glDisable(GL_TEXTURE_2D);

	glColor4f(1,1,1,fade);
	BeginLines();
	for(int i=expvec.Len()-1;i>=0;i--){
		glVertex3f(a1*expvec[i].x[0],a1*expvec[i].x[1],a1*expvec[i].x[2]);
		glVertex3f( e*expvec[i].x[0], e*expvec[i].x[1], e*expvec[i].x[2]);
	}
	RenderEnd();
	glPopMatrix();

	/*
	  if(sr_alphaBlend)
	  for(int i=2;i>=0;i--){
      REAL age=a1-i*.1;
      if (0<age && age<.5){
	  REAL alpha=(3-i)*.5*(1-age*2)*(1-age*2);
	  glColor4f(r,g,b,alpha);
	  glDisable(GL_LIGHTING);
	  glDisable(GL_TEXTURE_2D);
	  glMatrixMode(GL_MODELVIEW);
	  glPushMatrix();
	  glTranslatef(pos.x,pos.y,age*pow((age+1),3)*(age+.5)*100);
	  y	
	
	  GLUquadricObj* q= gluNewQuadric();
	
	  gluSphere(q,(age*pow((age+1),3)*(age+.5))*100,5,5);
	
	  gluDeleteQuadric( q );
	
	  glPopMatrix();
      }
	  }
	*/
}

void gExplosion::SoundMix(Uint8 *dest,unsigned int len,
						  int viewer,REAL rvol,REAL lvol){
	sound.Mix(dest,len,viewer,rvol*4,lvol*4);
}
#endif

