/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __CDINFOWAITDLG_H__
#define __CDINFOWAITDLG_H__

#include "socket.h"
#include "cdinfo.h"

/*========================================================*/

class ArsonCdInfoWaitDlg : public ArsonSocketWaitDlg
{
public:
	ArsonCdInfoWaitDlg (const ArsonCdInfo &info);
	
	const ArsonCdInfo &cdInfo (void) const { return m_info; }

protected:
	virtual void handleStream (QTextStream *pStream) = 0;
	virtual void slotCompleted (ArsonSocket *pThis);

	ArsonCdInfo m_info;
};

/*========================================================*/
#endif	/*	__CDINFOWAITDLG_H__	*/
