/* :: ascii-jump project
   :: $Id: matrix.c,v 1.1.1.1 2003/02/28 10:05:04 loth Exp $

   :: (C)opyright 2003  grzegorz moskal, g.moskal@opengruop.org
   :: license gnu gpl v 2						*/


#define MATRIX_C
#include "matrix.h"
#define START (53)
static struct column *first, *last;

static int matrix_width;
static int matrix_height;
static int matrix_x;
static int matrix_y;
static int matrix_color_normal;
static int matrix_color_shine;
int matrix_mode = SNOW;

static void column_flush(struct column *c)
{
	int i = 0;

	for (; i < matrix_height; i++)
		c->caption[i] = ' ';
	c->caption[i] = '\0';
	
	c->last_y = 0;
	c->height = 0;
	c->shine = (d(5) == 5);
	c->stop = 1;
	c->draw = 1;
	c->cut = 0;
	c->async = 0;
	c->async_pattern = d(2)+1;
}

void matrix_init(int x, int y, int w, int h)
{
	struct column *c;
	int i = 0;

	matrix_x = x;
	matrix_y = y;
	matrix_width = w;
	matrix_height = h;
	
	matrix_color_normal = (matrix_mode < MATRIX_FULL) ? Black : Gray;
	matrix_color_shine = (matrix_mode < MATRIX_FULL) ? Gray : White;

	
	for (; i < w; i++) {
		c = xmalloc(sizeof(struct column));
		c->height = h;
		c->caption = xmalloc(sizeof(char)*(c->height+1));
		c->next = 0;
		column_flush(c);
		if (first) {
			last->next = c;
			last = last->next;
		} else
			first = last = c;
	}
	for (i = 40; i; i--)
		matrix_service();
}

void matrix_free()
{
	struct column *tmp, *c = first;
	while (c) {
		tmp = c;
		SWITCH(c);
		xfree(tmp->caption);
		xfree(tmp);
	}
	first = last = NULL;
}

static void column_check_grow(struct column *c)
{
	int p = -1;
	int i = matrix_height/2;

	for (; i < matrix_height; i+=4)
		if (c->height == i)
			p = 3*i;
	
	if (d(100) <= p)  
		c->cut = 1;
}

static void column_service(struct column *c)
{
	if (c->stop) {
		c->stop = d(START)-1;
		return;
	}

	if (c->async > 0)
		c->async--;
	else {
		c->async = d(c->async_pattern);
		if (c->draw) {
			column_check_grow(c);
			c->caption[c->last_y] = d(93) + 33;
			c->last_y++;
			c->height++;
		} 
		if (c->cut)
			c->caption[c->last_y - c->height--] = ' ';
	}

	if (c->last_y >= matrix_height-1) {
		c->draw = 0;
		c->cut = 1;
	}
	
	if (c->height == 0 && c->cut == 1) 
		column_flush(c);
}

void matrix_service(void)
{
	struct column *c = first;

	for (c = first; c; c = c->next)
		column_service(c);

	for (c = first; c; c = c->next)
		column_service(c);
}

static void column_draw(struct column *c, int x)
{
	char *tab = ".";
	int len = strlen(tab);
	int h = 0;
	
	sl_color(matrix_color_normal);
	
	for (; h < matrix_height; h++) {
		sl_goto(x, h+matrix_y);
		if (h+1 == c->last_y) {
			sl_color(matrix_color_shine);
			if (matrix_mode != SNOW)
				sl_putch(c->caption[h]);
			else 
				sl_putch(tab[d(len)-1]);
			sl_color(matrix_color_normal);
		} else 
			sl_putch(c->caption[h]);
	}
}

void matrix_draw(void)
{
	struct column *c = first;
	int x = matrix_x;
	
	for (; c; c = c->next) 
		column_draw(c, x++);
}

void matrix_move(int n)
{
	struct column *tmp;
	while (n--) {
		tmp = first;
		first = first->next;
		last->next = tmp;
		last = last->next;
		last->next = 0;
	}
}

void matrix_change_mode(int c_normal, int c_shine, int mode)
{
	matrix_mode = mode;
	matrix_color_normal = c_normal;
	matrix_color_shine = c_shine;
}


