#ifndef protocolesoundspech
#define protocolesoundspech

#define PROTOCOL_ESOUND_INET_PORT 16001

/* length of the authorization key, octets */
#define ESD_KEY_LEN 16
#define ESD_NAME_MAX 128

#define ESD_ENDIAN_KEY ((guint32) (('E' << 24) + ('N' << 16) + ('D' << 8) + ('N')))
#define ESD_SWAP_ENDIAN_KEY GUINT32_SWAP_LE_BE(ESD_ENDIAN_KEY)

typedef enum { 
    ESD_PROTO_CONNECT,      /* implied on inital client connection */

    /* pseudo "security" functionality */
    ESD_PROTO_LOCK,         /* disable "foreign" client connections */
    ESD_PROTO_UNLOCK,       /* enable "foreign" client connections */

    /* stream functionality: play, record, monitor */
    ESD_PROTO_STREAM_PLAY,  /* play all following data as a stream */
    ESD_PROTO_STREAM_REC,   /* record data from card as a stream */
    ESD_PROTO_STREAM_MON,   /* send mixed buffer output as a stream */

    /* sample functionality: cache, free, play, loop, EOL, kill */
    ESD_PROTO_SAMPLE_CACHE, /* cache a sample in the server */
    ESD_PROTO_SAMPLE_FREE,  /* release a sample in the server */
    ESD_PROTO_SAMPLE_PLAY,  /* play a cached sample */
    ESD_PROTO_SAMPLE_LOOP,  /* loop a cached sample, til eoloop */
    ESD_PROTO_SAMPLE_STOP,  /* stop a looping sample when done */
    ESD_PROTO_SAMPLE_KILL,  /* stop the looping sample immed. */

    /* free and reclaim /dev/dsp functionality */
    ESD_PROTO_STANDBY,      /* release /dev/dsp and ignore all data */
    ESD_PROTO_RESUME,       /* reclaim /dev/dsp and play sounds again */

    /* TODO: move these to a more logical place. NOTE: will break the protocol */
    ESD_PROTO_SAMPLE_GETID, /* get the ID for an already-cached sample */
    ESD_PROTO_STREAM_FILT,  /* filter mixed buffer output as a stream */

    /* esd remote management */
    ESD_PROTO_SERVER_INFO,  /* get server info (ver, sample rate, format) */
    ESD_PROTO_ALL_INFO,     /* get all info (server info, players, samples) */
    ESD_PROTO_SUBSCRIBE,    /* track new and removed players and samples */
    ESD_PROTO_UNSUBSCRIBE,  /* stop tracking updates */

    /* esd remote control */
    ESD_PROTO_STREAM_PAN,   /* set stream panning */
    ESD_PROTO_SAMPLE_PAN,   /* set default sample panning */

    /* esd status */
    ESD_PROTO_STANDBY_MODE, /* see if server is in standby, autostandby, etc */

    /* esd latency */
    ESD_PROTO_LATENCY,      /* retrieve latency between write()'s and output */
  
    ESD_PROTO_MAX           /* for bounds checking */
} ProtocolEsoundCommand;

/* bits of stream/sample data */
#define ESD_MASK_BITS   ( 0x000F )
#define ESD_BITS8       ( 0x0000 )
#define ESD_BITS16      ( 0x0001 )

/* how many interleaved channels of data */
#define ESD_MASK_CHAN   ( 0x00F0 )
#define ESD_MONO        ( 0x0010 )
#define ESD_STEREO      ( 0x0020 )

/* whether it's a stream or a sample */
#define ESD_MASK_MODE   ( 0x0F00 )
#define ESD_STREAM      ( 0x0000 )
#define ESD_SAMPLE      ( 0x0100 )
#define ESD_ADPCM       ( 0x0200 )      /* TODO: anyone up for this? =P */

/* the function of the stream/sample, and common functions */
#define ESD_MASK_FUNC   ( 0xF000 )
#define ESD_PLAY        ( 0x1000 )

/* functions for streams only */
#define ESD_MONITOR     ( 0x0000 )
#define ESD_RECORD      ( 0x2000 )

/* functions for samples only */
#define ESD_STOP        ( 0x0000 )
#define ESD_LOOP        ( 0x2000 )

typedef struct __attribute__ ((packed))
{
  guint8 cookie[ESD_KEY_LEN];
  guint32 swap;
} ProtocolEsoundAuthenticate;

typedef struct __attribute__ ((packed))
{
  guint32 format;
  guint32 rate;
  gchar name[ESD_NAME_MAX];
} ProtocolEsoundStream;

typedef struct __attribute__ ((packed))
{
  guint32 version;
  guint32 rate;
  guint32 format;
} ProtocolEsoundServerInfo;

typedef struct __attribute__ ((packed)) {
  guint32 source_id;           
  gchar name[ESD_NAME_MAX]; 
  guint32 rate;              
  guint32 left_vol_scale;  
  guint32 right_vol_scale;
  guint32 format;      
} ProtocolEsoundPlayerInfo;

typedef struct __attribute__ ((packed)) {
  guint32 sample_id;  
  gchar name[ESD_NAME_MAX]; 
  guint32 rate;           
  guint32 left_vol_scale; 
  guint32 right_vol_scale;
  guint32 format;    
  guint32 length; 
} ProtocolEsoundSampleInfo;


#endif
