#include <unistd.h>

#include <asddef.h>

#include "protocol-esound.h"
#include "protocol-esound-inet.h"
#include "inet.h"

static int _fd;
static gboolean _enabled = FALSE;

gboolean protocol_esound_inet_init(guint16 port)
{
  g_assert(!_enabled);
  
  return (_enabled = ((_fd = inet_server_socket(port ? port : PROTOCOL_ESOUND_INET_PORT)) >= 0));
}

void protocol_esound_inet_done()
{
  if (_enabled)
    close(_fd);

  _enabled = FALSE;
}

int protocol_esound_inet_get_fd()
{
  return _fd;
}

gboolean protocol_esound_inet_enabled()
{
  return _enabled;
}

void protocol_esound_inet_accept()
{  
  int sock;

  g_assert(_enabled);
  
  if ((sock = inet_server_accept(_fd)) >= 0)
    protocol_esound_new_socket(sock);
}
