#include <unistd.h>
#include <sys/stat.h>

#include <sink-default.h>

#include "sink-fifo.h"

static gboolean _sink_fifo_open(Sink *s)
{
  SinkDefaultPrivate *p;

  g_assert(s);
  g_assert(p = (SinkDefaultPrivate *) s->private_data);

  g_assert(p->filename);
  if (access(p->filename, F_OK)) 
    mkfifo(p->filename, S_IRUSR|S_IWUSR); 

  return sink_default_open_impl(s);
}

Sink* sink_fifo_new(gchar *shortname, gchar *fname)
{
  Sink *s;
  char name[ASD_NAME_LENGTH];

  g_snprintf(name, sizeof(name), "Unix-FIFO %s", fname);
  g_assert(s = sink_new(shortname, name, TRUE));

  g_assert(s->private_data = sink_default_alloc_private(fname));
  
  s->type = "FIFO";
  s->open = _sink_fifo_open;
  
  return s;
}
