/*         ______   ___    ___
 *        /\  _  \ /\_ \  /\_ \
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *
 *      This set of GM percussion patches was provided partly by Jorrit Rouwe,
 *      and partly taken from the SBTimbre utility...
 */


static FM_INSTRUMENT fm_drum[47] =
{
   { 0x10, 0x11, 0x22, 0x0b, 0xf8, 0xf3, 0x77, 0x06, 0x02, 0x00, 0x38, 0x87, 0x06, FM_BD }, /* Acoustic Bass Drum */
   { 0x10, 0x11, 0x22, 0x0b, 0xf8, 0xf3, 0x77, 0x06, 0x02, 0x00, 0x38, 0x87, 0x06, FM_BD }, /* Bass Drum 1 */
   { 0x02, 0x11, 0x07, 0x0b, 0xf9, 0xf8, 0xff, 0xff, 0x00, 0x00, 0x38, 0x60, 0x0b, FM_TT }, /* Side Stick */
   { 0x00, 0x00, 0x00, 0x0b, 0xfc, 0xfa, 0x05, 0x17, 0x02, 0x00, 0x3e, 0xad, 0x0a, FM_SD }, /* Acoustic Snare */
   { 0x00, 0x01, 0x02, 0x0b, 0xff, 0xff, 0x07, 0x08, 0x00, 0x00, 0x30, 0x63, 0x0e, FM_SD }, /* Hand Clap */
   { 0x00, 0x00, 0x00, 0x0b, 0xfc, 0xfa, 0x05, 0x17, 0x02, 0x00, 0x3e, 0xad, 0x0e, FM_SD }, /* Electric Snare */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x57, 0x0d, FM_TT }, /* Low Floor Tom */
   { 0x01, 0x01, 0x03, 0x03, 0xb8, 0xb8, 0xb5, 0xb5, 0x01, 0x01, 0x0d, 0x57, 0x11, FM_CY }, /* Closed Hi-Hat */
   { 0x01, 0x01, 0x00, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0xb0, 0x0d, FM_TT }, /* High Floor Tom */
   { 0x01, 0x01, 0x08, 0x08, 0x88, 0x88, 0xa5, 0xa5, 0x01, 0x01, 0x03, 0x57, 0x11, FM_CY }, /* Pedal Hi-Hat */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x02, 0x0e, FM_TT }, /* Low Tom */
   { 0x01, 0x01, 0x09, 0x09, 0x86, 0x86, 0xa5, 0xa5, 0x01, 0x01, 0x03, 0x57, 0x11, FM_CY }, /* Open Hi-Hat */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x57, 0x11, FM_TT }, /* Low-Mid Tom */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0xb0, 0x11, FM_TT }, /* Hi-Mid Tom */
   { 0xb7, 0x01, 0x41, 0x00, 0x37, 0xff, 0x90, 0x06, 0x01, 0x00, 0x00, 0x57, 0x11, FM_CY }, /* Crash Cymbal 1 */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x02, 0x12, FM_TT }, /* High Tom */
   { 0x01, 0x01, 0x82, 0x82, 0xf6, 0xf6, 0xd5, 0xd5, 0x01, 0x01, 0x03, 0x57, 0x11, FM_CY }, /* Ride Cymbal 1 */
   { 0xb7, 0x01, 0x41, 0x00, 0x37, 0xff, 0x90, 0x06, 0x01, 0x00, 0x00, 0x57, 0x11, FM_CY }, /* Chinese Cymbal */
   { 0x0e, 0x0e, 0x07, 0x07, 0xb5, 0xb5, 0x15, 0x15, 0x01, 0x01, 0x0b, 0x57, 0x11, FM_CY }, /* Ride Bell */
   { 0x01, 0x01, 0x07, 0x07, 0x77, 0x77, 0x73, 0x73, 0x01, 0x01, 0x0b, 0x57, 0x11, FM_CY }, /* Tambourine */
   { 0xb7, 0x01, 0x41, 0x00, 0x37, 0xff, 0x90, 0x06, 0x01, 0x00, 0x00, 0x57, 0x11, FM_CY }, /* Splash Cymbal */
   { 0x10, 0x10, 0x00, 0x00, 0x96, 0x96, 0x67, 0x67, 0x00, 0x00, 0x0a, 0xb0, 0x11, FM_SD }, /* Cowbell */
   { 0xb7, 0x01, 0x41, 0x00, 0x37, 0xff, 0x90, 0x06, 0x01, 0x00, 0x00, 0x57, 0x11, FM_CY }, /* Crash Cymbal 2 */
   { 0x01, 0x01, 0x07, 0x07, 0xf9, 0xf9, 0xb5, 0xb5, 0x00, 0x00, 0x0b, 0x57, 0x11, FM_SD }, /* Vibraslap */
   { 0xd1, 0xd1, 0x05, 0x05, 0xe7, 0xe7, 0x65, 0x65, 0x01, 0x01, 0x0d, 0x57, 0x11, FM_SD }, /* Ride Cymbal 2 */
   { 0x01, 0x01, 0x00, 0x00, 0xe7, 0xe7, 0x94, 0x94, 0x00, 0x00, 0x03, 0x02, 0x12, FM_TT }, /* Hi Bongo */
   { 0x01, 0x01, 0x00, 0x00, 0xe7, 0xe7, 0x94, 0x94, 0x00, 0x00, 0x0b, 0x81, 0x11, FM_TT }, /* Low Bongo */
   { 0x01, 0x01, 0x00, 0x00, 0x96, 0x96, 0x67, 0x67, 0x00, 0x00, 0x0a, 0x02, 0x12, FM_TT }, /* Mute Hi Conga */
   { 0x01, 0x01, 0x00, 0x00, 0xb4, 0xb4, 0x26, 0x26, 0x00, 0x00, 0x0a, 0x02, 0x12, FM_TT }, /* Open Hi Conga */
   { 0x01, 0x01, 0x00, 0x00, 0xb4, 0xb4, 0x26, 0x26, 0x00, 0x00, 0x0a, 0x57, 0x11, FM_TT }, /* Low Conga */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x57, 0x11, FM_TT }, /* High Timbale */
   { 0x01, 0x01, 0x08, 0x08, 0xc6, 0xc6, 0x98, 0x98, 0x00, 0x00, 0x05, 0x02, 0x0e, FM_TT }, /* Low Timbale */
   { 0x05, 0xa7, 0x00, 0x7f, 0xf6, 0x33, 0x56, 0x90, 0x00, 0x03, 0x00, 0x63, 0x0e, FM_TT }, /* High Agogo */
   { 0x05, 0xa7, 0x00, 0x7f, 0xf6, 0x33, 0x56, 0x90, 0x00, 0x03, 0x00, 0x93, 0x0b, FM_TT }, /* Low Agogo */
   { 0x00, 0x00, 0x2e, 0x2e, 0x8a, 0x8a, 0xec, 0xec, 0x02, 0x02, 0x0a, 0x57, 0x11, FM_HH }, /* Cabasa */
   { 0x00, 0x00, 0x2e, 0x2e, 0x8b, 0x8b, 0xe6, 0xe6, 0x02, 0x02, 0x0a, 0x57, 0x11, FM_HH }, /* Maracas */
   { 0x52, 0x52, 0x27, 0x27, 0x59, 0x59, 0x15, 0x15, 0x03, 0x03, 0x0b, 0x82, 0x16, FM_TT }, /* Short Whistle */
   { 0x52, 0x52, 0x27, 0x27, 0x48, 0x48, 0x14, 0x14, 0x03, 0x03, 0x0b, 0x82, 0x16, FM_TT }, /* Long Whistle */
   { 0x00, 0x00, 0x0e, 0x0e, 0x5a, 0x5a, 0xd6, 0xd6, 0x01, 0x01, 0x0a, 0x57, 0x11, FM_HH }, /* Short Guiro */
   { 0x10, 0x10, 0x0e, 0x0e, 0x53, 0x53, 0x9f, 0x9f, 0x01, 0x01, 0x0a, 0x57, 0x11, FM_HH }, /* Long Guiro */
   { 0x11, 0x11, 0x00, 0x00, 0xf5, 0xf5, 0x75, 0x75, 0x00, 0x00, 0x02, 0x02, 0x1a, FM_TT }, /* Claves */
   { 0x04, 0x04, 0x00, 0x00, 0xf8, 0xf8, 0xb6, 0xb6, 0x01, 0x01, 0x03, 0x57, 0x11, FM_TT }, /* Hi Wood Block */
   { 0x04, 0x04, 0x00, 0x00, 0xf8, 0xf8, 0xb7, 0xb7, 0x01, 0x01, 0x03, 0xca, 0x0d, FM_TT }, /* Low Wood Block */
   { 0x01, 0x01, 0x0b, 0x0b, 0x5e, 0x5e, 0xdc, 0xdc, 0x01, 0x01, 0x0a, 0x57, 0x11, FM_HH }, /* Mute Cuica */
   { 0x00, 0x00, 0x07, 0x07, 0x5c, 0x5c, 0xdc, 0xdc, 0x01, 0x01, 0x0a, 0x57, 0x11, FM_HH }, /* Open Cuica */
   { 0xc5, 0xd5, 0x4f, 0x10, 0xf6, 0xf6, 0x84, 0x84, 0x00, 0x00, 0x08, 0x02, 0x16, FM_BD }, /* Mute Triangle */
   { 0xc5, 0xd5, 0x4f, 0x10, 0xf6, 0xf6, 0x84, 0x72, 0x00, 0x00, 0x08, 0x02, 0x16, FM_BD }  /* Open Triangle */
};
