// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __TUnitModelElementFactory_h__
#define __TUnitModelElementFactory_h__

#include "ModelElementFactory.h"
#include "JoinPointLoc.h"
#include "TransformInfo.h"

/* helper classes to merge the TI_ classes into the JPL_ classes, i.e. to
 * extend the join point model elements by transformation infos
 */
 
class TU_Type : public JPL_Type, public TI_Type {
public:
  TU_Type (const string &s) : JPL_Type (s) { transform_info (this); }
  ~TU_Type () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_Namespace : public JPL_Namespace, public TI_Namespace {
public:
  TU_Namespace (const string &s) : JPL_Namespace (s) { transform_info (this); }
  ~TU_Namespace () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_Class : public JPL_Class, public TI_Class {
public:
  TU_Class (const string &s) : JPL_Class (s) { transform_info (this); }
  ~TU_Class () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_Aspect : public JPL_Aspect, public TI_Aspect {
public:
  TU_Aspect (const string &s) : JPL_Aspect (s) { transform_info (this); }
  ~TU_Aspect () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_Function : public JPL_Function, public TI_Function {
public:
  TU_Function (const string &n, const string &s) : JPL_Function (n, s) { transform_info (this); }
  ~TU_Function () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_AdviceCode : public JPL_AdviceCode, public TI_AdviceCode {
public:
  TU_AdviceCode (const string &n, const string &s) : JPL_AdviceCode (n, s) { transform_info (this); }
  ~TU_AdviceCode () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_ClassSlice : public JPL_ClassSlice, public TI_ClassSlice {
public:
  TU_ClassSlice (const string &s) : JPL_ClassSlice (s) { transform_info (this); }
  ~TU_ClassSlice () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_MethodCall : public JPL_MethodCall, public TI_MethodCall {
public:
  TU_MethodCall () { transform_info (this); }
  ~TU_MethodCall () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_Method : public JPL_Method, public TI_Method {
public:
  TU_Method () { transform_info (this); }
  ~TU_Method () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_Construction : public JPL_Construction, public TI_Construction {
public:
  TU_Construction () { transform_info (this); }
  ~TU_Construction () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_Destruction : public JPL_Destruction, public TI_Destruction {
public:
  TU_Destruction () { transform_info (this); }
  ~TU_Destruction () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_Introduction : public JPL_Introduction, public TI_Introduction {
public:
  TU_Introduction () { transform_info (this); }
  ~TU_Introduction () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};

class TU_Order : public JPL_Order, public TI_Order {
public:
  TU_Order () { transform_info (this); }
  ~TU_Order () { transform_info (0); }
  virtual JoinPointLoc &jpl () { return *this; }
};


/* a model element factory for the translation unit model that additionally
 * contains references to the Puma information about the model elements,
 * which is needed for transformations.
 */
 
class TUnitModelElementFactory {
public:
  virtual ~TUnitModelElementFactory () {}
  
  virtual TU_Namespace *make_namespace (const string &s) {
    return new TU_Namespace (s); 
  }
  virtual TU_Class *make_class (const string &s) {
    return new TU_Class (s);
  }
  virtual TU_Aspect *make_aspect (const string &s) {
    return new TU_Aspect (s);
  }
  virtual TU_Function *make_function (const string &n, const string &s) {
    return new TU_Function (n, s);
  }
  virtual TU_AdviceCode *make_advice_code (const string &n, const string &s) {
    return new TU_AdviceCode (n, s);
  }
  virtual TU_ClassSlice *make_class_slice (const string &s) {
    return new TU_ClassSlice (s);
  }
  virtual TU_Type *make_type (const string &s)  { return new TU_Type (s); }
  virtual TU_Method *make_execution ()          { return new TU_Method; }
  virtual TU_MethodCall *make_call ()           { return new TU_MethodCall; }
  virtual TU_Construction *make_construction () { return new TU_Construction; }
  virtual TU_Destruction *make_destruction ()   { return new TU_Destruction; }
  virtual TU_Introduction *make_introduction () { return new TU_Introduction; }
  virtual TU_Order *make_order ()               { return new TU_Order; }
};

#endif // __TUnitModelElementFactory_h__
