// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/PipedCmd.h"
#include <iostream>
using namespace std;

namespace Puma {


PipedCmd::PipedCmd () {}


void PipedCmd::readin (FILE *fin) {
  int len;
  char buf[1024];
  while(feof (fin) == 0) {
    len = fread (buf, 1, 1024, fin);
    buf[len] = 0;
    m_Print += buf;
  }
}


void PipedCmd::reset () {
  fflush (stdout);
  m_Print = "";
}


int PipedCmd::exec (const string &cmd) {
  int res = -1;
        
  reset ();
#ifdef _MSC_VER
  FILE *fd = _popen (cmd.c_str (), "r");
#else
  FILE *fd = popen (cmd.c_str (), "r");
#endif
  if (fd != 0) {
    readin (fd);
#ifdef _MSC_VER
    res = _pclose (fd);
#else
    res = pclose (fd);
#endif
  } else 
    cout << "popen failed" << endl;
  
  return res;
}


} // namespace Puma
