// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __mapped_orange_recognizer_h__
#define __mapped_orange_recognizer_h__

// The token recognizer class, which uses scanner tables generated by the
// orange tool. Returned expressions mapped according to an orange
// generated mapping table

#include "Puma/OrangeRecognizer.h"

namespace Puma {


// class declaration

template <class ScanBuffer>
class MappedOrangeRecognizer : public OrangeRecognizer<ScanBuffer> {
  int *_expr_map;

public:
  MappedOrangeRecognizer (char *map, int *expr_map, int start, 
                          States *state, int *next,
                          int *control, int tab_size) : 
    OrangeRecognizer<ScanBuffer> (map, start, state, next, control, tab_size),
    _expr_map (expr_map) 
   {}

  // try to recognize the current token in the character buffer
  // returns 1 on success, 0 on eof, -1 on unknown token
  int recognize (ScanBuffer *scan_buffer, int &token, int &len) {
    int result;

    if ((result = OrangeRecognizer<ScanBuffer>::recognize (scan_buffer, token, len)) == 1) {
      token = _expr_map[token];
    }
    return result;
  }
};


} // namespace Puma

#endif // __mapped_orange_recognizer_h__
