#ifndef __sgml_skip__
#define __sgml_skip__

#include <pspell/mutable_container.h>

#include "skip.hh"
#include "refcount.hh"

namespace afilter {

  template <typename T>
  class EmailSkip : public T::Base {
  public:
    typedef typename T::Base      Base;
    typedef typename T::Itr       Itr;
    typedef typename T::ItrRoot   ItrRoot;

  private:
    bool prev_newline;
    bool in_quote;
    int margin;
    int n;

    class QuoteChars : public PspellMutableContainer {
      bool data[256];
    public:
      bool add(const char * s) {
	data[static_cast<unsigned char>(*s)] = true;
	return true;
      }
      bool remove(const char * s) {
	data[static_cast<unsigned char>(*s)] = false;
	return true;
      }
      void clear() {
	memset(data, 0, sizeof(bool)*256);
      }
      bool have(char c) {
	return data[static_cast<unsigned char>(c)];
      }
      QuoteChars() {clear();}
    };
    RefCount<QuoteChars> is_quote_char;

  public:
    EmailSkip() {abort();}
    EmailSkip(ConfigData &); 
  
    string name() const {return "email";}
    double order_num() const {return .85;}
  
    bool skip(char c, const Itr *);
  };
}

#endif
