#ifndef __skip__hh__
#define __skip__hh__


#include <string>
#include "filter.hh"

namespace autil {
  class ConfigData;
}

namespace afilter {

  template <typename T>
  class RegionSkipBase {
  public:
    typedef typename T::Base      Base;
    typedef typename T::Itr       Itr;
    typedef typename T::ItrRoot   ItrRoot;

    virtual string name() const = 0;
    virtual double order_num() const = 0;

    virtual ~RegionSkipBase() {}

    virtual int scan_needed() const {return 0;}
  
    virtual void reset() {}
    virtual void scan(Itr & begin, const ItrRoot & stop) {}
    virtual bool skip(char c, const Itr *) = 0;
    //: returns true if the char should be skipped, false otherwise
  };

  struct RegionSkipFilterTypes {
    typedef RegionSkipBase<RegionSkipFilterTypes> Base;
    typedef FilterItrPart                         Itr;
    typedef FilterItrRoot                         ItrRoot;
  };

  template <typename RegSkip>
  class RegionSkipItr : public FilterItrPart 
  {
  public:
    RegionSkipItr();
    RegionSkipItr(ConfigData & m);
    RegionSkipItr(const RegSkip & rs);

    RegionSkipItr * clone() const;
    void assign (const FilterItrPart * other);

    string name() const;
    double order_num() const;
  
    void reset();
    void scan(const FilterItrRoot & stop);

    char first();
    char next();

    RegSkip & regskip() {return skip;}
  private:
    RegSkip skip;
    char    blank_char;
  };
}
#endif

  
