//
// Notice the char buf[2]; the types must be correct to make this work right
//

#include "repl.hh"
#include "map_repl.hh"
#include "refcount.hh"

namespace afilter {

  template <typename InValue,  typename Value, 
    typename InString, typename String>
  class SubstrReplPair {
  public:
    InString key;
    String   value;
    typedef typename vector<InValue>::const_iterator Iterator;
    typedef itr_equal<Iterator>                      Endf;
    Iterator begin() const {return key.begin();}
    Endf     endf()  const {return key.end();}
    SubstrReplPair(const InValue * k, const Value * v)
    {for(;*k;++k)key.push_back(*k); for(;*v;++v)value.push_back(*v);}
  };

  template <typename T>
  class SubstrRepl : public T::Base,
		     public MapReplBase<typename T::InValue, typename T::Value>
  {

  public:
    typedef typename T::Base        Base;
    typedef typename T::Itr         Itr;
    typedef typename T::InValue     InValue;
    typedef typename T::Value       Value;
    typedef typename T::ItrRoot     ItrRoot;
    typedef typename T::Buffer      Buffer;
    typedef typename T::SingleMulti SingleMulti;

    typedef MapReplBase<typename T::InValue, typename T::Value> M;
    typedef typename M::InString InString;
    typedef typename M::String   String;

  private:
    typedef SubstrReplPair<InValue,Value,InString,String> Pair;
    typedef vector<Pair>                                  Con;
    RefCount<Con> con;

  public:
    SubstrRepl(ConfigData *, const ReplOpts *) {}
    Base * clone() const {return new SubstrRepl(*this);}
    void assign(const Base * other) {*this = *(const SubstrRepl *)(other);}
  
    bool fill(InValue c, Itr * i, Buffer * buffer);
  
    void add (const InValue * key, const Value * value) 
    {con->push_back(Pair(key,value));}

    typedef typename Con::iterator       iterator;
    typedef typename Con::const_iterator const_iterator;
    const_iterator begin() const {return con->begin();}
    const_iterator end()   const {return con->end();}
  };

}
  
