#ifndef autil_file_util__hh
#define autil_file_util__hh

#include <string>
#include <ctime>

namespace autil {
  using namespace std;
  class SimpleFstream;
  
  void open_file(SimpleFstream & in, const string & file, 
		 const char * mode = "r");
  string add_possible_dir(const string & dir, const string & file);
  time_t get_modification_time(SimpleFstream & f);
  void open_file_readlock(SimpleFstream& in, const string & file);
  bool open_file_writelock(SimpleFstream & in, const string & file);
  // returns true if the file already exists
  void truncate_file(SimpleFstream & f, const string & name);
  bool remove_file(const string & name);
  bool file_exists(const string & name);
  bool rename_file(const string & orig, const string & new_name);
  // will return NULL if path is NULL.
  const char * get_file_name(const char * path);
}

#endif
