/*
 * wrapper_misc.hxx
 *
 * OpenH323 Wrapper Library.
 *
 * Copyright (c) 2002-2005 InAccess Networks
 * Michalis Manousos <manousos@inaccessnetworks.com>
 * Dimitris Economou <decon@inaccessnetworks.com>
 *
 * This file is part of "H.323 support for ASTERISK"
 *
 * "H.323 support for ASTERISK" is free software;
 * you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version. 
 *
 * "H.323 support for ASTERISK" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Id: wrapper_misc.hxx,v 1.4.2.1 2005/01/14 15:33:22 manousos Exp $
 *
 */

///////////////////////////////////////////////////////////////////////////////

#ifndef	_WRAPPER_MISC_HXX
#define	_WRAPPER_MISC_HXX

#include <ptlib.h>

////////////////////////////////////
// Define tracing functions
#ifdef	WRAPTRACING
extern int wrapTraceLevel;

#define	WRAPTRACE(level, args) \
	if (level > wrapTraceLevel) ; else \
		cout << "[" << level << "]" << (this->Class()) << "::" << __FUNCTION__ << ": " << args << endl
#define	WRAPTRACEAPI(level, args) \
	if (level > wrapTraceLevel) ; else \
		cout << "[" << level << "]" << "WrapperAPI::" << __FUNCTION__ << ": " << args << endl

#else	// WRAPTRACING

#define	WRAPTRACE(level, args)
#define	WRAPTRACEAPI(level, args)

#endif	// WRAPTRACING
////////////////////////////////////

#define	WMUTEX_INFO	__FILE__, __LINE__, __FUNCTION__
#define	WMUTEX_WAIT_FOREVER	(-1)

// Wrapper Mutex class
class WrapMutex: public PMutex {

	PCLASSINFO(WrapMutex, PMutex);

	public:

	WrapMutex(char *mutex_name);
	BOOL Wait(const char *file, int line, const char *function, int ms);
	void Signal(const char *file, int line, const char *function);

	protected:

	PString	name;
};

extern WrapMutex *channelMutex;
extern WrapMutex *callMutex;

// Counter for the number of H.323 unidirectional channels currently open
extern int channelsOpen;

#endif	// _WRAPPER_MISC_HXX
// End of file //////////////////////////////////////////////////////////////
