/*
 * asteriskaudio.hxx
 *
 * Sound driver implementation for ASTERISK PBX.
 * OpenH323 Wrapper Library.
 *
 * Copyright (c) 2002-2005 InAccess Networks
 * Michalis Manousos <manousos@inaccessnetworks.com>
 * Dimitris Economou <decon@inaccessnetworks.com>
 *
 * This file is part of "H.323 support for ASTERISK"
 *
 * "H.323 support for ASTERISK" is free software;
 * you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version. 
 *
 * "H.323 support for ASTERISK" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Id: asteriskaudio.hxx,v 1.27 2005/09/09 14:35:26 manousos Exp $
 *
 */

///////////////////////////////////////////////////////////////////////////////

#ifndef	_ASTERISKAUDIO_HXX
#define	_ASTERISKAUDIO_HXX

/**
 * PAsteriskAudioDelay class
 * This class implements a delay and is used by
 * the "Write" member function of the PChannel descentant.
 */
class PAsteriskAudioDelay : public PObject {

	PCLASSINFO(PAsteriskAudioDelay, PObject);

	public:

	PAsteriskAudioDelay();
	~PAsteriskAudioDelay();
	BOOL Delay(int time);
	BOOL ReadDelay(int time);
	BOOL WriteDelay(int time);
	void Restart();
	int  GetError();

	protected:
	PTime  targetTime;
	PTime  previousTime;
	BOOL   firstTime;
	int    error;

};


/**
 * PAsteriskSoundChannel class
 * This class interfaces the ASTERISK PBX 
 * (open, close, read, write operations)
 */
class PAsteriskSoundChannel : public PSoundChannel {

	PCLASSINFO(PAsteriskSoundChannel, PSoundChannel);

	public:

	PAsteriskSoundChannel();
	~PAsteriskSoundChannel();
	void Construct();
	static PStringArray GetDeviceNames(Directions);
	static PString GetDefaultDevice(Directions);
	BOOL Open(const PString &, int, Directions, unsigned, unsigned, unsigned, 
				unsigned, unsigned);
	BOOL Close();
	BOOL SetFormat(unsigned, unsigned, unsigned);
	BOOL SetBuffers(PINDEX, PINDEX);
	BOOL GetBuffers(PINDEX &, PINDEX &);
	BOOL Write(const void *, PINDEX);
	PINDEX GetLastWriteCount() const;
	PINDEX GetLastReadCount() const;
	BOOL Read(void *, PINDEX);

	protected:

	PAsteriskAudioDelay	astWriteDelay;
	PAsteriskAudioDelay	astReadDelay;
	DWORD writeCount, readCount, shortWriteCount;
	PINDEX bufSize, bufCount;
	unsigned mediaFormat;
	unsigned frameTime;
	unsigned frameNum;
	unsigned packetSize;
	int mutex_flag;
	PINDEX lastWritten;

	PTimeInterval time_diff;
	PTime previous_write;
	BOOL first_write;

	unsigned char readBuffer[8000];
	unsigned readBufIndex, readBufSize;
};

#endif	// _ASTERISKAUDIO_HXX
// End of file //////////////////////////////////////////////////////////////
