/*
 * wrapcaps.hxx
 *
 * OpenH323 Wrapper Library.
 *
 * Copyright (c) 2002-2005 InAccess Networks
 * Michalis Manousos <manousos@inaccessnetworks.com>
 * Dimitris Economou <decon@inaccessnetworks.com>
 *
 * This file is part of "H.323 support for ASTERISK"
 *
 * "H.323 support for ASTERISK" is free software;
 * you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version. 
 *
 * "H.323 support for ASTERISK" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Id: wrapcaps.hxx,v 1.5 2005/09/09 14:35:27 manousos Exp $
 *
 */

/************************************************************************/

#ifndef	_WRAPCAPS_HXX
#define	_WRAPCAPS_HXX

#include <ptlib.h>
#include "h323caps.h"

#define	WRAP_G726_40	"G.726-40k"
#define	WRAP_G726_32	"G.726-32k"
#define	WRAP_G726_24	"G.726-24k"
#define	WRAP_G726_16	"G.726-16k"

/* Speed index (see Wrap_G726_Info) */
#define	WRAP_G726_SPEED40	0
#define	WRAP_G726_SPEED32	1
#define	WRAP_G726_SPEED24	2
#define	WRAP_G726_SPEED16	3

#ifdef	USE_OLD_CAPABILITIES_API
extern OpalMediaFormat const WrapG726_40;
extern OpalMediaFormat const WrapG726_32;
extern OpalMediaFormat const WrapG726_24;
extern OpalMediaFormat const WrapG726_16;
#else
extern char WrapG726_40[];
extern char WrapG726_32[];
extern char WrapG726_24[];
extern char WrapG726_16[];
#endif

class Wrap_G726_Capability : public H323NonStandardAudioCapability
{
	PCLASSINFO(Wrap_G726_Capability, H323NonStandardAudioCapability);
public:
	Wrap_G726_Capability(H323EndPoint &ep, int sp);
	PObject *Clone() const;
	BOOL IsValid() const;
	PString GetFormatName() const;
	BOOL OnSendingPDU(H245_AudioCapability &pdu, unsigned packetSize) const;
	BOOL OnReceivedPDU(const H245_AudioCapability &pdu, unsigned &packetSize);
	H323Codec *CreateCodec(H323Codec::Direction direction) const;
protected:
	int speed;
};

class Wrap_G726_Codec : public H323AudioCodec
{
	PCLASSINFO(Wrap_G726_Codec, H323AudioCodec);
public:
	Wrap_G726_Codec(int sp, Direction dir, unsigned frameSize);
	unsigned GetSpeed();
	BOOL Read(BYTE *buffer, unsigned &length, RTP_DataFrame &);
	BOOL Write(const BYTE *buffer, unsigned length, 
					const RTP_DataFrame & /*frame*/,
					unsigned & written);
	BOOL IsRawDataChannelNative() const;
protected:
	unsigned packetSize;
	unsigned speed;
};

#endif /* _WRAPCAPS_HXX */
