// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright (C) 2000 Stefanus Du Toit

#include <Atlas/Message/QueuedDecoder.h>

namespace Atlas { namespace Message {

QueuedDecoder::QueuedDecoder()
{
}

size_t QueuedDecoder::queueSize()
{
    return objectQueue.size();
}

Element QueuedDecoder::front()
{
    return objectQueue.front();
}

Element QueuedDecoder::pop()
{
    Element r = objectQueue.front();
    objectQueue.pop();
    return r;
}

void QueuedDecoder::objectArrived(const Element& obj)
{
    objectQueue.push(obj);
}

} } // namespace Atlas::Message
