/*
 *             Automatically Tuned Linear Algebra Software v3.2
 *                    (C) Copyright 2000 R. Clint Whaley                     
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions, and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the University of Tennessee, the ATLAS group,
 *      or the names of its contributers may not be used to endorse
 *      or promote products derived from this software without specific
 *      written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. 
 *
 */

#include <stdio.h>
enum WHATPROBE {Pcpu, Pnproc, Pl1, Pl2, Ptlb, Pall};

PrintUsage(char *nam)
{
   fprintf(stderr, "USAGE: %s -c (cpu) -n (#procs) -1 (L1 cache) -2 (L2 cache) -t (# of tlb)\n\n", nam);
   exit(1);
}

enum WHATPROBE GetFlags(int nargs, char **args)
{
   int i;
   enum WHATPROBE ret=Pall;

   if (nargs > 2) PrintUsage(args[0]);
   if (nargs > 1)
   {
      if (args[1][0] != '-') PrintUsage(args[0]);
      switch(args[1][1])
      {
      case 'c':
         ret = Pcpu;
         break;
      case 'n':
         ret = Pnproc;
         break;
      case '1':
         ret = Pl1;
         break;
      case '2':
         ret = Pl2;
         break;
      case 't':
         ret = Ptlb;
         break;
      default:
         ret = Pall;
      }
   }
   return(ret);
}

main(int nargs, char **args)
{
   enum WHATPROBE what;
   int ncpu;

   what = GetFlags(nargs, args);
   switch(what)
   {
   case Pnproc:
      ncpu = syscall(315, 1);
      printf("ncpus = %d\n", ncpu);
      break;
   default:
      fprintf(stderr, "Not implemented\n");
      exit(-1);
   }
   exit(0);
}
