/************************************************************************/
/*                                                                      */
/*                         Applied Type System                          */
/*                                                                      */
/*                              Hongwei Xi                              */
/*                                                                      */
/************************************************************************/

/*
** ATS - Unleashing the Potential of Types!
**
** Copyright (C) 2002-2008 Hongwei Xi.
**
** ATS is free software;  you can  redistribute it and/or modify it under
** the terms of the GNU LESSER GENERAL PUBLIC LICENSE as published by the
** Free Software Foundation; either version 2.1, or (at your option)  any
** later version.
** 
** ATS is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without  even  the  implied  warranty  of MERCHANTABILITY or
** FITNESS FOR A PARTICULAR PURPOSE.  See the  GNU General Public License
** for more details.
** 
** You  should  have  received  a  copy of the GNU General Public License
** along  with  ATS;  see the  file COPYING.  If not, please write to the
** Free Software Foundation,  51 Franklin Street, Fifth Floor, Boston, MA
** 02110-1301, USA.
*/

/* ****** ****** */

/* author: Hongwei Xi (hwxi AT cs DOT bu DOT edu) */

/* ****** ****** */

#ifndef ATS_LIBATS_REGEXP_CATS
#define ATS_LIBATS_REGEXP_CATS

/* ****** ****** */

#include <pcre.h>

/* ****** ****** */

static inline
ats_void_type
atslib_regexp_free (ats_ptr_type re) { pcre_free (re) ; return ; }
// end of [atslib_regexp_free]

/* ****** ****** */

static inline
ats_ptr_type
atslib_regexp_ref_make (ats_ptr_type re) { return re ; }
// end of [atslib_regexp_ref_make]

/* ****** ****** */

#endif /* ATS_LIBATS_REGEXP_CATS */

/* end of [regexp.cats] */
