/****************************************************************
**
** Attal : Lords of Doom
**
** insideBuilding.cpp
** display building on the inside view
**
** Version : $Id: insideBuilding.cpp,v 1.2 2004/12/05 19:19:22 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 04/11/2001
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "insideBuilding.h"
 
// generic include files
// include files for QT
#include <qpainter.h>
#include <qpixmap.h>
// application specific include files
#include "libClient/imageTheme.h"

#include "conf.h"

#include "libCommon/log.h"
#include "libCommon/genericInsideBuilding.h"

extern ImageTheme ImageTheme;

const int InsideBuilding::RTTI = 52;

InsideBuilding::InsideBuilding( int type, GenericInsideBuilding * build, QCanvas * canvas )
//	: QCanvasSprite( ImageTheme.insideBuildings[type], canvas )
	: QCanvasRectangle( canvas )
{
	_type = type;
	_building = build;
 	//collisions( true );
 	//setFrame( 2 * _building->getLevel() );
	
	_pixmap = ImageTheme.insideBuildings[ _type ]->image( 2 * _building->getLevel() );
	_image = _pixmap->convertToImage();
	setSize( _pixmap->width(), _pixmap->height() );
	
	setEnabled( true );
	show();
}
/*
ImageItem::ImageItem( QImage img, QCanvas *canvas )
    : QCanvasRectangle( canvas ), image(img)
{
    setSize( image.width(), image.height() );

#if !defined(Q_WS_QWS)
    pixmap.convertFromImage(image, OrderedAlphaDither);
#endif
}
*/

void InsideBuilding::drawShape( QPainter &p )
{
	p.drawPixmap( int( x() ), int( y() ), * _pixmap );
}

bool InsideBuilding::hit( const QPoint & p ) const
{
	bool ret = false;
	int ix = p.x()-int(x());
	int iy = p.y()-int(y());
	    
	if ( _image.valid( ix , iy ) ) {
		QRgb pixel = _image.pixel( ix, iy );
		ret = ( qAlpha( pixel ) != 0 );
		
	}
	return ret;
}


void InsideBuilding::move( int x, int y )
{
	QCanvasRectangle::move( x, y );
	setZ( int( y / 10 ) );
}

void InsideBuilding::select()
{
	//setFrame( (_building->getLevel() * 2) + 1 );
	_pixmap = ImageTheme.insideBuildings[ _type ]->image( 2 * _building->getLevel() + 1 );
	_image = _pixmap->convertToImage();
	update();
}

void InsideBuilding::deselect()
{
	//setFrame( _building->getLevel() * 2 );
	_pixmap = ImageTheme.insideBuildings[ _type ]->image( 2 * _building->getLevel() );
	_image = _pixmap->convertToImage();
	update();
}
