/****************************************************************
**
** Attal : Lords of Doom
**
** tileSelection.cpp
** Manages selection of tiles
**
** Version : $Id: tileSelection.cpp,v 1.2 2004/01/11 22:40:14 audoux Exp $
**
** Author(s) : Pascal Audoux
**
** Date : 11/01/2004
**
** Licence :    
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "tileSelection.h"

// generic include files
// include files for QT
#include <qstring.h>
// application specific include files
#include "libClient/cell.h"
#include "libClient/gui.h"
#include "libClient/imageTheme.h"
#include "libClient/map.h"

#include "libCommon/dataTheme.h"
#include "libCommon/genericCell.h"
#include "libCommon/log.h"

#include "libServer/gameData.h"

extern DataTheme DataTheme;
extern ImageTheme ImageTheme;
extern Map * theMap;

//
// ----- TileSelection -----
//

TileSelection::TileSelection( QWidget * parent, const char * name )
	:ItemSelection( parent, name )
{
	TilePresentation * pres;
	_tiles = new QPtrList<TilePresentation>;
	_tiles->setAutoDelete( false );
	_sizeG = new QButtonGroup( this );
	_sizeG->hide();
	_sizeG->setExclusive( true );
	uint i;
	for( i = 1; i < 4; i++ ) {
		QPushButton * pb = new QPushButton( QString("x%1").arg(i), this );
		pb->setToggleButton( true );
		pb->setFixedWidth( 50 );
		_sizeG->insert( pb, i );
		addNewWidget( pb );
	}
	addNewLine();
	_sizeG->setButton(1);
	for( i = 1; i < DataTheme.tiles.count(); i++ ) {
		//addButton( ImageTheme.cells[i]->image( 0 ), i, i == 0 );
		pres = new TilePresentation( this );
		pres->setCell( DataTheme.tiles.at(i) );
		pres->getButton()->setToggleButton( true );
		_bg->insert( pres->getButton(), i );
		pres->getButton()->setFixedSize( QSize(40,40).expandedTo(pres->getButton()->sizeHint() ) );
		addNewWidget( pres );
		_tiles->append( pres );
	}
}


void TileSelection::handleLeftClick( Cell * cell )
{
	uint row = cell->getRow();
	uint col = cell->getCol();
	if( button() != -1 ) {
		/// XXX: replace selectedId () with id( buttonGroup->selected() )
		uint shift = ( QMAX(_sizeG->id ( _sizeG->selected()) ,1) - 1 ) / 2;
		tileSquare( row - shift, col - shift );
	}
}

void TileSelection::tileSquare( uint row, uint col )
{
	int i, j;
	GenericCell * cell;

	// XXX: replace selectedId with id ( selected )
	int id = _sizeG->id ( _sizeG->selected () );
	for( i = 0; i < id ; i++ ) {
		for( j = 0; j < id; j++ ) {
			cell = _data->getCell( row+i, col+j );
			if( cell ) {
				cell->setType( button() );
				cell->setDiversification( _tiles->at( button()-1 )->getDiversification() );
			}
		}
	}
}

