/*
 *  stream.h
 *
 *  Copyright 2009 Arnaud Soyez <weboide@codealpha.net>
 *
 *  This file is part of AudioPreview.
 *
 *  AudioPreview is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  AudioPreview is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AudioPreview.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef STREAM_H
#define STREAM_H

#define STREAM_INFO_UPDATER_RATE 490

#include <gst/gst.h>
#include <gio/gio.h>
#include "ap_config.h"
#include "functions.h"

#define CLEAREOL        "\x1B[K"                // Clear End Of Line

typedef struct _Stream
{
  GFile       *file;
  gchar       *title;
  gchar       *artist;
  gchar       *filepath;
  gchar       *uri;
  gint64      duration;
  gint64      position;
  gint64      startposition;
  guint       update_function_source_id;
  gint        buffering_perc;
  gboolean    paused;
} Stream;

Stream*   stream_new          (GFile *file);
gboolean  stream_set_title    (Stream *stream, const gchar *title);
gboolean  stream_set_artist   (Stream *stream, const gchar *artist);
gboolean  stream_set_duration (Stream *stream, const gint64 duration);
gboolean  stream_set_position (Stream *stream, const gint64 position);
void      split_nanoseconds   (gint64 nanosecs, gint *hour, gint *min, gint *secs);
gchar*    stream_get_name_string        (Stream* stream);
gchar*    stream_get_duration_string    (Stream* stream);
gchar*    stream_get_uri                (Stream* stream);
gchar*    stream_get_filepath           (Stream* stream);
void      stream_free                   (Stream* stream);
void      stream_remove_updater         (Stream* stream);
void      stream_add_updater            (Stream* stream, GSourceFunc func);
void      stream_remove_playing_timeout (Stream* stream);
void      stream_print_info             (Stream* stream);

#endif /* STREAM_H */
