dnl Available from the GNU Autoconf Macro Archive at:
dnl http://www.gnu.org/software/ac-archive/htmldoc/ac_prog_mysqladmin.html
dnl
AC_DEFUN([AC_PROG_MYSQLADMIN],[
AC_REQUIRE([AC_EXEEXT])dnl
AC_PATH_PROG(MYSQLADMIN, mysqladmin$EXEEXT, nocommand)
if test "$MYSQLADMIN" = nocommand; then
	AC_MSG_ERROR([mysqladmin not found in $PATH])
fi
AC_MSG_CHECKING([if mysqladmin works])
if $MYSQLADMIN -u root -prootpass flush-privileges; then
	AC_MSG_RESULT([yes])
else
	AC_MSG_NOTICE([Before installation, set MySQL root password to rootpass; restore your root password afterwards.])
	AC_MSG_ERROR([mysqladmin cannot run with root password = rootpass])
fi
DATADIR_PATTERN='^|[[[:blank:]]]*datadir[[[:blank:]]]*|[[[:blank:]]]*\([[^[:blank:]]][[^[:blank:]]]*\)[[[:blank:]]]*|'
MYSQL_DATADIR=`$MYSQLADMIN -u root -prootpass variables 2> /dev/null | grep $DATADIR_PATTERN | sed "s/$DATADIR_PATTERN/\1/"`;dnl
])
