
#include <fstream>

#include "population_event_factory.hh"


#include <ctype.h>           // for isdigit

#include "../tools/string_util.hh"

#include "../main/analyze_util.hh"
#include "../main/avida.hh"
#include "../main/config.hh"
#include "../main/genebank.hh"
#include "../main/genotype.hh"
#include "../cpu/hardware_method.hh"
#include "../main/inject_genebank.hh"
#include "../main/inject_genotype.hh"
#include "../main/inst_util.hh"
#include "../main/landscape.hh"
#include "../main/lineage_control.hh"
#include "../main/organism.hh"
#include "../main/phenotype.hh"
#include "../main/population.hh"
#include "../main/population_cell.hh"
#include "../main/stats.hh"
#include "../main/tasks.hh"

#include "../cpu/test_cpu.hh"
#include "../cpu/test_util.hh"

#include "../viewers/symbol_util.hh"


using namespace std;


/////////////////
// cAvidaEvent
/////////////////

cPopulationEvent::cPopulationEvent(const cString & name, const cString & args):
   cEvent(name, args)
{
}


/////////////////
//  events derived from cPopulationEvent (autogenerated code)
/////////////////

// The Process() functions
using namespace std;
#include "cPopulation_process_auto.ci"

// EventNameToEnum()
#include "cPopulation_name2enum_auto.ci"


/////////////////
// cPopulationEventFactory
/////////////////

cPopulationEventFactory::cPopulationEventFactory( cPopulation *pop ) 
  : m_population( pop )
{
}

cPopulationEventFactory::~cPopulationEventFactory()
{
}

//******* construction of events **********//
cEvent *
cPopulationEventFactory::ConstructEvent( int event_enum,
				    const cString & arg_list )
{
  cPopulationEvent *event = NULL;

  switch (event_enum){

#include "cPopulation_construct_event_auto.ci"

    default:
      event = NULL;
      break;
  }

  if( event != NULL ){
    // Have to setup the base class variables
    event->SetFactoryId( GetFactoryId() );

    assert( m_population != NULL );
    event->SetPopulation( m_population );
  }
  return event;
}




