/* Test of fmin() function. Random cases.
   $Id: fmin-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases	*/
    long x, y;		/* args		*/
    long z;		/* result	*/
} t[] = {

    /* x, y, fmin(x,y)	*/
    { 0x4518c494,0x40530a34,0x40530a34 }, /*   1:  2.4442861e+03  3.2974977e+00  3.2974977e+00 */
    { 0xbb0dcdbf,0x427a1a9b,0xbb0dcdbf }, /*   2: -2.1637527e-03  6.2525982e+01 -2.1637527e-03 */
    { 0x42e2ba64,0x3a001e6b,0x3a001e6b }, /*   3:  1.1336404e+02  4.8873451e-04  4.8873451e-04 */
    { 0x3ea4f261,0x3a3c9c16,0x3a3c9c16 }, /*   4:  3.2216170e-01  7.1948895e-04  7.1948895e-04 */
    { 0xc58923d2,0x45104b86,0xc58923d2 }, /*   5: -4.3884775e+03  2.3087202e+03 -4.3884775e+03 */
    { 0xc01cd648,0xbe992443,0xc01cd648 }, /*   6: -2.4505787e+00 -2.9910478e-01 -2.4505787e+00 */
    { 0x408e5ebd,0xc2a923b1,0xc2a923b1 }, /*   7:  4.4490647e+00 -8.4569710e+01 -8.4569710e+01 */
    { 0xbfccc835,0x343e8836,0xbfccc835 }, /*   8: -1.5998598e+00  1.7744682e-07 -1.5998598e+00 */
    { 0xc3c42264,0xbea361b1,0xc3c42264 }, /*   9: -3.9226868e+02 -3.1910470e-01 -3.9226868e+02 */
    { 0xc0812abc,0xc30aace3,0xc30aace3 }, /*  10: -4.0364666e+00 -1.3867534e+02 -1.3867534e+02 */
    { 0xbea787dd,0xbc541bc2,0xbea787dd }, /*  11: -3.2720843e-01 -1.2946071e-02 -3.2720843e-01 */
    { 0xbed8a2c4,0xba56becf,0xbed8a2c4 }, /*  12: -4.2311680e-01 -8.1918848e-04 -4.2311680e-01 */
    { 0xbaae1884,0x46195989,0xbaae1884 }, /*  13: -1.3282453e-03  9.8143838e+03 -1.3282453e-03 */
    { 0x3996f442,0x39ae824f,0x3996f442 }, /*  14:  2.8792216e-04  3.3284954e-04  2.8792216e-04 */
    { 0x3e854f80,0x3cedebcb,0x3cedebcb }, /*  15:  2.6037216e-01  2.9043099e-02  2.9043099e-02 */
    { 0xbeb1960c,0x3b8d17dc,0xbeb1960c }, /*  16: -3.4684789e-01  4.3058228e-03 -3.4684789e-01 */
    { 0xc3e76055,0xcaba474c,0xcaba474c }, /*  17: -4.6275259e+02 -6.1039740e+06 -6.1039740e+06 */
    { 0xc6044be4,0xcba87443,0xcba87443 }, /*  18: -8.4669727e+03 -2.2079622e+07 -2.2079622e+07 */
    { 0xb22b4785,0xc36227c3,0xc36227c3 }, /*  19: -9.9697717e-09 -2.2615532e+02 -2.2615532e+02 */
    { 0x3e86f5d5,0x4070a35c,0x3e86f5d5 }, /*  20:  2.6359430e-01  3.7599707e+00  2.6359430e-01 */
    { 0xc053185c,0xbd1f36b2,0xc053185c }, /*  21: -3.2983618e+00 -3.8870521e-02 -3.2983618e+00 */
    { 0xbee62f4e,0x438894ad,0xbee62f4e }, /*  22: -4.4957966e-01  2.7316153e+02 -4.4957966e-01 */
    { 0xbec490be,0x41e8de27,0xbec490be }, /*  23: -3.8391680e-01  2.9108473e+01 -3.8391680e-01 */
    { 0xcb019c16,0xbff98b3f,0xcb019c16 }, /*  24: -8.4941020e+06 -1.9495620e+00 -8.4941020e+06 */
    { 0x3ee9efbb,0x39c27263,0x39c27263 }, /*  25:  4.5690712e-01  3.7087788e-04  3.7087788e-04 */
    { 0x4044201c,0xbe9aeca7,0xbe9aeca7 }, /*  26:  3.0644598e+00 -3.0258676e-01 -3.0258676e-01 */
    { 0xc035a943,0xbad2253c,0xc035a943 }, /*  27: -2.8384559e+00 -1.6032825e-03 -2.8384559e+00 */
    { 0xc9801739,0xbb36d40e,0xc9801739 }, /*  28: -1.0493191e+06 -2.7897391e-03 -1.0493191e+06 */
    { 0x3d100802,0xbebf08fa,0xbebf08fa }, /*  29:  3.5163887e-02 -3.7311536e-01 -3.7311536e-01 */
    { 0xbac456ab,0xbbcba744,0xbbcba744 }, /*  30: -1.4979442e-03 -6.2150080e-03 -6.2150080e-03 */
    { 0x38632878,0x38cc7b8e,0x38632878 }, /*  31:  5.4158707e-05  9.7504919e-05  5.4158707e-05 */
    { 0xc1d378c0,0xbd9ef81d,0xc1d378c0 }, /*  32: -2.6433960e+01 -7.7621676e-02 -2.6433960e+01 */
    { 0x422d1b82,0x4034fb06,0x4034fb06 }, /*  33:  4.3276863e+01  2.8278213e+00  2.8278213e+00 */
    { 0xbde755fc,0xbd789cc2,0xbde755fc }, /*  34: -1.1295697e-01 -6.0696371e-02 -1.1295697e-01 */
    { 0x433b9b57,0x367c2e59,0x367c2e59 }, /*  35:  1.8760680e+02  3.7577904e-06  3.7577904e-06 */
    { 0xc13f5289,0x4cbbf1ce,0xc13f5289 }, /*  36: -1.1957650e+01  9.8537072e+07 -1.1957650e+01 */
    { 0x41fce669,0xcf95ffb4,0xcf95ffb4 }, /*  37:  3.1612505e+01 -5.0331259e+09 -5.0331259e+09 */
    { 0xc2ad564d,0x4f4d8fab,0xc2ad564d }, /*  38: -8.6668556e+01  3.4487447e+09 -8.6668556e+01 */
    { 0xc24343fd,0x2db4ae15,0xc24343fd }, /*  39: -4.8816395e+01  2.0540939e-11 -4.8816395e+01 */
    { 0xbcef60b9,0xc1eba0bf,0xc1eba0bf }, /*  40: -2.9220926e-02 -2.9453489e+01 -2.9453489e+01 */
    { 0xc0521199,0xc26e6eb7,0xc26e6eb7 }, /*  41: -3.2823241e+00 -5.9608120e+01 -5.9608120e+01 */
    { 0xcd7fca86,0x430c5eef,0xcd7fca86 }, /*  42: -2.6821642e+08  1.4037083e+02 -2.6821642e+08 */
    { 0xc5493e50,0x42a96fcc,0xc5493e50 }, /*  43: -3.2198945e+03  8.4718353e+01 -3.2198945e+03 */
    { 0xbfe9f909,0x3c6075dd,0xbfe9f909 }, /*  44: -1.8279124e+00  1.3699976e-02 -1.8279124e+00 */
    { 0x3ccf58f6,0xc3ece48f,0xc3ece48f }, /*  45:  2.5310975e-02 -4.7378561e+02 -4.7378561e+02 */
    { 0x3bdb3255,0xc085ac6e,0xc085ac6e }, /*  46:  6.6893497e-03 -4.1772985e+00 -4.1772985e+00 */
    { 0xbc696efc,0xbc210bbd,0xbc696efc }, /*  47: -1.4247652e-02 -9.8294588e-03 -1.4247652e-02 */
    { 0x405df69c,0xb7a4ef58,0xb7a4ef58 }, /*  48:  3.4681768e+00 -1.9661777e-05 -1.9661777e-05 */
    { 0xc24c5795,0xb473daca,0xc24c5795 }, /*  49: -5.1085529e+01 -2.2710734e-07 -5.1085529e+01 */
    { 0xc17117fd,0x3c4ac774,0xc17117fd }, /*  50: -1.5068357e+01  1.2376655e-02 -1.5068357e+01 */
    { 0xc18f30da,0x420610ba,0xc18f30da }, /*  51: -1.7898853e+01  3.3516335e+01 -1.7898853e+01 */
    { 0xba10eeac,0xc1808d74,0xc1808d74 }, /*  52: -5.5287289e-04 -1.6069069e+01 -1.6069069e+01 */
    { 0xc29280fe,0xbbb6c3be,0xc29280fe }, /*  53: -7.3251938e+01 -5.5775335e-03 -7.3251938e+01 */
    { 0x43a36815,0xc4122ecf,0xc4122ecf }, /*  54:  3.2681314e+02 -5.8473138e+02 -5.8473138e+02 */
    { 0xd85e8b30,0x3eaf78b7,0xd85e8b30 }, /*  55: -9.7875755e+14  3.4271786e-01 -9.7875755e+14 */
    { 0x3e018c91,0xc50e0d32,0xc50e0d32 }, /*  56:  1.2651278e-01 -2.2728247e+03 -2.2728247e+03 */
    { 0xc30d24eb,0xc8e1d4dc,0xc8e1d4dc }, /*  57: -1.4114421e+02 -4.6250288e+05 -4.6250288e+05 */
    { 0x3c494462,0x3886a59d,0x3886a59d }, /*  58:  1.2284370e-02  6.4204658e-05  6.4204658e-05 */
    { 0xb86437ad,0x441ee159,0xb86437ad }, /*  59: -5.4411288e-05  6.3552106e+02 -5.4411288e-05 */
    { 0xb9349d1c,0xc230818f,0xc230818f }, /*  60: -1.7224665e-04 -4.4126522e+01 -4.4126522e+01 */
    { 0x37ba97ba,0xc07502e9,0xc07502e9 }, /*  61:  2.2243581e-05 -3.8283026e+00 -3.8283026e+00 */
    { 0xc4da3862,0xc202c4f9,0xc4da3862 }, /*  62: -1.7457620e+03 -3.2692356e+01 -1.7457620e+03 */
    { 0xd56719ad,0xc5ea7a26,0xd56719ad }, /*  63: -1.5881091e+13 -7.5032686e+03 -1.5881091e+13 */
    { 0xaaa8ba26,0xbc75ba15,0xbc75ba15 }, /*  64: -2.9971961e-13 -1.4997979e-02 -1.4997979e-02 */
    { 0xc6432bae,0x400f9ee8,0xc6432bae }, /*  65: -1.2490920e+04  2.2440739e+00 -1.2490920e+04 */
    { 0xc3eef7d9,0xc4c13830,0xc4c13830 }, /*  66: -4.7793631e+02 -1.5457559e+03 -1.5457559e+03 */
    { 0xc1c7e7ea,0x3c12f2a0,0xc1c7e7ea }, /*  67: -2.4988239e+01  8.9689791e-03 -2.4988239e+01 */
    { 0x3f800000,0xbae8db3c,0xbae8db3c }, /*  68:  1.0000000e+00 -1.7765532e-03 -1.7765532e-03 */
    { 0xc05b119d,0xc711808b,0xc711808b }, /*  69: -3.4229500e+00 -3.7248543e+04 -3.7248543e+04 */
    { 0x3d3c0583,0x29a3a59c,0x29a3a59c }, /*  70:  4.5903694e-02  7.2673828e-14  7.2673828e-14 */
    { 0x41d0aaa5,0xbc3fcf87,0xbc3fcf87 }, /*  71:  2.6083323e+01 -1.1707193e-02 -1.1707193e-02 */
    { 0xbb550bc8,0x4acd5217,0xbb550bc8 }, /*  72: -3.2508243e-03  6.7279475e+06 -3.2508243e-03 */
    { 0x3a41c14b,0x3da1026f,0x3a41c14b }, /*  73:  7.3911686e-04  7.8617923e-02  7.3911686e-04 */
    { 0xbc859c02,0x390611e3,0xbc859c02 }, /*  74: -1.6309742e-02  1.2785899e-04 -1.6309742e-02 */
    { 0xbee76a3b,0x417f818d,0xbee76a3b }, /*  75: -4.5198235e-01  1.5969129e+01 -4.5198235e-01 */
    { 0xc07a6d9b,0x3eab08af,0xc07a6d9b }, /*  76: -3.9129398e+00  3.3405063e-01 -3.9129398e+00 */
    { 0xde5fed80,0xc3876d55,0xde5fed80 }, /*  77: -4.0339234e+18 -2.7085416e+02 -4.0339234e+18 */
    { 0x495afb40,0xbab9e074,0xbab9e074 }, /*  78:  8.9694800e+05 -1.4181272e-03 -1.4181272e-03 */
    { 0x39d0fde0,0x3e9743b5,0x39d0fde0 }, /*  79:  3.9862003e-04  2.9543844e-01  3.9862003e-04 */
    { 0x402384b5,0x5cb96862,0x402384b5 }, /*  80:  2.5549748e+00  4.1750113e+17  2.5549748e+00 */
    { 0x393d5de6,0xc44788e2,0xc44788e2 }, /*  81:  1.8059424e-04 -7.9813879e+02 -7.9813879e+02 */
    { 0x363bc978,0xc06ab9db,0xc06ab9db }, /*  82:  2.7982442e-06 -3.6675937e+00 -3.6675937e+00 */
    { 0xc663961c,0x3bef5d2a,0xc663961c }, /*  83: -1.4565527e+04  7.3048072e-03 -1.4565527e+04 */
    { 0xbbcbaa7c,0xc0208ee1,0xc0208ee1 }, /*  84: -6.2153917e-03 -2.5087206e+00 -2.5087206e+00 */
    { 0x4671defd,0xb8376c3e,0xb8376c3e }, /*  85:  1.5479747e+04 -4.3731408e-05 -4.3731408e-05 */
    { 0xaf824851,0xc29220e7,0xc29220e7 }, /*  86: -2.3698246e-10 -7.3064262e+01 -7.3064262e+01 */
    { 0xc013ae50,0xc06b36b3,0xc06b36b3 }, /*  87: -2.3075142e+00 -3.6752136e+00 -3.6752136e+00 */
    { 0x3ad0233e,0xc03ac88d,0xc03ac88d }, /*  88:  1.5879644e-03 -2.9184906e+00 -2.9184906e+00 */
    { 0xc4aa5f6c,0x3e922cdc,0xc4aa5f6c }, /*  89: -1.3629819e+03  2.8549850e-01 -1.3629819e+03 */
    { 0x4897f950,0xc2a8f004,0xc2a8f004 }, /*  90:  3.1124250e+05 -8.4468781e+01 -8.4468781e+01 */
    { 0xccfdc76e,0xba5d0592,0xccfdc76e }, /*  91: -1.3305330e+08 -8.4313110e-04 -1.3305330e+08 */
    { 0x3880fe9f,0x43f14231,0x3880fe9f }, /*  92:  6.1509425e-05  4.8251712e+02  6.1509425e-05 */
    { 0x45deb2cc,0xbbbc0441,0xbbbc0441 }, /*  93:  7.1263496e+03 -5.7378118e-03 -5.7378118e-03 */
    { 0xbf054744,0x3b223088,0xbf054744 }, /*  94: -5.2061868e-01  2.4748165e-03 -5.2061868e-01 */
    { 0x3cb6cb79,0xbc460029,0xbc460029 }, /*  95:  2.2313820e-02 -1.2084999e-02 -1.2084999e-02 */
    { 0x35f94c04,0xbd1270de,0xbd1270de }, /*  96:  1.8574069e-06 -3.5752170e-02 -3.5752170e-02 */
    { 0xbcf3d916,0x531a6a54,0xbcf3d916 }, /*  97: -2.9766601e-02  6.6320885e+11 -2.9766601e-02 */
    { 0x4030b43e,0xbebd9a21,0xbebd9a21 }, /*  98:  2.7610011e+00 -3.7031654e-01 -3.7031654e-01 */
    { 0xc2b45b5b,0x400ec39f,0xc2b45b5b }, /*  99: -9.0178429e+01  2.2306898e+00 -9.0178429e+01 */
    { 0xc00f60d6,0xc4cd2361,0xc4cd2361 }, /* 100: -2.2402854e+00 -1.6411056e+03 -1.6411056e+03 */
    { 0xc78ff5fb,0x4311545a,0xc78ff5fb }, /* 101: -7.3707961e+04  1.4532950e+02 -7.3707961e+04 */
    { 0xc083cbd2,0x3f127669,0xc083cbd2 }, /* 102: -4.1186304e+00  5.7211930e-01 -4.1186304e+00 */
    { 0x35f49a15,0x2ddc4fff,0x2ddc4fff }, /* 103:  1.8224260e-06  2.5046630e-11  2.5046630e-11 */
    { 0xc2fc15f3,0x401a8b10,0xc2fc15f3 }, /* 104: -1.2604287e+02  2.4147377e+00 -1.2604287e+02 */
    { 0xbee5079e,0xbb085c14,0xbee5079e }, /* 105: -4.4732374e-01 -2.0806836e-03 -4.4732374e-01 */
    { 0x3ea5e672,0xc1a9fc22,0xc1a9fc22 }, /* 106:  3.2402378e-01 -2.1248112e+01 -2.1248112e+01 */
    { 0xc316f449,0x49cde072,0xc316f449 }, /* 107: -1.5095424e+02  1.6865422e+06 -1.5095424e+02 */
    { 0xc2f850dc,0xc35b698d,0xc35b698d }, /* 108: -1.2415793e+02 -2.1941231e+02 -2.1941231e+02 */
    { 0x3d8188cc,0xb655e55d,0xb655e55d }, /* 109:  6.3249201e-02 -3.1872980e-06 -3.1872980e-06 */
    { 0x34cd5450,0xb41fd5bb,0xb41fd5bb }, /* 110:  3.8245571e-07 -1.4885784e-07 -1.4885784e-07 */
    { 0x3acdee53,0x448961f4,0x3acdee53 }, /* 111:  1.5711285e-03  1.0990610e+03  1.5711285e-03 */
    { 0xc02ecbc7,0x43d892b0,0xc02ecbc7 }, /* 112: -2.7311876e+00  4.3314600e+02 -2.7311876e+00 */
    { 0xc26fd93b,0x49a7c488,0xc26fd93b }, /* 113: -5.9962139e+01  1.3743530e+06 -5.9962139e+01 */
    { 0xf56397bb,0xb94eec8f,0xf56397bb }, /* 114: -2.8850802e+32 -1.9733816e-04 -2.8850802e+32 */
    { 0x8a8e60ab,0x400eb702,0x8a8e60ab }, /* 115: -1.3710465e-32  2.2299199e+00 -1.3710465e-32 */
    { 0x1ca6eb4d,0x3b59d821,0x1ca6eb4d }, /* 116:  1.1045782e-21  3.3240395e-03  1.1045782e-21 */
    { 0x35dd5377,0xbec2565d,0xbec2565d }, /* 117:  1.6490075e-06 -3.7956515e-01 -3.7956515e-01 */
    { 0x3ec21583,0x449744c3,0x3ec21583 }, /* 118:  3.7907037e-01  1.2101488e+03  3.7907037e-01 */
    { 0xc07be7aa,0x3d91b89f,0xc07be7aa }, /* 119: -3.9360147e+00  7.1152918e-02 -3.9360147e+00 */
    { 0xc3f07969,0x3d5e30a5,0xc3f07969 }, /* 120: -4.8094852e+02  5.4245610e-02 -4.8094852e+02 */
    { 0xbac2bf6d,0x3e8ce6d0,0xbac2bf6d }, /* 121: -1.4858075e-03  2.7519846e-01 -1.4858075e-03 */
    { 0x3f1b2fb9,0x436ae011,0x3f1b2fb9 }, /* 122:  6.0619694e-01  2.3487526e+02  6.0619694e-01 */
    { 0x2a913294,0xc04babf0,0xc04babf0 }, /* 123:  2.5792270e-13 -3.1823692e+00 -3.1823692e+00 */
    { 0x38f79c02,0xbf55b73f,0xbf55b73f }, /* 124:  1.1806937e-04 -8.3482736e-01 -8.3482736e-01 */
    { 0xc25c41e0,0xe79fcac5,0xe79fcac5 }, /* 125: -5.5064331e+01 -1.5091934e+24 -1.5091934e+24 */
    { 0xbe9f06be,0x3b331ea6,0xbe9f06be }, /* 126: -3.1059831e-01  2.7331500e-03 -3.1059831e-01 */
    { 0xbea8ce27,0xb9bf8128,0xbea8ce27 }, /* 127: -3.2969782e-01 -3.6526588e-04 -3.2969782e-01 */
    { 0xbfcc63b9,0xc1cf1f15,0xc1cf1f15 }, /* 128: -1.5967933e+00 -2.5890177e+01 -2.5890177e+01 */
    { 0x3eaa7293,0x401f4fcd,0x3eaa7293 }, /* 129:  3.3290538e-01  2.4892457e+00  3.3290538e-01 */
    { 0x3e807c12,0x3edafd9c,0x3e807c12 }, /* 130:  2.5094658e-01  4.2771614e-01  2.5094658e-01 */
    { 0xc0661023,0xc4603d0f,0xc4603d0f }, /* 131: -3.5947349e+00 -8.9695404e+02 -8.9695404e+02 */
    { 0x2e36d6ff,0x45c7bad4,0x2e36d6ff }, /* 132:  4.1572964e-11  6.3913535e+03  4.1572964e-11 */
    { 0x3cd098db,0x5deebc51,0x3cd098db }, /* 133:  2.5463512e-02  2.1503392e+18  2.5463512e-02 */
    { 0x28d9fa81,0x40163b6e,0x28d9fa81 }, /* 134:  2.4200478e-14  2.3473773e+00  2.4200478e-14 */
    { 0xb1d64bd6,0x27600712,0xb1d64bd6 }, /* 135: -6.2368413e-09  3.1090078e-15 -6.2368413e-09 */
    { 0x48ce7c09,0xd322e6db,0xd322e6db }, /* 136:  4.2288028e+05 -6.9965781e+11 -6.9965781e+11 */
    { 0x446538dc,0x3f0fc664,0x3f0fc664 }, /* 137:  9.1688843e+02  5.6162095e-01  5.6162095e-01 */
    { 0xc2f2a485,0xb62f8a31,0xc2f2a485 }, /* 138: -1.2132133e+02 -2.6157470e-06 -1.2132133e+02 */
    { 0x407ad4fe,0xbb6ef3dc,0xbb6ef3dc }, /* 139:  3.9192500e+00 -3.6461269e-03 -3.6461269e-03 */
    { 0x8cd90ea0,0x4191ed17,0x8cd90ea0 }, /* 140: -3.3442946e-31  1.8240767e+01 -3.3442946e-31 */
    { 0x43916b9a,0x3d64f653,0x3d64f653 }, /* 141:  2.9084064e+02  5.5898976e-02  5.5898976e-02 */
    { 0xc4ee3bc4,0x3ec4c27c,0xc4ee3bc4 }, /* 142: -1.9058677e+03  3.8429630e-01 -1.9058677e+03 */
    { 0xc1f92846,0x47074927,0xc1f92846 }, /* 143: -3.1144665e+01  3.4633152e+04 -3.1144665e+01 */
    { 0xc199b255,0x4a44e364,0xc199b255 }, /* 144: -1.9212076e+01  3.2258170e+06 -1.9212076e+01 */
    { 0x3cabd00a,0xbeccb24c,0xbeccb24c }, /* 145:  2.0973224e-02 -3.9979780e-01 -3.9979780e-01 */
    { 0xc365cb38,0xc20f76ab,0xc365cb38 }, /* 146: -2.2979382e+02 -3.5865887e+01 -2.2979382e+02 */
    { 0x3cae2d52,0xbcfd4bb7,0xbcfd4bb7 }, /* 147:  2.1261845e-02 -3.0919893e-02 -3.0919893e-02 */
    { 0xbcb1ce37,0xbfb8a692,0xbfb8a692 }, /* 148: -2.1704776e-02 -1.4425833e+00 -1.4425833e+00 */
    { 0xd4233d70,0xbeaa81e9,0xd4233d70 }, /* 149: -2.8044417e+12 -3.3302239e-01 -2.8044417e+12 */
    { 0x3d08e417,0x3b08b5fc,0x3b08b5fc }, /* 150:  3.3420648e-02  2.0860424e-03  2.0860424e-03 */
    { 0x3fca79d5,0x3fd956de,0x3fca79d5 }, /* 151:  1.5818430e+00  1.6979635e+00  1.5818430e+00 */
    { 0x3ea409e0,0xc2476fa0,0xc2476fa0 }, /* 152:  3.2038784e-01 -4.9859009e+01 -4.9859009e+01 */
    { 0xbfdae2a3,0xc029f79b,0xc029f79b }, /* 153: -1.7100414e+00 -2.6557376e+00 -2.6557376e+00 */
    { 0x3bc79d02,0x3e8a71f4,0x3bc79d02 }, /* 154:  6.0917148e-03  2.7040064e-01  6.0917148e-03 */
    { 0xbbe656b3,0xbeecb714,0xbeecb714 }, /* 155: -7.0293783e-03 -4.6233428e-01 -4.6233428e-01 */
    { 0x3a9c55a8,0x40226b21,0x3a9c55a8 }, /* 156:  1.1927383e-03  2.5377886e+00  1.1927383e-03 */
    { 0x3b31ac3d,0x3af785ef,0x3af785ef }, /* 157:  2.7110719e-03  1.8884520e-03  1.8884520e-03 */
    { 0xbe976f4c,0x4527f0e2,0xbe976f4c }, /* 158: -2.9577100e-01  2.6870552e+03 -2.9577100e-01 */
    { 0xbc3a6ba0,0xc042ffca,0xc042ffca }, /* 159: -1.1378199e-02 -3.0468621e+00 -3.0468621e+00 */
    { 0x4074ba58,0xbd1e5bde,0xbd1e5bde }, /* 160:  3.8238735e+00 -3.8661830e-02 -3.8661830e-02 */
    { 0x3fe60be9,0x3a0aeaba,0x3a0aeaba }, /* 161:  1.7972385e+00  5.2992592e-04  5.2992592e-04 */
    { 0x461335c9,0x3b27cb0e,0x3b27cb0e }, /* 162:  9.4214463e+03  2.5603208e-03  2.5603208e-03 */
    { 0xc715a710,0xbb7f641d,0xc715a710 }, /* 163: -3.8311062e+04 -3.8969584e-03 -3.8311062e+04 */
    { 0xb7d70094,0x4a3ccdfe,0xb7d70094 }, /* 164: -2.5630266e-05  3.0933755e+06 -2.5630266e-05 */
    { 0xbce2a592,0x43caa370,0xbce2a592 }, /* 165: -2.7666841e-02  4.0527686e+02 -2.7666841e-02 */
    { 0xc23cac80,0xbe81b006,0xc23cac80 }, /* 166: -4.7168457e+01 -2.5329608e-01 -4.7168457e+01 */
    { 0xaf23bce1,0x439db3dd,0xaf23bce1 }, /* 167: -1.4891867e-10  3.1540518e+02 -1.4891867e-10 */
    { 0xbd4d638c,0xc253f062,0xc253f062 }, /* 168: -5.0143763e-02 -5.2984749e+01 -5.2984749e+01 */
    { 0xb7ea97fb,0xab5ff9eb,0xb7ea97fb }, /* 169: -2.7965745e-05 -7.9572346e-13 -2.7965745e-05 */
    { 0xbfd445af,0xc737c1a4,0xc737c1a4 }, /* 170: -1.6583766e+00 -4.7041641e+04 -4.7041641e+04 */
    { 0xb95199b9,0xc06f9d1b,0xc06f9d1b }, /* 171: -1.9989059e-04 -3.7439640e+00 -3.7439640e+00 */
    { 0xdf149341,0x3ea339c5,0xdf149341 }, /* 172: -1.0705972e+19  3.1880012e-01 -1.0705972e+19 */
    { 0x3ea614f6,0xbd282632,0xbd282632 }, /* 173:  3.2437867e-01 -4.1052051e-02 -4.1052051e-02 */
    { 0xb6d25a5c,0x3c870037,0xb6d25a5c }, /* 174: -6.2690069e-06  1.6479595e-02 -6.2690069e-06 */
    { 0xbc1b49f5,0xbec71748,0xbec71748 }, /* 175: -9.4780819e-03 -3.8884950e-01 -3.8884950e-01 */
    { 0x403f9dbb,0x44fd2bc8,0x403f9dbb }, /* 176:  2.9940021e+00  2.0253682e+03  2.9940021e+00 */
    { 0x43074ae0,0x402873bb,0x402873bb }, /* 177:  1.3529248e+02  2.6320636e+00  2.6320636e+00 */
    { 0x39cc97eb,0xc3bcd9d6,0xc3bcd9d6 }, /* 178:  3.9023100e-04 -3.7770184e+02 -3.7770184e+02 */
    { 0x40371266,0x643cbb44,0x40371266 }, /* 179:  2.8604980e+00  1.3925927e+22  2.8604980e+00 */
    { 0xc0877ac5,0x4277707b,0xc0877ac5 }, /* 180: -4.2337365e+00  6.1859844e+01 -4.2337365e+00 */
    { 0xc1a8374a,0xbd13a476,0xc1a8374a }, /* 181: -2.1026997e+01 -3.6045514e-02 -2.1026997e+01 */
    { 0xbda30d35,0xa5f67248,0xbda30d35 }, /* 182: -7.9615034e-02 -4.2751637e-16 -7.9615034e-02 */
    { 0xc8274934,0x3f38a7c5,0xc8274934 }, /* 183: -1.7130081e+05  7.2130996e-01 -1.7130081e+05 */
    { 0xbef20775,0xbff01f26,0xbff01f26 }, /* 184: -4.7271314e-01 -1.8759506e+00 -1.8759506e+00 */
    { 0xc33db90b,0x46a4e4e2,0xc33db90b }, /* 185: -1.8972282e+02  2.1106441e+04 -1.8972282e+02 */
    { 0xc204e756,0x3b17e74b,0xc204e756 }, /* 186: -3.3225914e+01  2.3178633e-03 -3.3225914e+01 */
    { 0x405eb09c,0x3a58aaec,0x3a58aaec }, /* 187:  3.4795294e+00  8.2652154e-04  8.2652154e-04 */
    { 0x40236218,0x3da978ad,0x3da978ad }, /* 188:  2.5528622e+00  8.2749702e-02  8.2749702e-02 */
    { 0xbec4798e,0xb8358277,0xbec4798e }, /* 189: -3.8373989e-01 -4.3275268e-05 -3.8373989e-01 */
    { 0x4082d466,0x3bcbe57f,0x3bcbe57f }, /* 190:  4.0884275e+00  6.2224264e-03  6.2224264e-03 */
    { 0xbda7b2e0,0xb84a5f69,0xbda7b2e0 }, /* 191: -8.1884146e-02 -4.8249411e-05 -8.1884146e-02 */
    { 0x3c046062,0x3b2306f0,0x3b2306f0 }, /* 192:  8.0796201e-03  2.4875961e-03  2.4875961e-03 */
    { 0xc01af753,0xc3bfd748,0xc3bfd748 }, /* 193: -2.4213455e+00 -3.8368188e+02 -3.8368188e+02 */
    { 0xbe92507e,0xc581015d,0xc581015d }, /* 194: -2.8577036e-01 -4.1281704e+03 -4.1281704e+03 */
    { 0x3ed0f3df,0xc026df00,0xc026df00 }, /* 195:  4.0811059e-01 -2.6073608e+00 -2.6073608e+00 */
    { 0x4044535d,0xbc531e79,0xbc531e79 }, /* 196:  3.0675881e+00 -1.2885683e-02 -1.2885683e-02 */
    { 0x3522d96a,0xc2c63595,0xc2c63595 }, /* 197:  6.0666082e-07 -9.9104652e+01 -9.9104652e+01 */
    { 0x4087a492,0x34f3e780,0x34f3e780 }, /* 198:  4.2388391e+00  4.5430716e-07  4.5430716e-07 */
    { 0xc0403d18,0xbeeccdd1,0xc0403d18 }, /* 199: -3.0037289e+00 -4.6250775e-01 -3.0037289e+00 */
    { 0xbbaaca93,0xc213ae0d,0xc213ae0d }, /* 200: -5.2121370e-03 -3.6919971e+01 -3.6919971e+01 */
    { 0xad2523c3,0xb1fd19e9,0xb1fd19e9 }, /* 201: -9.3871048e-12 -7.3662147e-09 -7.3662147e-09 */
    { 0xc289862a,0x3ed78b08,0xc289862a }, /* 202: -6.8762039e+01  4.2098260e-01 -6.8762039e+01 */
    { 0x403ba199,0xc03b2e5c,0xc03b2e5c }, /* 203:  2.9317381e+00 -2.9247046e+00 -2.9247046e+00 */
    { 0xbe94e768,0xb412dfb2,0xbe94e768 }, /* 204: -2.9082799e-01 -1.3678689e-07 -2.9082799e-01 */
    { 0x3cd4b896,0x41d3b3d3,0x3cd4b896 }, /* 205:  2.5966924e-02  2.6462805e+01  2.5966924e-02 */
    { 0x3ca84342,0x3b913ef6,0x3b913ef6 }, /* 206:  2.0539884e-02  4.4325544e-03  4.4325544e-03 */
    { 0xc8add801,0xc225c0ab,0xc8add801 }, /* 207: -3.5603203e+05 -4.1438152e+01 -3.5603203e+05 */
    { 0x4078248a,0xb90a5b6a,0xb90a5b6a }, /* 208:  3.8772302e+00 -1.3194760e-04 -1.3194760e-04 */
    { 0xc2203baa,0xc4aef245,0xc4aef245 }, /* 209: -4.0058266e+01 -1.3995709e+03 -1.3995709e+03 */
    { 0x404dc053,0x41f6bc8e,0x404dc053 }, /* 210:  3.2148635e+00  3.0842068e+01  3.2148635e+00 */
    { 0xca2e8bc1,0xc19a42f8,0xca2e8bc1 }, /* 211: -2.8597602e+06 -1.9282700e+01 -2.8597602e+06 */
    { 0xba763a05,0x90cb1a47,0xba763a05 }, /* 212: -9.3928009e-04 -8.0109869e-29 -9.3928009e-04 */
    { 0x418af596,0x51ff6d73,0x418af596 }, /* 213:  1.7369915e+01  1.3713161e+11  1.7369915e+01 */
    { 0x43e49617,0xca02d0b9,0xca02d0b9 }, /* 214:  4.5717258e+02 -2.1432782e+06 -2.1432782e+06 */
    { 0xcac201c5,0xc04b03ce,0xcac201c5 }, /* 215: -6.3572185e+06 -3.1721072e+00 -6.3572185e+06 */
    { 0x38de101b,0x40870383,0x38de101b }, /* 216:  1.0588785e-04  4.2191787e+00  1.0588785e-04 */
    { 0xbf45eaf7,0x3b84409f,0xbf45eaf7 }, /* 217: -7.7311653e-01  4.0360237e-03 -7.7311653e-01 */
    { 0xc05d451d,0xbea7c0c8,0xc05d451d }, /* 218: -3.4573433e+00 -3.2764268e-01 -3.4573433e+00 */
    { 0xbece0e1f,0x404b6e54,0xbece0e1f }, /* 219: -4.0245149e-01  3.1786089e+00 -4.0245149e-01 */
    { 0xb9089597,0x3a433eca,0xb9089597 }, /* 220: -1.3025697e-04  7.4480160e-04 -1.3025697e-04 */
    { 0x97f0d2a5,0xb9d7b688,0xb9d7b688 }, /* 221: -1.5562811e-24 -4.1143992e-04 -4.1143992e-04 */
    { 0x412833bd,0x3e87c929,0x3e87c929 }, /* 222:  1.0512631e+01  2.6520661e-01  2.6520661e-01 */
    { 0x3563d0b1,0x3eb4d76a,0x3563d0b1 }, /* 223:  8.4867776e-07  3.5320598e-01  8.4867776e-07 */
    { 0x3e952b8d,0x42cd31c1,0x3e952b8d }, /* 224:  2.9134789e-01  1.0259718e+02  2.9134789e-01 */
    { 0xbed0e640,0x40635d0e,0xbed0e640 }, /* 225: -4.0800667e-01  3.5525546e+00 -4.0800667e-01 */
    { 0x3e93bc08,0xbee39932,0xbee39932 }, /* 226:  2.8854394e-01 -4.4452816e-01 -4.4452816e-01 */
    { 0x400b3051,0x8c312728,0x8c312728 }, /* 227:  2.1748240e+00 -1.3647367e-31 -1.3647367e-31 */
    { 0xaa6332bd,0xebac6843,0xebac6843 }, /* 228: -2.0179254e-13 -4.1685521e+26 -4.1685521e+26 */
    { 0xba6af107,0xbdd9508f,0xbdd9508f }, /* 229: -8.9623075e-04 -1.0611068e-01 -1.0611068e-01 */
    { 0xb984143d,0xbea209e2,0xbea209e2 }, /* 230: -2.5192081e-04 -3.1648165e-01 -3.1648165e-01 */
    { 0x4256b132,0xbcef47fe,0xbcef47fe }, /* 231:  5.3673042e+01 -2.9209133e-02 -2.9209133e-02 */
    { 0xdd301ea5,0xbe738fc5,0xdd301ea5 }, /* 232: -7.9317264e+17 -2.3785312e-01 -7.9317264e+17 */
    { 0x40621625,0xb90f8476,0xb90f8476 }, /* 233:  3.5326016e+00 -1.3686888e-04 -1.3686888e-04 */
    { 0x40447740,0xbc62d01d,0xbc62d01d }, /* 234:  3.0697784e+00 -1.3843563e-02 -1.3843563e-02 */
    { 0xbbde1612,0xbe9d96b4,0xbe9d96b4 }, /* 235: -6.7775333e-03 -3.0779040e-01 -3.0779040e-01 */
    { 0xc8120ecf,0x4821fbf1,0xc8120ecf }, /* 236: -1.4956323e+05  1.6587177e+05 -1.4956323e+05 */
    { 0x3b04aeac,0xb7cc6da9,0xb7cc6da9 }, /* 237:  2.0245714e-03 -2.4369760e-05 -2.4369760e-05 */
    { 0xb7b3848b,0xb87c9455,0xb87c9455 }, /* 238: -2.1400183e-05 -6.0219627e-05 -6.0219627e-05 */
    { 0xb496485d,0xc3f5ffbf,0xc3f5ffbf }, /* 239: -2.7992328e-07 -4.9199802e+02 -4.9199802e+02 */
    { 0xba544c8a,0x3ecdb759,0xba544c8a }, /* 240: -8.0985634e-04  4.0178946e-01 -8.0985634e-04 */
    { 0xbaf2ab01,0xc75bd453,0xc75bd453 }, /* 241: -1.8514098e-03 -5.6276324e+04 -5.6276324e+04 */
    { 0x4209977d,0x2e55d74b,0x2e55d74b }, /* 242:  3.4397938e+01  4.8621811e-11  4.8621811e-11 */
    { 0x441836fd,0x3e7697b8,0x3e7697b8 }, /* 243:  6.0885919e+02  2.4081314e-01  2.4081314e-01 */
    { 0xbed645d6,0x3ff2d586,0xbed645d6 }, /* 244: -4.1850156e-01  1.8971412e+00 -4.1850156e-01 */
    { 0xbba53035,0xb56f3beb,0xbba53035 }, /* 245: -5.0411471e-03 -8.9121630e-07 -5.0411471e-03 */
    { 0x34f8cfd2,0xc66ae629,0xc66ae629 }, /* 246:  4.6344809e-07 -1.5033540e+04 -1.5033540e+04 */
    { 0xc093da94,0x2f61f615,0xc093da94 }, /* 247: -4.6204319e+00  2.0551057e-10 -4.6204319e+00 */
    { 0x3f36d50b,0x3ed5cbad,0x3ed5cbad }, /* 248:  7.1418828e-01  4.1756955e-01  4.1756955e-01 */
    { 0xbeb0c473,0x3edf4ca0,0xbeb0c473 }, /* 249: -3.4524879e-01  4.3613148e-01 -3.4524879e-01 */
    { 0xa1310b48,0x425fc54f,0xa1310b48 }, /* 250: -5.9984863e-19  5.5942684e+01 -5.9984863e-19 */
    { 0x6af3e1dc,0x452e246f,0x452e246f }, /* 251:  1.4741778e+26  2.7862771e+03  2.7862771e+03 */
    { 0xbec9869b,0xbe7d9441,0xbec9869b }, /* 252: -3.9360508e-01 -2.4763586e-01 -3.9360508e-01 */
    { 0x435e57be,0x3f800000,0x3f800000 }, /* 253:  2.2234274e+02  1.0000000e+00  1.0000000e+00 */
    { 0x3edfed37,0x3c0fcc66,0x3c0fcc66 }, /* 254:  4.3735668e-01  8.7767597e-03  8.7767597e-03 */
    { 0x3d222f24,0x3f45a82e,0x3d222f24 }, /* 255:  3.9595738e-02  7.7209747e-01  3.9595738e-02 */
    { 0x4381432b,0x44e20072,0x4381432b }, /* 256:  2.5852475e+02  1.8080139e+03  2.5852475e+02 */
    { 0xc7ee1c79,0xb7c422f6,0xc7ee1c79 }, /* 257: -1.2191295e+05 -2.3381301e-05 -1.2191295e+05 */
    { 0x449a10e5,0x44d180cf,0x449a10e5 }, /* 258:  1.2325280e+03  1.6760253e+03  1.2325280e+03 */
    { 0x3d2c8a8f,0xac882284,0xac882284 }, /* 259:  4.2124327e-02 -3.8691845e-12 -3.8691845e-12 */
    { 0xbc4eb0c1,0xb9e97952,0xbc4eb0c1 }, /* 260: -1.2615384e-02 -4.4531614e-04 -1.2615384e-02 */
    { 0xc02a9d2c,0xc355e77b,0xc355e77b }, /* 261: -2.6658430e+00 -2.1390422e+02 -2.1390422e+02 */
    { 0x3eba54d3,0xbe958074,0xbe958074 }, /* 262:  3.6392841e-01 -2.9199564e-01 -2.9199564e-01 */
    { 0x4180b910,0x3a880d7c,0x3a880d7c }, /* 263:  1.6090363e+01  1.0379995e-03  1.0379995e-03 */
    { 0x3c126f9d,0xbec7a2ec,0xbec7a2ec }, /* 264:  8.9377435e-03 -3.8991487e-01 -3.8991487e-01 */
    { 0xc6a7c107,0x35b8d06b,0xc6a7c107 }, /* 265: -2.1472514e+04  1.3769726e-06 -2.1472514e+04 */
    { 0x403b5b4d,0xbebbdc1c,0xbebbdc1c }, /* 266:  2.9274476e+00 -3.6691368e-01 -3.6691368e-01 */
    { 0xc08a7e64,0x37b76d54,0xc08a7e64 }, /* 267: -4.3279285e+00  2.1866210e-05 -4.3279285e+00 */
    { 0xde169bf0,0xc03f2941,0xde169bf0 }, /* 268: -2.7131329e+18 -2.9868929e+00 -2.7131329e+18 */
    { 0xc01286e4,0x436d4e60,0xc01286e4 }, /* 269: -2.2894831e+00  2.3730615e+02 -2.2894831e+00 */
    { 0x0ac7c540,0x3e9dc05c,0x0ac7c540 }, /* 270:  1.9237200e-32  3.0810821e-01  1.9237200e-32 */
    { 0x3ea5d7fc,0xbd70e7c6,0xbd70e7c6 }, /* 271:  3.2391346e-01 -5.8814786e-02 -5.8814786e-02 */
    { 0x3ec3ebf0,0x4542ea5e,0x3ec3ebf0 }, /* 272:  3.8265944e-01  3.1186479e+03  3.8265944e-01 */
    { 0x3b9560c2,0x3fdd76f0,0x3b9560c2 }, /* 273:  4.5586536e-03  1.7301922e+00  4.5586536e-03 */
    { 0x3ecf4ca5,0x4a13fcd4,0x3ecf4ca5 }, /* 274:  4.0488163e-01  2.4246290e+06  4.0488163e-01 */
    { 0xbc04a2d9,0x39bdb76e,0xbc04a2d9 }, /* 275: -8.0954665e-03  3.6185555e-04 -8.0954665e-03 */
    { 0x44ae68f9,0xbefff215,0xbefff215 }, /* 276:  1.3952804e+03 -4.9989381e-01 -4.9989381e-01 */
    { 0xbe9930f8,0x3b77925c,0xbe9930f8 }, /* 277: -2.9920173e-01  3.7776446e-03 -2.9920173e-01 */
    { 0x3b7c69e5,0xbbf36770,0xbbf36770 }, /* 278:  3.8515266e-03 -7.4281022e-03 -7.4281022e-03 */
    { 0x39aa657a,0x3cd69eb9,0x39aa657a }, /* 279:  3.2500533e-04  2.6198732e-02  3.2500533e-04 */
    { 0x3a6569a8,0xbd79af76,0xbd79af76 }, /* 280:  8.7514007e-04 -6.0958348e-02 -6.0958348e-02 */
    { 0xcb76cb42,0x05a587b1,0xcb76cb42 }, /* 281: -1.6173890e+07  1.5566371e-35 -1.6173890e+07 */
    { 0x42a95a64,0x3fd34246,0x3fd34246 }, /* 282:  8.4676544e+01  1.6504600e+00  1.6504600e+00 */
    { 0x02d3ab20,0xbd4a487d,0xbd4a487d }, /* 283:  3.1101884e-37 -4.9385536e-02 -4.9385536e-02 */
    { 0x3ea3d934,0xc296873f,0xc296873f }, /* 284:  3.2001650e-01 -7.5264153e+01 -7.5264153e+01 */
    { 0xbebf9279,0x30505dc6,0xbebf9279 }, /* 285: -3.7416437e-01  7.5803219e-10 -3.7416437e-01 */
    { 0x4ae3e159,0x3ec11824,0x3ec11824 }, /* 286:  7.4671805e+06  3.7713730e-01  3.7713730e-01 */
    { 0x44e5f5de,0xbee3fe05,0xbee3fe05 }, /* 287:  1.8396833e+03 -4.4529739e-01 -4.4529739e-01 */
    { 0x3cd88aa7,0xc3e6d3f6,0xc3e6d3f6 }, /* 288:  2.6433302e-02 -4.6165594e+02 -4.6165594e+02 */
    { 0x3a5c968e,0x3d4ed8a7,0x3a5c968e }, /* 289:  8.4147684e-04  5.0499585e-02  8.4147684e-04 */
    { 0x4eca345c,0x48b1b1ed,0x48b1b1ed }, /* 290:  1.6962145e+09  3.6391941e+05  3.6391941e+05 */
    { 0xbd7a7c57,0x3e7bbff8,0xbd7a7c57 }, /* 291: -6.1153736e-02  2.4584949e-01 -6.1153736e-02 */
    { 0x3ed44aa7,0xbdcfc4b8,0xbdcfc4b8 }, /* 292:  4.1463205e-01 -1.0144943e-01 -1.0144943e-01 */
    { 0xc5d83b0b,0xc8cef710,0xc8cef710 }, /* 293: -6.9193804e+03 -4.2386450e+05 -4.2386450e+05 */
    { 0x39339114,0xc2955566,0xc2955566 }, /* 294:  1.7124816e-04 -7.4666794e+01 -7.4666794e+01 */
    { 0x3d96f096,0x44d26432,0x3d96f096 }, /* 295:  7.3701069e-02  1.6831311e+03  7.3701069e-02 */
    { 0x43074c8d,0x403b5c6b,0x403b5c6b }, /* 296:  1.3529903e+02  2.9275157e+00  2.9275157e+00 */
    { 0xbe6ba8e6,0x3b8e171c,0xbe6ba8e6 }, /* 297: -2.3013648e-01  4.3362509e-03 -2.3013648e-01 */
    { 0xc1baf00f,0xbbdd3eae,0xc1baf00f }, /* 298: -2.3367216e+01 -6.7518568e-03 -2.3367216e+01 */
    { 0xc1d1c8bc,0x4198c9b8,0xc1d1c8bc }, /* 299: -2.6223015e+01  1.9098495e+01 -2.6223015e+01 */
    { 0xbf1b8214,0x41eb414e,0xbf1b8214 }, /* 300: -6.0745358e-01  2.9406887e+01 -6.0745358e-01 */
    { 0xbc3a11fc,0x490817ac,0xbc3a11fc }, /* 301: -1.1356827e-02  5.5743475e+05 -1.1356827e-02 */
    { 0x27b02efc,0x3fffcb95,0x27b02efc }, /* 302:  4.8900754e-15  1.9984003e+00  4.8900754e-15 */
    { 0x316b261c,0xbe7f3b38,0xbe7f3b38 }, /* 303:  3.4218663e-09 -2.4924934e-01 -2.4924934e-01 */
    { 0xb8f8d8a8,0xbaea94cf,0xbaea94cf }, /* 304: -1.1865917e-04 -1.7897132e-03 -1.7897132e-03 */
    { 0x44d1b827,0x43573605,0x43573605 }, /* 305:  1.6777548e+03  2.1521101e+02  2.1521101e+02 */
    { 0x3cff69c7,0x42e08187,0x3cff69c7 }, /* 306:  3.1178368e-02  1.1225298e+02  3.1178368e-02 */
    { 0xbed53b2a,0x38f1ded7,0xbed53b2a }, /* 307: -4.1646701e-01  1.1533283e-04 -4.1646701e-01 */
    { 0x40064945,0xc1b18318,0xc1b18318 }, /* 308:  2.0982220e+00 -2.2189011e+01 -2.2189011e+01 */
    { 0xc009d46b,0x3eb5edf8,0xc009d46b }, /* 309: -2.1535900e+00  3.5533118e-01 -2.1535900e+00 */
    { 0x3a89d55a,0x418496f2,0x3a89d55a }, /* 310:  1.0515854e-03  1.6573704e+01  1.0515854e-03 */
    { 0x48868aec,0x1c8d2a5b,0x1c8d2a5b }, /* 311:  2.7554338e+05  9.3415459e-22  9.3415459e-22 */
    { 0x3e8c72c1,0x43affebb,0x3e8c72c1 }, /* 312:  2.7431300e-01  3.5199008e+02  2.7431300e-01 */
    { 0xc1375a88,0xb011a96c,0xc1375a88 }, /* 313: -1.1459602e+01 -5.2991456e-10 -1.1459602e+01 */
    { 0x1c75d7f6,0xbc3fede1,0xbc3fede1 }, /* 314:  8.1342823e-22 -1.1714430e-02 -1.1714430e-02 */
    { 0x3e71193d,0x47628c59,0x3e71193d }, /* 315:  2.3544784e-01  5.7996348e+04  2.3544784e-01 */
    { 0xbddb72d5,0xc2a46415,0xc2a46415 }, /* 316: -1.0715262e-01 -8.2195473e+01 -8.2195473e+01 */
    { 0xbe8a49ee,0x41cc0de5,0xbe8a49ee }, /* 317: -2.7009529e-01  2.5506784e+01 -2.7009529e-01 */
    { 0x3ed70f50,0xc068ab34,0xc068ab34 }, /* 318:  4.2003870e-01 -3.6354494e+00 -3.6354494e+00 */
    { 0x3c3d4be3,0xcf26e32c,0xcf26e32c }, /* 319:  1.1553737e-02 -2.7999058e+09 -2.7999058e+09 */
    { 0xbeab9f98,0xbbbf6a39,0xbeab9f98 }, /* 320: -3.3520198e-01 -5.8415201e-03 -3.3520198e-01 */
    { 0x4140ca0c,0xba42cef3,0xba42cef3 }, /* 321:  1.2049328e+01 -7.4313505e-04 -7.4313505e-04 */
    { 0x41cf2709,0xbec3a340,0xbec3a340 }, /* 322:  2.5894060e+01 -3.8210487e-01 -3.8210487e-01 */
    { 0xbd056978,0x4043e8ce,0xbd056978 }, /* 323: -3.2571286e-02  3.0610843e+00 -3.2571286e-02 */
    { 0xc247cad1,0xc1521374,0xc247cad1 }, /* 324: -4.9948063e+01 -1.3129749e+01 -4.9948063e+01 */
    { 0x4312af85,0xbfc7cfa2,0xbfc7cfa2 }, /* 325:  1.4668562e+02 -1.5610240e+00 -1.5610240e+00 */
    { 0x3fd0d1c0,0x3e994699,0x3e994699 }, /* 326:  1.6314011e+00  2.9936674e-01  2.9936674e-01 */
    { 0x3c5641b8,0xbe4719ee,0xbe4719ee }, /* 327:  1.3077192e-02 -1.9443485e-01 -1.9443485e-01 */
    { 0x3d5fe20e,0xbc06820d,0xbc06820d }, /* 328:  5.4658942e-02 -8.2097175e-03 -8.2097175e-03 */
    { 0xc0294ecc,0x49168152,0xc0294ecc }, /* 329: -2.6454344e+00  6.1646912e+05 -2.6454344e+00 */
    { 0xc3886f5f,0xc7099751,0xc7099751 }, /* 330: -2.7287009e+02 -3.5223316e+04 -3.5223316e+04 */
    { 0xb608c2fe,0x3fc25a1f,0xb608c2fe }, /* 331: -2.0379080e-06  1.5183753e+00 -2.0379080e-06 */
    { 0x3eb4ef9d,0xc1ce6ddf,0xc1ce6ddf }, /* 332:  3.5339060e-01 -2.5803648e+01 -2.5803648e+01 */
    { 0xc069d07c,0xbef102ee,0xc069d07c }, /* 333: -3.6533499e+00 -4.7072548e-01 -3.6533499e+00 */
    { 0x4dc85629,0xb751194d,0xb751194d }, /* 334:  4.2013622e+08 -1.2463262e-05 -1.2463262e-05 */
    { 0x41554136,0xba1daeb1,0xba1daeb1 }, /* 335:  1.3328421e+01 -6.0151058e-04 -6.0151058e-04 */
    { 0xc6773279,0xc87068b3,0xc87068b3 }, /* 336: -1.5820618e+04 -2.4617880e+05 -2.4617880e+05 */
    { 0x4049d95b,0xb9b0c1da,0xb9b0c1da }, /* 337:  3.1538913e+00 -3.3713767e-04 -3.3713767e-04 */
    { 0x48cdb7e0,0xf4e0eac7,0xf4e0eac7 }, /* 338:  4.2131100e+05 -1.4255815e+32 -1.4255815e+32 */
    { 0xbc23701c,0x931ef39a,0xbc23701c }, /* 339: -9.9754594e-03 -2.0062509e-27 -9.9754594e-03 */
    { 0xbc6221d3,0xc1deb201,0xc1deb201 }, /* 340: -1.3802010e-02 -2.7836916e+01 -2.7836916e+01 */
    { 0xb8dd8457,0xb318f67c,0xb8dd8457 }, /* 341: -1.0562751e-04 -3.5614434e-08 -1.0562751e-04 */
    { 0x440ef901,0x418be7e8,0x418be7e8 }, /* 342:  5.7189069e+02  1.7488235e+01  1.7488235e+01 */
    { 0xbf800000,0xb7182c41,0xbf800000 }, /* 343: -1.0000000e+00 -9.0702097e-06 -1.0000000e+00 */
    { 0x061dd740,0xbb181ed8,0xbb181ed8 }, /* 344:  2.9686559e-35 -2.3211744e-03 -2.3211744e-03 */
    { 0xc4330efb,0x3ec2a0e3,0xc4330efb }, /* 345: -7.1623407e+02  3.8013372e-01 -7.1623407e+02 */
    { 0xc0586c55,0x3ea12b29,0xc0586c55 }, /* 346: -3.3816121e+00  3.1478241e-01 -3.3816121e+00 */
    { 0xba79c069,0xbec9d78b,0xbec9d78b }, /* 347: -9.5272675e-04 -3.9422259e-01 -3.9422259e-01 */
    { 0xc39c9f92,0xb9fea3e1,0xc39c9f92 }, /* 348: -3.1324664e+02 -4.8568755e-04 -3.1324664e+02 */
    { 0xbebc4a6a,0xb8fb97c9,0xbebc4a6a }, /* 349: -3.6775523e-01 -1.1996885e-04 -3.6775523e-01 */
    { 0x4214a310,0x3b7bd00b,0x3b7bd00b }, /* 350:  3.7159241e+01  3.8423564e-03  3.8423564e-03 */
    { 0xc2a22761,0xc06d8cf2,0xc2a22761 }, /* 351: -8.1076912e+01 -3.7117276e+00 -8.1076912e+01 */
    { 0x320bb573,0xc553cb63,0xc553cb63 }, /* 352:  8.1321216e-09 -3.3887117e+03 -3.3887117e+03 */
    { 0x3ea85371,0xbc4eb077,0xbc4eb077 }, /* 353:  3.2876161e-01 -1.2615315e-02 -1.2615315e-02 */
    { 0xcadeb5db,0xc05a931d,0xcadeb5db }, /* 354: -7.2977735e+06 -3.4152291e+00 -7.2977735e+06 */
    { 0xbea1ea4a,0x3b9e4270,0xbea1ea4a }, /* 355: -3.1624061e-01  4.8296973e-03 -3.1624061e-01 */
    { 0xada017e6,0x34ac3a35,0xada017e6 }, /* 356: -1.8200507e-11  3.2079848e-07 -1.8200507e-11 */
    { 0xd246fbf5,0xb3ede3d5,0xd246fbf5 }, /* 357: -2.1365767e+11 -1.1077615e-07 -2.1365767e+11 */
    { 0x40576c1d,0xb74d7bcc,0xb74d7bcc }, /* 358:  3.3659737e+00 -1.2247776e-05 -1.2247776e-05 */
    { 0xb4c87240,0xc02196bd,0xc02196bd }, /* 359: -3.7336031e-07 -2.5248253e+00 -2.5248253e+00 */
    { 0xc074dd80,0xbb38cc5b,0xc074dd80 }, /* 360: -3.8260193e+00 -2.8197977e-03 -3.8260193e+00 */
    { 0xb8d57892,0xc78de954,0xc78de954 }, /* 361: -1.0179089e-04 -7.2658656e+04 -7.2658656e+04 */
    { 0xc1e32988,0x3edac842,0xc1e32988 }, /* 362: -2.8395279e+01  4.2730910e-01 -2.8395279e+01 */
    { 0xc3a71568,0x44166399,0xc3a71568 }, /* 363: -3.3416724e+02  6.0155621e+02 -3.3416724e+02 */
    { 0xc02aae63,0x0ef7f5b6,0xc02aae63 }, /* 364: -2.6668937e+00  6.1126812e-30 -2.6668937e+00 */
    { 0xc28f6500,0xbc91b300,0xc28f6500 }, /* 365: -7.1697266e+01 -1.7785549e-02 -7.1697266e+01 */
    { 0x3a4a28de,0xf0aec186,0xf0aec186 }, /* 366:  7.7117782e-04 -4.3267478e+29 -4.3267478e+29 */
    { 0xb08b4425,0xbec9e1f6,0xbec9e1f6 }, /* 367: -1.0132949e-09 -3.9430207e-01 -3.9430207e-01 */
    { 0x3ed9a7b7,0x3f420879,0x3ed9a7b7 }, /* 368:  4.2510769e-01  7.5794178e-01  4.2510769e-01 */
    { 0xb886a6cd,0x3a53f125,0xb886a6cd }, /* 369: -6.4206870e-05  8.0849446e-04 -6.4206870e-05 */
    { 0x41daa2fc,0x2edec493,0x2edec493 }, /* 370:  2.7329582e+01  1.0130310e-10  1.0130310e-10 */
    { 0x3ecb0366,0xc206ba99,0xc206ba99 }, /* 371:  3.9651030e-01 -3.3682224e+01 -3.3682224e+01 */
    { 0xbf2c67f9,0x4253c203,0xbf2c67f9 }, /* 372: -6.7346150e-01  5.2939465e+01 -6.7346150e-01 */
    { 0x3350bb5b,0x425b93cd,0x3350bb5b }, /* 373:  4.8599173e-08  5.4894337e+01  4.8599173e-08 */
    { 0x3c74d01a,0x424a04c3,0x3c74d01a }, /* 374:  1.4942193e-02  5.0504650e+01  1.4942193e-02 */
    { 0xba5d1e20,0xbefd3605,0xbefd3605 }, /* 375: -8.4349699e-04 -4.9455276e-01 -4.9455276e-01 */
    { 0xbd3abc92,0xbb2fdd38,0xbd3abc92 }, /* 376: -4.5589991e-02 -2.6834738e-03 -4.5589991e-02 */
    { 0x46c4a444,0xc00cee01,0xc00cee01 }, /* 377:  2.5170133e+04 -2.2020266e+00 -2.2020266e+00 */
    { 0x3b84ad7a,0x3be7d6dd,0x3b84ad7a }, /* 378:  4.0490003e-03  7.0751742e-03  4.0490003e-03 */
    { 0x43d97fa4,0x41dd0c56,0x41dd0c56 }, /* 379:  4.3499719e+02  2.7631023e+01  2.7631023e+01 */
    { 0x440faa5c,0x3f800000,0x3f800000 }, /* 380:  5.7466187e+02  1.0000000e+00  1.0000000e+00 */
    { 0x45f921a2,0xd343ca6b,0xd343ca6b }, /* 381:  7.9722041e+03 -8.4091463e+11 -8.4091463e+11 */
    { 0x57daeb08,0xb109436a,0xb109436a }, /* 382:  4.8140597e+14 -1.9974444e-09 -1.9974444e-09 */
    { 0xb496b00a,0x41949033,0xb496b00a }, /* 383: -2.8067763e-07  1.8570410e+01 -2.8067763e-07 */
    { 0xc458abeb,0xc06dfe58,0xc458abeb }, /* 384: -8.6668622e+02 -3.7186489e+00 -8.6668622e+02 */
    { 0x45243da2,0xc4ad8081,0xc4ad8081 }, /* 385:  2.6278521e+03 -1.3880157e+03 -1.3880157e+03 */
    { 0xbb7228fc,0xc9b2501b,0xc9b2501b }, /* 386: -3.6950698e-03 -1.4607394e+06 -1.4607394e+06 */
    { 0xc03e402c,0x9e180161,0xc03e402c }, /* 387: -2.9726667e+00 -8.0470982e-21 -2.9726667e+00 */
    { 0xc0365bc9,0xc0380f84,0xc0380f84 }, /* 388: -2.8493521e+00 -2.8759470e+00 -2.8759470e+00 */
    { 0xba24cc65,0xbbf6e063,0xbbf6e063 }, /* 389: -6.2865607e-04 -7.5340732e-03 -7.5340732e-03 */
    { 0x433a7230,0x060a17be,0x060a17be }, /* 390:  1.8644604e+02  2.5972358e-35  2.5972358e-35 */
    { 0x4392f2ee,0xbf323c0f,0xbf323c0f }, /* 391:  2.9389789e+02 -6.9622892e-01 -6.9622892e-01 */
    { 0xe7ded62d,0x2deaf026,0xe7ded62d }, /* 392: -2.1046324e+24  2.6709367e-11 -2.1046324e+24 */
    { 0xbc9d1b80,0xc09457cd,0xc09457cd }, /* 393: -1.9178152e-02 -4.6357179e+00 -4.6357179e+00 */
    { 0xc4b04b5d,0xc09742c5,0xc4b04b5d }, /* 394: -1.4103551e+03 -4.7269006e+00 -1.4103551e+03 */
    { 0xc55d9aaa,0x4085cfe6,0xc55d9aaa }, /* 395: -3.5456665e+03  4.1816282e+00 -3.5456665e+03 */
    { 0x42509e38,0x4072c128,0x4072c128 }, /* 396:  5.2154510e+01  3.7930393e+00  3.7930393e+00 */
    { 0x40a8cebd,0x46d97772,0x40a8cebd }, /* 397:  5.2752366e+00  2.7835723e+04  5.2752366e+00 */
    { 0xcac2fea8,0xc5e991e7,0xcac2fea8 }, /* 398: -6.3895880e+06 -7.4742378e+03 -6.3895880e+06 */
    { 0xb6bd23dd,0xbec0d524,0xbec0d524 }, /* 399: -5.6368140e-06 -3.7662613e-01 -3.7662613e-01 */
    { 0xbec68659,0xc45d036b,0xc45d036b }, /* 400: -3.8774374e-01 -8.8405341e+02 -8.8405341e+02 */
    { 0xbf800000,0xbf800000,0xbf800000 }, /* 401: -1.0000000e+00 -1.0000000e+00 -1.0000000e+00 */
    { 0x40313f26,0x4047085b,0x40313f26 }, /* 402:  2.7694793e+00  3.1098850e+00  2.7694793e+00 */
    { 0x43d61adf,0xc8fe25c2,0xc8fe25c2 }, /* 403:  4.2820993e+02 -5.2049406e+05 -5.2049406e+05 */
    { 0x4037afb3,0x427bd8bd,0x4037afb3 }, /* 404:  2.8700988e+00  6.2961658e+01  2.8700988e+00 */
    { 0xc3436a29,0xb226f99e,0xc3436a29 }, /* 405: -1.9541469e+02 -9.7192281e-09 -1.9541469e+02 */
    { 0xc0565177,0x12233b7b,0xc0565177 }, /* 406: -3.3487222e+00  5.1507046e-28 -3.3487222e+00 */
    { 0x3f1e02bd,0x43dcb019,0x3f1e02bd }, /* 407:  6.1722928e-01  4.4137576e+02  6.1722928e-01 */
    { 0x3c5eceb3,0xbb6930e5,0xbb6930e5 }, /* 408:  1.3599086e-02 -3.5582122e-03 -3.5582122e-03 */
    { 0xcb8658c6,0xbcc2d314,0xcb8658c6 }, /* 409: -1.7609100e+07 -2.3782291e-02 -1.7609100e+07 */
    { 0xbc49c83e,0xc1d64b87,0xc1d64b87 }, /* 410: -1.2315808e-02 -2.6786879e+01 -2.6786879e+01 */
    { 0x43b18cea,0x45bd23ad,0x43b18cea }, /* 411:  3.5510089e+02  6.0524595e+03  3.5510089e+02 */
    { 0x44c9a710,0xbb53fc48,0xbb53fc48 }, /* 412:  1.6132207e+03 -3.2346416e-03 -3.2346416e-03 */
    { 0x3b638297,0xc2cb08d9,0xc2cb08d9 }, /* 413:  3.4715289e-03 -1.0151728e+02 -1.0151728e+02 */
    { 0xc229fde8,0x41d81622,0xc229fde8 }, /* 414: -4.2497955e+01  2.7010807e+01 -4.2497955e+01 */
    { 0x3e9009fc,0xc050c5ed,0xc050c5ed }, /* 415:  2.8132617e-01 -3.2620804e+00 -3.2620804e+00 */
    { 0x416eeaae,0x3a6242e5,0x3a6242e5 }, /* 416:  1.4932295e+01  8.6311839e-04  8.6311839e-04 */
    { 0xb81067fb,0xd009480a,0xd009480a }, /* 417: -3.4429115e-05 -9.2127990e+09 -9.2127990e+09 */
    { 0x3eb23694,0xb6e3ed33,0xb6e3ed33 }, /* 418:  3.4807265e-01 -6.7927408e-06 -6.7927408e-06 */
    { 0xbc196fd0,0xc05ecf66,0xc05ecf66 }, /* 419: -9.3650371e-03 -3.4814086e+00 -3.4814086e+00 */
    { 0xbf800000,0xc6479a40,0xc6479a40 }, /* 420: -1.0000000e+00 -1.2774562e+04 -1.2774562e+04 */
    { 0x367643a2,0xc26b69a1,0xc26b69a1 }, /* 421:  3.6696224e-06 -5.8853153e+01 -5.8853153e+01 */
    { 0x408946c6,0xc63bb1e8,0xc63bb1e8 }, /* 422:  4.2898893e+00 -1.2012477e+04 -1.2012477e+04 */
    { 0xbef7256b,0xc21c0df2,0xc21c0df2 }, /* 423: -4.8270735e-01 -3.9013618e+01 -3.9013618e+01 */
    { 0xbd250235,0x3c810a95,0xbd250235 }, /* 424: -4.0285308e-02  1.5752116e-02 -4.0285308e-02 */
    { 0xc576fe25,0xb7e7a525,0xc576fe25 }, /* 425: -3.9518840e+03 -2.7614247e-05 -3.9518840e+03 */
    { 0x3ed43ce4,0x07f6552a,0x07f6552a }, /* 426:  4.1452706e-01  3.7064021e-34  3.7064021e-34 */
    { 0xe0152a1f,0xbe722627,0xe0152a1f }, /* 427: -4.2993750e+19 -2.3647366e-01 -4.2993750e+19 */
    { 0x41f28086,0xc2e3b68d,0xc2e3b68d }, /* 428:  3.0312756e+01 -1.1385654e+02 -1.1385654e+02 */
    { 0x466ffcf9,0xc638c0ea,0xc638c0ea }, /* 429:  1.5359243e+04 -1.1824229e+04 -1.1824229e+04 */
    { 0x406b4bbd,0x39007e14,0x39007e14 }, /* 430:  3.6764977e+00  1.2253999e-04  1.2253999e-04 */
    { 0x3d4f5360,0xc83dd354,0xc83dd354 }, /* 431:  5.0616622e-02 -1.9438131e+05 -1.9438131e+05 */
    { 0xbb5b3ba3,0x3f3cf7c1,0xbb5b3ba3 }, /* 432: -3.3452294e-03  7.3815542e-01 -3.3452294e-03 */
    { 0xc819f96a,0x46cf232f,0xc819f96a }, /* 433: -1.5766966e+05  2.6513592e+04 -1.5766966e+05 */
    { 0x435429d7,0xbc8f8c87,0xbc8f8c87 }, /* 434:  2.1216344e+02 -1.7523063e-02 -1.7523063e-02 */
    { 0xc2eb08f9,0x3c131e33,0xc2eb08f9 }, /* 435: -1.1751752e+02  8.9793680e-03 -1.1751752e+02 */
    { 0xb7c2fb2a,0xc405c4a7,0xc405c4a7 }, /* 436: -2.3243560e-05 -5.3507269e+02 -5.3507269e+02 */
    { 0x36e974fa,0xbe9a124a,0xbe9a124a }, /* 437:  6.9575590e-06 -3.0092078e-01 -3.0092078e-01 */
    { 0x3c152017,0xbed28fe6,0xbed28fe6 }, /* 438:  9.1018891e-03 -4.1125411e-01 -4.1125411e-01 */
    { 0xbb05cb3a,0x41c8a859,0xbb05cb3a }, /* 439: -2.0415322e-03  2.5082201e+01 -2.0415322e-03 */
    { 0xc07019b0,0x3f05a549,0xc07019b0 }, /* 440: -3.7515678e+00  5.2205330e-01 -3.7515678e+00 */
    { 0xc0433e5b,0xc15997d9,0xc15997d9 }, /* 441: -3.0506809e+00 -1.3599572e+01 -1.3599572e+01 */
    { 0xc1ffa78a,0x3d693dbe,0xc1ffa78a }, /* 442: -3.1956806e+01  5.6943648e-02 -3.1956806e+01 */
    { 0x3eb1ec6e,0x4efb00dc,0x3eb1ec6e }, /* 443:  3.4750694e-01  2.1055688e+09  3.4750694e-01 */
    { 0x3e83444c,0xc259bdfa,0xc259bdfa }, /* 444:  2.5638044e-01 -5.4435524e+01 -5.4435524e+01 */
    { 0x43e465bd,0x43bc5d87,0x43bc5d87 }, /* 445:  4.5679483e+02  3.7673068e+02  3.7673068e+02 */
    { 0xc49b8328,0x9b4e7db3,0xc49b8328 }, /* 446: -1.2440986e+03 -1.7080536e-22 -1.2440986e+03 */
    { 0xa9e16829,0xbeae68e4,0xbeae68e4 }, /* 447: -1.0010076e-13 -3.4064400e-01 -3.4064400e-01 */
    { 0xbbee5a7d,0xc2ca5e17,0xc2ca5e17 }, /* 448: -7.2739706e-03 -1.0118377e+02 -1.0118377e+02 */
    { 0x3ffb3ba0,0x3ae1d0bf,0x3ae1d0bf }, /* 449:  1.9627571e+00  1.7228349e-03  1.7228349e-03 */
    { 0xbf233234,0xbeb6d2e3,0xbf233234 }, /* 450: -6.3748479e-01 -3.5707769e-01 -6.3748479e-01 */
    { 0x9c095bac,0xbd694379,0xbd694379 }, /* 451: -4.5447981e-22 -5.6949113e-02 -5.6949113e-02 */
    { 0x4297f6b8,0xb88ff947,0xb88ff947 }, /* 452:  7.5981873e+01 -6.8652029e-05 -6.8652029e-05 */
    { 0x42c86244,0x423f27f8,0x423f27f8 }, /* 453:  1.0019193e+02  4.7789032e+01  4.7789032e+01 */
    { 0x3eb60922,0x44e54896,0x3eb60922 }, /* 454:  3.5553843e-01  1.8342683e+03  3.5553843e-01 */
    { 0x3d9638ae,0x583af23a,0x3d9638ae }, /* 455:  7.3350295e-02  8.2219807e+14  7.3350295e-02 */
    { 0x3b313151,0x3bc34e46,0x3b313151 }, /* 456:  2.7037452e-03  5.9602587e-03  2.7037452e-03 */
    { 0x3a38ca57,0xeafcc922,0xeafcc922 }, /* 457:  7.0491940e-04 -1.5279956e+26 -1.5279956e+26 */
    { 0xc04fd506,0xbd343a22,0xc04fd506 }, /* 458: -3.2473769e+00 -4.4000752e-02 -3.2473769e+00 */
    { 0x3a264a4c,0xc1193cf2,0xc1193cf2 }, /* 459:  6.3434686e-04 -9.5773792e+00 -9.5773792e+00 */
    { 0xc93b45bb,0x3e2f89df,0xc93b45bb }, /* 460: -7.6706769e+05  1.7142437e-01 -7.6706769e+05 */
    { 0x3cf3c3f3,0xc70e93f8,0xc70e93f8 }, /* 461:  2.9756522e-02 -3.6499969e+04 -3.6499969e+04 */
    { 0x38366b51,0xc4034ed8,0xc4034ed8 }, /* 462:  4.3492128e-05 -5.2523193e+02 -5.2523193e+02 */
    { 0xba8020e1,0x404857f1,0xba8020e1 }, /* 463: -9.7754237e-04  3.1303675e+00 -9.7754237e-04 */
    { 0xc394ab24,0x3d82a6cb,0xc394ab24 }, /* 464: -2.9733704e+02  6.3794695e-02 -2.9733704e+02 */
    { 0x3a0f2f0c,0xc056e862,0xc056e862 }, /* 465:  5.4620276e-04 -3.3579335e+00 -3.3579335e+00 */
    { 0xc0430df8,0xc3a017c1,0xc3a017c1 }, /* 466: -3.0477276e+00 -3.2018558e+02 -3.2018558e+02 */
    { 0x4626e978,0xbf2d989c,0xbf2d989c }, /* 467:  1.0682367e+04 -6.7810988e-01 -6.7810988e-01 */
    { 0xd5ff89d2,0xbea6610f,0xd5ff89d2 }, /* 468: -3.5120925e+13 -3.2495925e-01 -3.5120925e+13 */
    { 0xbebaaeeb,0x2ec6d07d,0xbebaaeeb }, /* 469: -3.6461577e-01  9.0410325e-11 -3.6461577e-01 */
    { 0xc375b9e6,0x383896cf,0xc375b9e6 }, /* 470: -2.4572617e+02  4.4009470e-05 -2.4572617e+02 */
    { 0xc1d53397,0x25c7e128,0xc1d53397 }, /* 471: -2.6650190e+01  3.4673569e-16 -2.6650190e+01 */
    { 0xe17f99ca,0xbc88e7ef,0xe17f99ca }, /* 472: -2.9468759e+20 -1.6712157e-02 -2.9468759e+20 */
    { 0xc06c9854,0xbe938d9c,0xc06c9854 }, /* 473: -3.6967974e+00 -2.8818977e-01 -3.6967974e+00 */
    { 0xcc4abd81,0xc4035fa5,0xcc4abd81 }, /* 474: -5.3147140e+07 -5.2549445e+02 -5.3147140e+07 */
    { 0x3af7d67a,0x427424bf,0x3af7d67a }, /* 475:  1.8908523e-03  6.1035885e+01  1.8908523e-03 */
    { 0x3f800000,0x3cbe4905,0x3cbe4905 }, /* 476:  1.0000000e+00  2.3228178e-02  2.3228178e-02 */
    { 0x3901dd6c,0xb9700341,0xb9700341 }, /* 477:  1.2384885e-04 -2.2889396e-04 -2.2889396e-04 */
    { 0xccd832c0,0x3b0a5114,0xccd832c0 }, /* 478: -1.1335014e+08  2.1105455e-03 -1.1335014e+08 */
    { 0xbc1c369c,0x3accd9e8,0xbc1c369c }, /* 479: -9.5345043e-03  1.5628906e-03 -9.5345043e-03 */
    { 0x426d83e4,0xbd404486,0xbd404486 }, /* 480:  5.9378799e+01 -4.6940349e-02 -4.6940349e-02 */
    { 0xc22cfecd,0x4167d348,0xc22cfecd }, /* 481: -4.3248829e+01  1.4489082e+01 -4.3248829e+01 */
    { 0xc00cbdbf,0xc673e988,0xc673e988 }, /* 482: -2.1990812e+00 -1.5610383e+04 -1.5610383e+04 */
    { 0x9b758e9f,0xc047fcbd,0xc047fcbd }, /* 483: -2.0312008e-22 -3.1248009e+00 -3.1248009e+00 */
    { 0x47e07292,0xbb90f2f4,0xbb90f2f4 }, /* 484:  1.1491714e+05 -4.4234935e-03 -4.4234935e-03 */
    { 0x5395511c,0xb17cfa95,0xb17cfa95 }, /* 485:  1.2826218e+12 -3.6813266e-09 -3.6813266e-09 */
    { 0x3cef0efd,0x32fc7dcc,0x32fc7dcc }, /* 486:  2.9181952e-02  2.9393867e-08  2.9393867e-08 */
    { 0xc233fec1,0xc033267a,0xc233fec1 }, /* 487: -4.4998783e+01 -2.7992234e+00 -4.4998783e+01 */
    { 0x4006fa6f,0x40291931,0x4006fa6f }, /* 488:  2.1090353e+00  2.6421626e+00  2.1090353e+00 */
    { 0xbcd0298f,0xbc5dc8a0,0xbcd0298f }, /* 489: -2.5410442e-02 -1.3536602e-02 -2.5410442e-02 */
    { 0x401c3f57,0xc4466fcb,0xc4466fcb }, /* 490:  2.4413660e+00 -7.9374677e+02 -7.9374677e+02 */
    { 0xc0815925,0xc27c9c04,0xc27c9c04 }, /* 491: -4.0421319e+00 -6.3152359e+01 -6.3152359e+01 */
    { 0xc412bb26,0xc1fa1b5c,0xc412bb26 }, /* 492: -5.8692419e+02 -3.1263359e+01 -5.8692419e+02 */
    { 0xc3aa15b4,0x5082c5fa,0xc3aa15b4 }, /* 493: -3.4016956e+02  1.7552101e+10 -3.4016956e+02 */
    { 0x2a042ace,0x37b6ae77,0x2a042ace }, /* 494:  1.1738806e-13  2.1777332e-05  1.1738806e-13 */
    { 0xbd06a1f7,0xbb461c7b,0xbd06a1f7 }, /* 495: -3.2869305e-02 -3.0229378e-03 -3.2869305e-02 */
    { 0xb9d3ae0d,0x421d738a,0xb9d3ae0d }, /* 496: -4.0374734e-04  3.9362831e+01 -4.0374734e-04 */
    { 0x3d2e9ed6,0x3c3ecb28,0x3c3ecb28 }, /* 497:  4.2631947e-02  1.1645116e-02  1.1645116e-02 */
    { 0xc5c89158,0x400279a2,0xc5c89158 }, /* 498: -6.4181680e+03  2.0386739e+00 -6.4181680e+03 */
    { 0x3ebff735,0xbbcd4770,0xbbcd4770 }, /* 499:  3.7493291e-01 -6.2646195e-03 -6.2646195e-03 */
    { 0x425b4c5a,0x43330344,0x425b4c5a }, /* 500:  5.4824562e+01  1.7901276e+02  5.4824562e+01 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x,y,z;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	y.lo = pgm_read_dword (& t[i].y);
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = fmin (x.fl, y.fl);
	
	if (   v.lo == z.lo
	    || (isnan(v.fl) && isnan(z.fl))	)
	  continue;
	x_exit (i+1);
    }
    return 0;
}
