/* Test of fmod() function.  500 random cases.
   $Id: fmod-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x, y;		/* arguments	*/
    long z;		/* fmod(x,y)	*/
} t[] = {

    /* x, y, fmod(x,y)	*/
    { 0x3f121bbd,0xbe602a03,0x3e081aee }, /*   1:  5.7073575e-01 -2.1891026e-01  1.3291523e-01 */
    { 0x41cc1dbe,0xbd3caec5,0x3d25f473 }, /*   2:  2.5514523e+01 -4.6065111e-02  4.0516328e-02 */
    { 0xc09e49ce,0x3f05cdf4,0xbe784370 }, /*   3: -4.9465094e+00  5.2267385e-01 -2.4244475e-01 */
    { 0xbfd4d3fc,0x3dde0690,0xbd15baa0 }, /*   4: -1.6627192e+00  1.0841095e-01 -3.6554933e-02 */
    { 0xd8fe1f0b,0x41c8bfe0,0xc1986420 }, /*   5: -2.2352743e+15  2.5093689e+01 -1.9048889e+01 */
    { 0xc2362c3d,0xc0c7c4f1,0xbfebfd44 }, /*   6: -4.5543201e+01 -6.2427907e+00 -1.8436666e+00 */
    { 0xbf22d346,0xbc58bd69,0xba8a6e80 }, /*   7: -6.3603628e-01 -1.3228753e-02 -1.0561496e-03 */
    { 0xbf279d43,0x3d635978,0xbd34fc08 }, /*   8: -6.5474337e-01  5.5505246e-02 -4.4185668e-02 */
    { 0xc09ad097,0x3a2d16d3,0xb894f798 }, /*   9: -4.8379626e+00  6.6028273e-04 -7.1033079e-05 */
    { 0x3fd5905a,0xad4a0c92,0x2d3c2b8a }, /*  10:  1.6684678e+00 -1.1485162e-11  1.0696230e-11 */
    { 0x3fd1699c,0xbf3cb83e,0x3e258af0 }, /*  11:  1.6360354e+00 -7.3718631e-01  1.6166282e-01 */
    { 0x3fdd6459,0xbbd4221e,0x3a930ed8 }, /*  12:  1.7296249e+00 -6.4737936e-03  1.1219634e-03 */
    { 0x3e2dc9fe,0x08159f0f,0x0767793c }, /*  13:  1.6971585e-01  4.5025029e-34  1.7414136e-34 */
    { 0xbdd8ca97,0xbc84c5ca,0xbc0d0f40 }, /*  14: -1.0585516e-01 -1.6207594e-02 -8.6095929e-03 */
    { 0x3f4e03bc,0xb989d4b5,0x380c3e38 }, /*  15:  8.0474448e-01 -2.6289155e-04  3.3436547e-05 */
    { 0xbda3300c,0xbd52d7b8,0xbce710c0 }, /*  16: -7.9681486e-02 -5.1475257e-02 -2.8206229e-02 */
    { 0x416c9388,0x40fadfb3,0x40de475d }, /*  17:  1.4786018e+01  7.8398070e+00  6.9462113e+00 */
    { 0xbf5303bd,0xbdc97c24,0xbd187990 }, /*  18: -8.2427579e-01 -9.8381311e-02 -3.7225306e-02 */
    { 0x44be4583,0xa8e7dbbd,0x2895b92c }, /*  19:  1.5221722e+03 -2.5741448e-14  1.6622629e-14 */
    { 0xc1558c1a,0x3f0b2184,0xbe9b3a80 }, /*  20: -1.3346704e+01  5.4348016e-01 -3.0318069e-01 */
    { 0x4093961a,0x3fcb1416,0x3fb8303c }, /*  21:  4.6120729e+00  1.5865505e+00  1.4389720e+00 */
    { 0xc8705ec0,0x41bf43ab,0xc0b6f90c }, /*  22: -2.4613900e+05  2.3908041e+01 -5.7179012e+00 */
    { 0x3946ce1a,0xb4c59e96,0x32e2c3e0 }, /*  23:  1.8959530e-04 -3.6809496e-07  2.6398936e-08 */
    { 0xbfbc45c2,0xbe5475a5,0xbc97b468 }, /*  24: -1.4708788e+00 -2.0748003e-01 -1.8518642e-02 */
    { 0xbcf0bcfc,0x38a31bce,0xb88909a2 }, /*  25: -2.9386990e-02  7.7776247e-05 -6.5344633e-05 */
    { 0xbda4c4d6,0xbd24a2b8,0xb8887800 }, /*  26: -8.0453560e-02 -4.0194243e-02 -6.5073371e-05 */
    { 0xbfb65187,0x3ef5b706,0xbeedd810 }, /*  27: -1.4243630e+00  4.7991198e-01 -4.6453905e-01 */
    { 0x421af559,0xbf0b5a9d,0x3db9a5a8 }, /*  28:  3.8739597e+01 -5.4435140e-01  9.0647995e-02 */
    { 0xc182ed3a,0xbfb5f01e,0xbf3b04ac }, /*  29: -1.6365833e+01 -1.4213903e+00 -7.3054004e-01 */
    { 0xbd5b5aa7,0x352de54b,0xb51d2e27 }, /*  30: -5.3553250e-02  6.4781187e-07 -5.8554218e-07 */
    { 0xc6f3223f,0x41095eb5,0xc0da8b70 }, /*  31: -3.1121123e+04  8.5856218e+00 -6.8295212e+00 */
    { 0xbf0c2cf1,0xbdc449bc,0xbd8bf6dc }, /*  32: -5.4756075e-01 -9.5843762e-02 -6.8341941e-02 */
    { 0xc1cfd309,0xc0f3f1ec,0xc046ecc0 }, /*  33: -2.5978045e+01 -7.6232815e+00 -3.1082001e+00 */
    { 0xc1267339,0x36963c59,0xb5fb921c }, /*  34: -1.0403131e+01  4.4773737e-06 -1.8743481e-06 */
    { 0x43a7e315,0x3f10fba1,0x3f0045b0 }, /*  35:  3.3577408e+02  5.6633955e-01  5.0106335e-01 */
    { 0xbf25eec7,0x3b077ee2,0xba89495c }, /*  36: -6.4817470e-01  2.0674993e-03 -1.0474133e-03 */
    { 0x41b791d9,0xbfcd6af6,0x3ef51070 }, /*  37:  2.2946215e+01 -1.6048267e+00  4.7864103e-01 */
    { 0xbf3d2e76,0xbe5bae53,0xbdc35dbe }, /*  38: -7.3899019e-01 -2.1453218e-01 -9.5393643e-02 */
    { 0x57222944,0x41fb84fc,0x41cb5cd0 }, /*  39:  1.7829812e+14  3.1439934e+01  2.5420319e+01 */
    { 0xc1b012e9,0x3fe834c4,0xbe75ab00 }, /*  40: -2.2009233e+01  1.8141103e+00 -2.3991013e-01 */
    { 0x4441eef0,0xbfeaa80d,0x3e88ca14 }, /*  41:  7.7573340e+02 -1.8332535e+00  2.6716673e-01 */
    { 0xc12f43ba,0x40c5ffe4,0xc0988790 }, /*  42: -1.0954035e+01  6.1874866e+00 -4.7665482e+00 */
    { 0x3f28f7cf,0x3f276eae,0x3bc49080 }, /*  43:  6.6003126e-01  6.5403259e-01  5.9986711e-03 */
    { 0x67c04928,0xbe549dce,0x3dd337cc }, /*  44:  1.8160877e+24 -2.0763323e-01  1.0313377e-01 */
    { 0xc340f9d6,0xbfe91c28,0xbfe05e98 }, /*  45: -1.9297592e+02 -1.8211718e+00 -1.7528868e+00 */
    { 0x49ee85ca,0x40b8d8dd,0x40910f08 }, /*  46:  1.9539772e+06  5.7764726e+00  4.5330849e+00 */
    { 0xc32b2d6e,0xc093192c,0xbf8c2990 }, /*  47: -1.7117746e+02 -4.5968227e+00 -1.0950184e+00 */
    { 0xc7a5920b,0xbdf1400e,0xbda984be }, /*  48: -8.4772086e+04 -1.1779796e-01 -8.2772717e-02 */
    { 0x3ff852dc,0x3d18bdc8,0x3a73b800 }, /*  49:  1.9400287e+00  3.7290365e-02  9.2971325e-04 */
    { 0x3b0a327c,0x38fbb571,0x388f42ff }, /*  50:  2.1087220e-03  1.2002409e-04  6.8312504e-05 */
    { 0x40f6158f,0x3b5cfca6,0x3b025190 }, /*  51:  7.6901317e+00  3.3719926e-03  1.9885041e-03 */
    { 0x3fcf46d6,0xbc2fa530,0x3a0fbb00 }, /*  52:  1.6193492e+00 -1.0720536e-02  5.4828823e-04 */
    { 0xc0cfa00b,0x3e91fe92,0xbe5c4048 }, /*  53: -6.4882865e+00  2.8514534e-01 -2.1508896e-01 */
    { 0xc19add8f,0x3fc232bd,0xbf937814 }, /*  54: -1.9358183e+01  1.5171734e+00 -1.1521020e+00 */
    { 0xbf39ee75,0x310a97ff,0xb0c03a1e }, /*  55: -7.2629482e-01  2.0168043e-09 -1.3986357e-09 */
    { 0x3f158f83,0xbeaf68a9,0x3e776cba }, /*  56:  5.8422107e-01 -3.4259537e-01  2.4162570e-01 */
    { 0x3eecb52d,0xbe4def78,0x3d762da8 }, /*  57:  4.6231976e-01 -2.0110881e-01  6.0102135e-02 */
    { 0xbcfd986d,0x372e0fdb,0xb708a723 }, /*  58: -3.0956471e-02  1.0374900e-05 -8.1451462e-06 */
    { 0x49b6ea65,0x3efaacdc,0x3e088320 }, /*  59:  1.4984446e+06  4.8960006e-01  1.3331270e-01 */
    { 0x3e54696f,0x3b8036f2,0x3866e300 }, /*  60:  2.0743345e-01  3.9128000e-03  5.5047683e-05 */
    { 0x4a618aaa,0xb8192bc8,0x37978520 }, /*  61:  3.6952745e+06 -3.6518817e-05  1.8062594e-05 */
    { 0x3f16804e,0x3dff9785,0x3db5a45c }, /*  62:  5.8789527e-01  1.2480072e-01  8.8692397e-02 */
    { 0x41a931c3,0xc0e7d6ef,0x40d5192e }, /*  63:  2.1149298e+01 -7.2449870e+00  6.6593237e+00 */
    { 0x4430bfa7,0x3f0c4feb,0x3f0035bd }, /*  64:  7.0699457e+02  5.4809445e-01  5.0081998e-01 */
    { 0x3a975fcd,0xb8d597ba,0x3810efa4 }, /*  65:  1.1548937e-03 -1.0184893e-04  3.4555458e-05 */
    { 0x42ef1f01,0x37cae19e,0x37c34492 }, /*  66:  1.1956055e+02  2.4185338e-05  2.3277742e-05 */
    { 0xbf9c9d81,0xbf09569f,0xbe1a3710 }, /*  67: -1.2235566e+00 -5.3647798e-01 -1.5060067e-01 */
    { 0x41788778,0xc0a80cb5,0x40a0f586 }, /*  68:  1.5533073e+01 -5.2515512e+00  5.0299711e+00 */
    { 0x47d34e44,0x3ef8cabd,0x3ef5175f }, /*  69:  1.0818853e+05  4.8592177e-01  4.7869393e-01 */
    { 0x3e775824,0xa9a78f02,0x2992ae02 }, /*  70:  2.4154717e-01 -7.4410977e-14  6.5138880e-14 */
    { 0xc21edbe2,0x3fc043ee,0xbf292c28 }, /*  71: -3.9714729e+01  1.5020730e+00 -6.6083002e-01 */
    { 0x4195ac16,0x3fb82265,0x3c011f80 }, /*  72:  1.8709026e+01  1.4385496e+00  7.8810453e-03 */
    { 0x400710cc,0x3f1e4588,0x3e82e530 }, /*  73:  2.1104002e+00  6.1824846e-01  2.5565481e-01 */
    { 0x3f1b5b0b,0xbcceb6f1,0x3aa3ac80 }, /*  74:  6.0685796e-01 -2.5233718e-02  1.2487322e-03 */
    { 0x3fd53aa1,0x3eef61da,0x3e86c4f6 }, /*  75:  1.6658517e+00  4.6754342e-01  2.6322144e-01 */
    { 0x3f1ac8da,0xbf111c39,0x3d1aca10 }, /*  76:  6.0462725e-01 -5.6683689e-01  3.7790358e-02 */
    { 0x41c346ae,0x3f277078,0x3e5651a0 }, /*  77:  2.4409512e+01  6.5405989e-01  2.0929575e-01 */
    { 0x4190291f,0x40c50d89,0x40b6896a }, /*  78:  1.8020079e+01  6.1579022e+00  5.7042742e+00 */
    { 0xc006db37,0x3f1d1b3a,0xbe88365c }, /*  79: -2.1071298e+00  6.1369669e-01 -2.6603973e-01 */
    { 0x3f44eb4e,0x3dc7be93,0x3db1246b }, /*  80:  7.6921546e-01  9.7531460e-02  8.6495243e-02 */
    { 0xc0c2be7e,0xbf113c64,0xbed33010 }, /*  81: -6.0857534e+00 -5.6732774e-01 -4.1247606e-01 */
    { 0xc0014cba,0x3d75c710,0xbd248570 }, /*  82: -2.0203080e+00  6.0004294e-02 -4.0166318e-02 */
    { 0xc13640eb,0xbffe30e3,0xbfbb12e9 }, /*  83: -1.1390849e+01 -1.9858669e+00 -1.4615146e+00 */
    { 0x40e5dbd1,0xc0743189,0x40578619 }, /*  84:  7.1830831e+00 -3.8155234e+00  3.3675597e+00 */
    { 0x3fe3e016,0xbe361e9b,0x3ae75100 }, /*  85:  1.7802761e+00 -1.7785113e-01  1.7648041e-03 */
    { 0xbfe57dcd,0x3ce3acea,0xbc687180 }, /*  86: -1.7929016e+00  2.7792413e-02 -1.4187217e-02 */
    { 0xc12247a5,0x3e08f6ce,0xbde335cc }, /*  87: -1.0142491e+01  1.3375399e-01 -1.1094245e-01 */
    { 0xbe3ae7f9,0xbb920bf5,0xbb8b20d8 }, /*  88: -1.8252553e-01 -4.4569918e-03 -4.2458586e-03 */
    { 0xc299c267,0xbdd041af,0xbb746680 }, /*  89: -7.6879692e+01 -1.0168778e-01 -3.7292540e-03 */
    { 0xbd62fd07,0x3942bf85,0xb8942c5c }, /*  90: -5.5417087e-02  1.8572628e-04 -7.0654525e-05 */
    { 0x4a8073db,0x3dc72e1d,0x3d63eeb4 }, /*  91:  4.2091335e+06  9.7255923e-02  5.5647567e-02 */
    { 0xc08639a9,0x39ffc0e5,0xb9b1b4d2 }, /*  92: -4.1945386e+00  4.8781108e-04 -3.3894792e-04 */
    { 0x3fcfc3ef,0xbcf90092,0x3c47bb0c }, /*  93:  1.6231669e+00 -3.0395780e-02  1.2190592e-02 */
    { 0xc088bd27,0x3ff4a469,0xbee6af28 }, /*  94: -4.2730899e+00  1.9112674e+00 -4.5055509e-01 */
    { 0x3ffd2161,0x3fcedb13,0x3eb91938 }, /*  95:  1.9775811e+00  1.6160606e+00  3.6152053e-01 */
    { 0x44022ad5,0x3d385bca,0x39c41000 }, /*  96:  5.2066925e+02  4.5009412e-02  3.7395954e-04 */
    { 0x3fe6f5e3,0xbde828c3,0x3dd4fac3 }, /*  97:  1.8043789e+00 -1.1335900e-01  1.0399392e-01 */
    { 0xc19025ec,0x3fe506de,0xbe00d0a0 }, /*  98: -1.8018517e+01  1.7892721e+00 -1.2579584e-01 */
    { 0xc0e3b295,0xbff2e5f1,0xbfb61881 }, /*  99: -7.1155496e+00 -1.8976423e+00 -1.4226228e+00 */
    { 0xc1384bc9,0x40fadda3,0xc06b73de }, /* 100: -1.1518502e+01  7.8395553e+00 -3.6789470e+00 */
    { 0x44075ae8,0xc38d825e,0x43813372 }, /* 101:  5.4142041e+02 -2.8301849e+02  2.5840192e+02 */
    { 0xbff4863f,0x3f1f299b,0xbd38fad0 }, /* 102: -1.9103469e+00  6.2172860e-01 -4.5161068e-02 */
    { 0x3e61c8bc,0xbd21abad,0x3cbd911e }, /* 103:  2.2049230e-01 -3.9470363e-02  2.3140486e-02 */
    { 0x3ff08494,0x3df13bcf,0x3de5c81f }, /* 104:  1.8790460e+00  1.1778986e-01  1.1219811e-01 */
    { 0x3f78994c,0xbb4dd2a3,0x3a283504 }, /* 105:  9.7108912e-01 -3.1406067e-03  6.4165913e-04 */
    { 0x64c835dd,0xbfd06b6c,0x3e9ea9f0 }, /* 106:  2.9545841e+22 -1.6282783e+00  3.0989027e-01 */
    { 0xc0b78ce8,0x3fddc5b3,0xbf09c50e }, /* 107: -5.7359505e+00  1.7325958e+00 -5.3816307e-01 */
    { 0xc2a16fd3,0xbe737ac6,0xbde8239c }, /* 108: -8.0718407e+01 -2.3777303e-01 -1.1334917e-01 */
    { 0x40027b79,0xbddf31c1,0x3d9def8e }, /* 109:  2.0387862e+00 -1.0898162e-01  7.7117071e-02 */
    { 0xbfa85bbb,0xbdd15422,0xbdb5ca18 }, /* 110: -1.3152994e+00 -1.0221125e-01 -8.8764369e-02 */
    { 0x3ff19483,0x3cf98b2c,0x3ceef744 }, /* 111:  1.8873447e+00  3.0461870e-02  2.9170640e-02 */
    { 0xbfe2a473,0x3fdad60f,0xbd79cc80 }, /* 112: -1.7706436e+00  1.7096575e+00 -6.0986042e-02 */
    { 0x4121c613,0x406dfe6b,0x402b1b76 }, /* 113:  1.0110858e+01  3.7186534e+00  2.6735511e+00 */
    { 0x41de7694,0x3e2f0ffd,0x3de657cc }, /* 114:  2.7807899e+01  1.7095943e-01  1.1247215e-01 */
    { 0x3ff0a2e4,0x3f3a302d,0x3ed9cadc }, /* 115:  1.8799710e+00  7.2729760e-01  4.2537582e-01 */
    { 0x59ba30b1,0x3ceda091,0x3ca725c7 }, /* 116:  6.5509853e+15  2.9007228e-02  2.0403756e-02 */
    { 0x3dcda3e7,0xa458c0dc,0x22a73b20 }, /* 117:  1.0041028e-01 -4.7000892e-17  4.5328042e-18 */
    { 0xc18c9429,0xbdf7f4a2,0xbc8a64f8 }, /* 118: -1.7572344e+01 -1.2107207e-01 -1.6893849e-02 */
    { 0x40aadacb,0x3a319a29,0x3a0821f8 }, /* 119:  5.3392081e+00  6.7749858e-04  5.1930500e-04 */
    { 0xc6503685,0x390d392d,0xb73710d0 }, /* 120: -1.3325630e+04  1.3468107e-04 -1.0911564e-05 */
    { 0x3d2c68fb,0xb0399aeb,0x301891f6 }, /* 121:  4.2092305e-02 -6.7522760e-10  5.5504701e-10 */
    { 0xbfeee8d8,0xbda047ac,0xbd881d0c }, /* 122: -1.8664808e+00 -7.8261703e-02 -6.6461653e-02 */
    { 0x3fc1eca0,0x34482799,0x33fae8ce }, /* 123:  1.5150337e+00  1.8640857e-07  1.1683879e-07 */
    { 0xbff6dae2,0xbf58516b,0xbe744bb8 }, /* 124: -1.9285548e+00 -8.4499234e-01 -2.3857009e-01 */
    { 0x468a37a7,0x3bff9520,0x3bc6e880 }, /* 125:  1.7691826e+04  7.7997595e-03  6.0701966e-03 */
    { 0x430a8583,0x414d0bc3,0x4125e292 }, /* 126:  1.3852153e+02  1.2815372e+01  1.0367815e+01 */
    { 0x410b86f4,0x3b2e50b3,0x3ac3d7ec }, /* 127:  8.7204475e+00  2.6598393e-03  1.4941669e-03 */
    { 0xc544009b,0x3dfbe3a0,0xbdbb9560 }, /* 128: -3.1360378e+03  1.2299275e-01 -9.1593504e-02 */
    { 0xc3f19c06,0xbe4030f3,0xbde8096c }, /* 129: -4.8321893e+02 -1.8768673e-01 -1.1329922e-01 */
    { 0xbf389c95,0xb984a2d4,0xb90fd7b0 }, /* 130: -7.2113925e-01 -2.5298318e-04 -1.3717893e-04 */
    { 0xc0abe465,0xbf3115fb,0xbf07894b }, /* 131: -5.3716302e+00 -6.9174165e-01 -5.2943867e-01 */
    { 0x3f4bf1c8,0xbd901dfa,0x3cb91208 }, /* 132:  7.9665804e-01 -7.0369676e-02  2.2591606e-02 */
    { 0x4208c25e,0xbfd23ac4,0x3fabb470 }, /* 133:  3.4189812e+01 -1.6424184e+00  1.3414440e+00 */
    { 0xc689ad34,0xbff4b72f,0xbf95acd1 }, /* 134: -1.7622602e+04 -1.9118403e+00 -1.1693364e+00 */
    { 0x43ee47ab,0xbf22d7e8,0x3ded21c0 }, /* 135:  4.7655991e+02 -6.3610697e-01  1.1578703e-01 */
    { 0xc27306a6,0xc00cda11,0xbfaad52a }, /* 136: -6.0756493e+01 -2.2008097e+00 -1.3346303e+00 */
    { 0xcd15e01f,0xbf13d66c,0xbea04088 }, /* 137: -1.5715582e+08 -5.7749057e-01 -3.1299233e-01 */
    { 0xc11fd65a,0x38d68689,0xb7f7f6d8 }, /* 138: -9.9898319e+00  1.0229374e-04 -2.9559640e-05 */
    { 0xc2f0cf31,0x42b7c13c,0xc1e437d4 }, /* 139: -1.2040467e+02  9.1877411e+01 -2.8527260e+01 */
    { 0xc36c5061,0x3e68d81f,0xbd7178bc }, /* 140: -2.3631398e+02  2.2738694e-01 -5.8953032e-02 */
    { 0xbfe5caf4,0xbf26d78f,0xbefbcd94 }, /* 141: -1.7952561e+00 -6.5172666e-01 -4.9180281e-01 */
    { 0xc44c25b9,0x3d1aa6f8,0xbcad4db0 }, /* 142: -8.1658942e+02  3.7756890e-02 -2.1155208e-02 */
    { 0xbfbb733b,0xbf35fd3d,0xbd2ebfc0 }, /* 143: -1.4644541e+00 -7.1089536e-01 -4.2663336e-02 */
    { 0x3dbefe5d,0xbbc66515,0x3b1ff32a }, /* 144:  9.3258597e-02 -6.0545304e-03  2.4406412e-03 */
    { 0x3fd6dc07,0xbfd51922,0x3c617280 }, /* 145:  1.6785897e+00 -1.6648295e+00  1.3760209e-02 */
    { 0x585fd24f,0x411ea4d0,0x3e09f000 }, /* 146:  9.8437745e+14  9.9152374e+00  1.3470459e-01 */
    { 0xc14ca4e6,0x3f4bf63c,0xbd2eaa00 }, /* 147: -1.2790258e+01  7.9672599e-01 -4.2642593e-02 */
    { 0xbfd2ca0f,0x3f96a895,0xbef085e8 }, /* 148: -1.6467913e+00  1.1770197e+00 -4.6977162e-01 */
    { 0xbfc13d24,0xbeeed355,0xbde1ea44 }, /* 149: -1.5096784e+00 -4.6645609e-01 -1.1031011e-01 */
    { 0x58edd2d1,0x3d4836ba,0x3c681d38 }, /* 150:  2.0919176e+15  4.8880316e-02  1.4167123e-02 */
    { 0xc955dd17,0xaa7f69bc,0xaa135c28 }, /* 151: -8.7598544e+05 -2.2685234e-13 -1.3088196e-13 */
    { 0x43dbddb1,0x40c46b70,0x407b4060 }, /* 152:  4.3973196e+02  6.1381149e+00  3.9258041e+00 */
    { 0xc1b6f125,0x3c3716c9,0xbb821b24 }, /* 153: -2.2867746e+01  1.1174866e-02 -3.9705206e-03 */
    { 0x43122972,0x41a1d065,0x40926334 }, /* 154:  1.4616190e+02  2.0226755e+01  4.5746098e+00 */
    { 0x41977b66,0x407b6a42,0x404e3228 }, /* 155:  1.8935253e+01  3.9283605e+00  3.2218113e+00 */
    { 0xbf146e3a,0xbb755acf,0xbb55997a }, /* 156: -5.7980692e-01 -3.7438159e-03 -3.2592700e-03 */
    { 0xc2197455,0xbf1f8918,0xbeb2d510 }, /* 157: -3.8363605e+01 -6.2318563e-01 -3.4928179e-01 */
    { 0xc3a622db,0x3bf0f455,0xbb847cd6 }, /* 158: -3.3227231e+02  7.3533454e-03 -4.0432019e-03 */
    { 0xc41e8f41,0xbf1d7c92,0xbf19d094 }, /* 159: -6.3423834e+02 -6.1518204e-01 -6.0083890e-01 */
    { 0xc181a72b,0xbb00bb8f,0xba920334 }, /* 160: -1.6206625e+01 -1.9643044e-03 -1.1139871e-03 */
    { 0xc0f1853b,0xbd6f419c,0xbc4a3790 }, /* 161: -7.5475135e+00 -5.8412179e-02 -1.2342349e-02 */
    { 0xcb6ea1c4,0xbd9a279c,0xbcbf0390 }, /* 162: -1.5638980e+07 -7.5270861e-02 -2.3317128e-02 */
    { 0x73668a55,0x3ff49a22,0x3fa2a122 }, /* 163:  1.8265289e+31  1.9109538e+00  1.2705424e+00 */
    { 0xc22bcab4,0xb3abdc53,0xb2ca4b40 }, /* 164: -4.2947952e+01 -8.0028848e-08 -2.3550115e-08 */
    { 0x40ad9f54,0xbe8fdd73,0x3db216dc }, /* 165:  5.4256992e+00 -2.8098640e-01  8.6957663e-02 */
    { 0x425466dd,0xc1f136a1,0x41b79719 }, /* 166:  5.3100452e+01 -3.0151674e+01  2.2948778e+01 */
    { 0xbfd59655,0x3d2bd46a,0xbd056e7a }, /* 167: -1.6686503e+00  4.1950621e-02 -3.2576062e-02 */
    { 0xc7b158bc,0x3a50642a,0xb9a72a68 }, /* 168: -9.0801469e+04  7.9494959e-04 -3.1884317e-04 */
    { 0x4fa65978,0x3dcb65e5,0x3d8c0374 }, /* 169:  5.5817626e+09  9.9315442e-02  6.8365961e-02 */
    { 0xc377d76c,0x3be5da80,0xbb2b2c00 }, /* 170: -2.4784149e+02  7.0145726e-03 -2.6118755e-03 */
    { 0xc1482822,0xbfd252e5,0xbf80fccd }, /* 171: -1.2509798e+01 -1.6431547e+00 -1.0077149e+00 */
    { 0x40e6adfc,0xbdff25a1,0x3ddc1e27 }, /* 172:  7.2087383e+00 -1.2458349e-01  1.0747939e-01 */
    { 0xc1e07c1f,0x40ebf639,0xc0be0dd1 }, /* 173: -2.8060606e+01  7.3738065e+00 -5.9391866e+00 */
    { 0xc10ada6a,0xbdc0ad78,0xbcbb7780 }, /* 174: -8.6783237e+00 -9.4080865e-02 -2.2884130e-02 */
    { 0x413a966e,0x3f0eac92,0x3f03eb78 }, /* 175:  1.1661726e+01  5.5732071e-01  5.1531172e-01 */
    { 0x42efff8d,0x3f423599,0x3e0ac848 }, /* 176:  1.1999912e+02  7.5863034e-01  1.3552964e-01 */
    { 0xbfe0de7a,0xbf316c55,0xbebdc894 }, /* 177: -1.7567894e+00 -6.9305927e-01 -3.7067091e-01 */
    { 0xbf244d25,0xbd112d4c,0xbb7a2f80 }, /* 178: -6.4180213e-01 -3.5443589e-02 -3.8175285e-03 */
    { 0x496616f2,0x3fbb0939,0x3eb4ceec }, /* 179:  9.4244712e+05  1.4612190e+00  3.5314119e-01 */
    { 0x3fe4db61,0x3ce804e8,0x3b6d1940 }, /* 180:  1.7879449e+00  2.8322652e-02  3.6178380e-03 */
    { 0xc3e2a350,0xbd974410,0xbd8da080 }, /* 181: -4.5327588e+02 -7.3860288e-02 -6.9153786e-02 */
    { 0x4681cd4c,0xbff64728,0x3f01bb90 }, /* 182:  1.6614648e+04 -1.9240465e+00  5.0676823e-01 */
    { 0xbe643b2a,0xba851734,0xba057708 }, /* 183: -2.2288194e-01 -1.0154010e-03 -5.0912844e-04 */
    { 0xc1bc8de6,0xc0ceb10b,0xc0862477 }, /* 184: -2.3569286e+01 -6.4591117e+00 -4.1919513e+00 */
    { 0x3f0cb344,0xb9ee3171,0x39b2a157 }, /* 185:  5.4961038e-01 -4.5431734e-04  3.4071013e-04 */
    { 0xbfdbac54,0xbe0ada1c,0xbdb652a0 }, /* 186: -1.7161965e+00 -1.3559765e-01 -8.9024782e-02 */
    { 0x4afd7338,0xbf99f55d,0x3eb2d844 }, /* 187:  8.3050520e+06 -1.2028004e+00  3.4930623e-01 */
    { 0x3f0fea10,0xbf09b98f,0x3cc61020 }, /* 188:  5.6216526e-01 -5.3798765e-01  2.4177611e-02 */
    { 0xc29efcaa,0xbf121351,0xbe376014 }, /* 189: -7.9493484e+01 -5.7060724e-01 -1.7907745e-01 */
    { 0xcf8400f0,0xbcb6b503,0xb8181c00 }, /* 190: -4.4293079e+09 -2.2303110e-02 -3.6265701e-05 */
    { 0xc3401bb7,0xbfe3bee4,0xbfdd1234 }, /* 191: -1.9210826e+02 -1.7792630e+00 -1.7271180e+00 */
    { 0x423a2a6f,0xbf21949b,0x3eee771a }, /* 192:  4.6541439e+01 -6.3117379e-01  4.6575242e-01 */
    { 0xc795f03c,0x3ff91f45,0xbfef2be1 }, /* 193: -7.6768469e+04  1.9462668e+00 -1.8685266e+00 */
    { 0xbf479377,0xbd125972,0xbcefc22c }, /* 194: -7.7959388e-01 -3.5729833e-02 -2.9267393e-02 */
    { 0x4170d466,0x3f13e8c1,0x3cf458c0 }, /* 195:  1.5051855e+01  5.7777029e-01  2.9827476e-02 */
    { 0xd0a9bcda,0x389f9c15,0xb7f9edec }, /* 196: -2.2781809e+10  7.6107834e-05 -2.9793904e-05 */
    { 0x3f033f51,0xbe913ce6,0x3e6a8378 }, /* 197:  5.1268488e-01 -2.8366774e-01  2.2901714e-01 */
    { 0x40b5a93d,0x3b58f1f1,0x3b46086e }, /* 198:  5.6769090e+00  3.3103193e-03  3.0217427e-03 */
    { 0x45bc42a1,0xbe41acc4,0x3e2e5a14 }, /* 199:  6.0243286e+03 -1.8913561e-01  1.7026550e-01 */
    { 0x40d31fd3,0xbf9fd286,0x3eb58ab8 }, /* 200:  6.5976348e+00 -1.2486122e+00  3.5457397e-01 */
    { 0xc0726140,0x3fa4e813,0xbf9af25a }, /* 201: -3.7871857e+00  1.2883323e+00 -1.2105210e+00 */
    { 0x3cd5577c,0x3a013427,0x39d8af28 }, /* 202:  2.6042692e-02  4.9287308e-04  4.1329232e-04 */
    { 0xbfd2907f,0xbd5b1eb3,0xbd2476e6 }, /* 203: -1.6450347e+00 -5.3496074e-02 -4.0152453e-02 */
    { 0xc13f2b13,0x3fdf120a,0xbfbeec5c }, /* 204: -1.1948016e+01  1.7427380e+00 -1.4915881e+00 */
    { 0xc1cb0cd6,0x40b87c67,0xc0148378 }, /* 205: -2.5381268e+01  5.7651858e+00 -2.3205242e+00 */
    { 0x43317186,0x40a94dce,0x40365264 }, /* 206:  1.7744345e+02  5.2907476e+00  2.8487787e+00 */
    { 0x3d37280d,0x3d275e6b,0x3b7c9a20 }, /* 207:  4.4715930e-02  4.0861528e-02  3.8544014e-03 */
    { 0xc2e708f5,0x3bf88996,0xbacfd8b0 }, /* 208: -1.1551749e+02  7.5847609e-03 -1.5857425e-03 */
    { 0x40aa1213,0x348cb092,0x3357ce20 }, /* 209:  5.3147063e+00  2.6205504e-07  5.0246058e-08 */
    { 0xbf2fd349,0x3e3a232e,0xbe10e39a }, /* 210: -6.8681771e-01  1.8177482e-01 -1.4149323e-01 */
    { 0xcc29266f,0x41d7ee1c,0xc1313a00 }, /* 211: -4.4341692e+07  2.6991264e+01 -1.1076660e+01 */
    { 0x4251f5c2,0x301411e1,0x2f54e59c }, /* 212:  5.2489998e+01  5.3867494e-10  1.9362861e-10 */
    { 0x3fb21ac1,0x3f03537f,0x3ebb1d08 }, /* 213:  1.3914415e+00  5.1299280e-01  3.6545587e-01 */
    { 0xd0c8eacb,0x3faa29c3,0xbf0e1cd4 }, /* 214: -2.6966645e+10  1.3293995e+00 -5.5512738e-01 */
    { 0x41faeb6a,0x3e84b733,0x3a06ca00 }, /* 215:  3.1364948e+01  2.5921020e-01  5.1417947e-04 */
    { 0x3fec798f,0xbbfe2f23,0x3aa6f1d8 }, /* 216:  1.8474597e+00 -7.7570840e-03  1.2736870e-03 */
    { 0x42b293c8,0xc1140785,0x40c0b526 }, /* 217:  8.9288635e+01 -9.2518358e+00  6.0221128e+00 */
    { 0x44ca29d5,0x3c8c2d63,0x3c78848e }, /* 218:  1.6173073e+03  1.7111486e-02  1.5168322e-02 */
    { 0x40b71497,0xbf44b1cd,0x3eaf903a }, /* 219:  5.7212634e+00 -7.6833802e-01  3.4289724e-01 */
    { 0xc1708ab9,0x3efbb502,0xbe9220e4 }, /* 220: -1.5033868e+01  4.9161536e-01 -2.8540719e-01 */
    { 0x421dcb7f,0xc0c80f68,0x3ff7fe20 }, /* 221:  3.9448727e+01 -6.2518806e+00  1.9374428e+00 */
    { 0xc7b3aeb5,0xbe864639,0xbddaa618 }, /* 222: -9.1997414e+04 -2.6225451e-01 -1.0676211e-01 */
    { 0x41da233b,0x409d75d7,0x402a7f72 }, /* 223:  2.7267202e+01  4.9206347e+00  2.6640286e+00 */
    { 0xc15ad0fa,0xc0c6fca8,0xbf9ea290 }, /* 224: -1.3676020e+01 -6.2183418e+00 -1.2393360e+00 */
    { 0x418055c6,0xbfef1003,0x3f8cdc48 }, /* 225:  1.6041882e+01 -1.8676761e+00  1.1004725e+00 */
    { 0xc01e0299,0xbf1cc39a,0xbc9f7f80 }, /* 226: -2.4689085e+00 -6.1235964e-01 -1.9469976e-02 */
    { 0xc117ed5f,0x3578c51b,0xb55f132c }, /* 227: -9.4954519e+00  9.2674026e-07 -8.3101872e-07 */
    { 0x408cb1c9,0x3e4c1870,0x3c41f800 }, /* 228:  4.3967023e+00  1.9931197e-01  1.1838913e-02 */
    { 0x3fe796c7,0x3ddd6902,0x3da2dc50 }, /* 229:  1.8092889e+00  1.0811044e-01  7.9521775e-02 */
    { 0xc228972e,0x41f4b424,0xc138f470 }, /* 230: -4.2147636e+01  3.0587959e+01 -1.1559677e+01 */
    { 0x3f5d208b,0xbe12317a,0x3beb2a00 }, /* 231:  8.6377782e-01 -1.4276686e-01  7.1766376e-03 */
    { 0x40082a87,0x3d9c1136,0x3d8f802e }, /* 232:  2.1275957e+00  7.6204702e-02  7.0068702e-02 */
    { 0xca338a7a,0xbdfbd3a0,0xbdbec620 }, /* 233: -2.9415985e+06 -1.2296224e-01 -9.3151331e-02 */
    { 0xc0bc856f,0x3ff25e2a,0xbe57d9f0 }, /* 234: -5.8912883e+00  1.8934987e+00 -2.1079230e-01 */
    { 0xd3cec742,0xd045586a,0xcebacc20 }, /* 235: -1.7762125e+12 -1.3243623e+10 -1.5669699e+09 */
    { 0xc126d8b0,0xbd363d1b,0xbc89aaa4 }, /* 236: -1.0427902e+01 -4.4491868e-02 -1.6805001e-02 */
    { 0xc3443fab,0x3c3e4dc4,0xbc1c85c4 }, /* 237: -1.9624870e+02  1.1615220e-02 -9.5533766e-03 */
    { 0xc0843c86,0x3ff2f20f,0xbeac37e8 }, /* 238: -4.1323881e+00  1.8980120e+00 -3.3636403e-01 */
    { 0xd19474ca,0x3e991cab,0xbca1bae0 }, /* 239: -7.9701819e+10  2.9904684e-01 -1.9742429e-02 */
    { 0xc8227b14,0xc00f4355,0xbeeea0e8 }, /* 240: -1.6638031e+05 -2.2384846e+00 -4.6607137e-01 */
    { 0xc4dcaa20,0x3d184997,0xbcfec470 }, /* 241: -1.7653164e+03  3.7179556e-02 -3.1099528e-02 */
    { 0xc1a26a8c,0xbe425c68,0xbe3b02f0 }, /* 242: -2.0302025e+01 -1.8980563e-01 -1.8262839e-01 */
    { 0xbfe811d9,0x33402f3d,0xb1142f20 }, /* 243: -1.8130447e+00  4.4746447e-08 -2.1563622e-09 */
    { 0x556d56da,0x41f0bff3,0x413113e2 }, /* 244:  1.6309830e+13  3.0093725e+01  1.1067354e+01 */
    { 0x3e5b8235,0xbdec1c85,0x3dcae7e5 }, /* 245:  2.1436389e-01 -1.1528877e-01  9.9075116e-02 */
    { 0x4075eff2,0xbf150e59,0x3eb2d364 }, /* 246:  3.8427701e+00 -5.8225018e-01  3.4926903e-01 */
    { 0x3f61456d,0x3e6785db,0x3e4e8423 }, /* 247:  8.7996560e-01  2.2609656e-01  2.0167594e-01 */
    { 0x4491438c,0xbda31e7a,0x3d4025e8 }, /* 248:  1.1621108e+03 -7.9647973e-02  4.6911150e-02 */
    { 0x40cf51ac,0xbf101212,0x3e938d34 }, /* 249:  6.4787197e+00 -5.6277573e-01  2.8818667e-01 */
    { 0xc51e127e,0xbc87fe3b,0xbb48bd00 }, /* 250: -2.5291558e+03 -1.6600719e-02 -3.0630231e-03 */
    { 0xbf48bc61,0x3be7ddc2,0xbbbce724 }, /* 251: -7.8412443e-01  7.0759961e-03 -5.7648588e-03 */
    { 0xcd1f9a53,0xc2f2541a,0xc2d242ee }, /* 252: -1.6735570e+08 -1.2116426e+02 -1.0513072e+02 */
    { 0x41246f20,0xbc517c06,0x3c24792e }, /* 253:  1.0277130e+01 -1.2785917e-02  1.0038657e-02 */
    { 0x3f0fa7a6,0x36e60287,0x35ff4a58 }, /* 254:  5.6115186e-01  6.8548284e-06  1.9020617e-06 */
    { 0xbf4e92d9,0xb2a90fc7,0xb19fcbe0 }, /* 255: -8.0692822e-01 -1.9681364e-08 -4.6506869e-09 */
    { 0x4118142f,0xbfde9c64,0x3f4f2708 }, /* 256:  9.5049276e+00 -1.7391477e+00  8.0918932e-01 */
    { 0x3ff87a86,0xbe3f0ed5,0x3d9a7fbc }, /* 257:  1.9412391e+00 -1.8658002e-01  7.5438946e-02 */
    { 0xbffb2e80,0xbe520da4,0xbdedf278 }, /* 258: -1.9623566e+00 -2.0513016e-01 -1.1618513e-01 */
    { 0x409dbd0f,0xbea8d441,0x3ea03562 }, /* 259:  4.9293284e+00 -3.2974437e-01  3.1290728e-01 */
    { 0xbfc1c2e9,0xbfb533e0,0xbdc8f090 }, /* 260: -1.5137607e+00 -1.4156456e+00 -9.8115087e-02 */
    { 0xc1c68d41,0xb6af46ed,0xb6a7095b }, /* 261: -2.4818972e+01 -5.2236633e-06 -4.9780770e-06 */
    { 0x3e6feaf4,0x3d709eef,0x3d6dcf03 }, /* 262:  2.3429471e-01  5.8745321e-02  5.8058750e-02 */
    { 0xbf2124e3,0x3dd0cf6c,0xbc912a40 }, /* 263: -6.2946910e-01  1.0195813e-01 -1.7720342e-02 */
    { 0x3f19a785,0xbd60fee2,0x3d50837c }, /* 264:  6.0021240e-01 -5.4930575e-02  5.0906643e-02 */
    { 0xbde4c0c9,0x847a7f08,0x841e62e8 }, /* 265: -1.1169583e-01 -2.9445689e-36 -1.8618226e-36 */
    { 0xd8d2c143,0xc0e7c4a6,0xbfa15e60 }, /* 266: -1.8538200e+15 -7.2427549e+00 -1.2606926e+00 */
    { 0xbe4c1d2e,0x17c67e50,0x97754a40 }, /* 267: -1.9933006e-01  1.2827336e-24 -7.9257486e-25 */
    { 0x5002583b,0x3291b195,0x311645a0 }, /* 268:  8.7472814e+09  1.6960977e-08  2.1867450e-09 */
    { 0x410f37f3,0xbd4c0850,0x3d0e2310 }, /* 269:  8.9511595e+00 -4.9812615e-02  3.4701407e-02 */
    { 0xbef399a4,0x3e75f87c,0xbe713acc }, /* 270: -4.7578156e-01  2.4020571e-01 -2.3557585e-01 */
    { 0x462477e0,0xbcdddb2a,0x3c8fbafe }, /* 271:  1.0525969e+04 -2.7082045e-02  1.7545220e-02 */
    { 0xbfebc9f5,0x3e020d6a,0xbd8327b8 }, /* 272: -1.8421007e+00  1.2700430e-01 -6.4040601e-02 */
    { 0x4499616e,0xbefc47e2,0x3e076798 }, /* 273:  1.2270447e+03 -4.9273592e-01  1.3223112e-01 */
    { 0x3dd95e4b,0x398f0322,0x37e88560 }, /* 274:  1.0613688e-01  2.7277420e-04  2.7718663e-05 */
    { 0xc5e457df,0x41076f1d,0xc000acf4 }, /* 275: -7.3069839e+03  8.4646273e+00 -2.0105562e+00 */
    { 0x3fa7b18d,0x3dbdf529,0x3c3d8490 }, /* 276:  1.3101059e+00  9.2752762e-02  1.1567250e-02 */
    { 0x3f480dd8,0x3dc0ed48,0x3ce41200 }, /* 277:  7.8146124e-01  9.4202578e-02  2.7840614e-02 */
    { 0x4e087535,0x448f811a,0x448e47ba }, /* 278:  5.7234566e+08  1.1480344e+03  1.1382415e+03 */
    { 0xc2074c68,0x3cbb868a,0xbc680b9c }, /* 279: -3.3824615e+01  2.2891302e-02 -1.4162924e-02 */
    { 0x3fce78f3,0x3f08d8cd,0x3c19dfc0 }, /* 280:  1.6130661e+00  5.3455812e-01  9.3917251e-03 */
    { 0xbde17f7c,0x3dc9f23f,0xbc3c69e8 }, /* 281: -1.1010644e-01  9.8606579e-02 -1.1499859e-02 */
    { 0xc38c89f8,0xbf200016,0xbee792d4 }, /* 282: -2.8107788e+02 -6.2500131e-01 -4.5229208e-01 */
    { 0xc0a35757,0xbb5683fb,0xbab9f4e6 }, /* 283: -5.1044116e+00 -3.2732475e-03 -1.4187365e-03 */
    { 0xc123fed3,0x38855a95,0xb78a13dc }, /* 284: -1.0249713e+01  6.3588064e-05 -1.6460130e-05 */
    { 0x3fc52028,0x3d0e4f0f,0x3c39b9b0 }, /* 285:  1.5400438e+00  3.4743365e-02  1.1335775e-02 */
    { 0xc39be297,0x3e3c1020,0xbddba7c0 }, /* 286: -3.1177023e+02  1.8365526e-01 -1.0725355e-01 */
    { 0xc26083aa,0xb4baccb0,0xb42dd7c0 }, /* 287: -5.6128578e+01 -3.4794130e-07 -1.6190370e-07 */
    { 0x4440cd1b,0xbfebd9f3,0x3f80573a }, /* 288:  7.7120477e+02 -1.8425888e+00  1.0026619e+00 */
    { 0x407be3de,0xbc81f248,0x3af39400 }, /* 289:  3.9357829e+00 -1.5862599e-02  1.8583536e-03 */
    { 0xbfeeb458,0x3e51d7b5,0xbca86b18 }, /* 290: -1.8648787e+00  2.0492442e-01 -2.0558879e-02 */
    { 0xcdf6275f,0xc1a5e23b,0xc188dd44 }, /* 291: -5.1622192e+08 -2.0735464e+01 -1.7108040e+01 */
    { 0x51c0a1fa,0xb93a25af,0x37cd3500 }, /* 292:  1.0341890e+11 -1.7752381e-04  2.4462584e-05 */
    { 0xc00b0928,0xbfec24ed,0xbea7b58c }, /* 293: -2.1724339e+00 -1.8448769e+00 -3.2755697e-01 */
    { 0x407a3a1c,0xb545d25c,0x3534659c }, /* 294:  3.9097967e+00 -7.3694332e-07  6.7203086e-07 */
    { 0xc0aead33,0x3f26d478,0xbe7b1760 }, /* 295: -5.4586425e+00  6.5167952e-01 -2.4520636e-01 */
    { 0xbf1b16e4,0x3f04e6d8,0xbdb18060 }, /* 296: -6.0581803e-01  5.1914740e-01 -8.6670637e-02 */
    { 0xc73c81c1,0x3f4d5546,0xbeee2744 }, /* 297: -4.8257754e+04  8.0208242e-01 -4.6514332e-01 */
    { 0xbf0cfdad,0xbef0a5ce,0xbda55630 }, /* 298: -5.5074579e-01 -4.7001499e-01 -8.0730796e-02 */
    { 0xc0ff9ffd,0x3fc4d4f8,0xbe995c70 }, /* 299: -7.9882798e+00  1.5377493e+00 -2.9953337e-01 */
    { 0x58da9823,0xbf070104,0x3f0667bc }, /* 300:  1.9227757e+15 -5.2735925e-01  5.2502036e-01 */
    { 0x3feaa3a2,0xbdfe268d,0x3dc41e6a }, /* 301:  1.8331187e+00 -1.2409697e-01  9.5761135e-02 */
    { 0xc0fa3d79,0xbe40e898,0xbdc4dd90 }, /* 302: -7.8200040e+00 -1.8838727e-01 -9.6125722e-02 */
    { 0xc1953315,0x3dd3ab2b,0xbd3d7588 }, /* 303: -1.8649942e+01  1.0335382e-01 -4.6254665e-02 */
    { 0x3b42969c,0x229f3897,0x21216000 }, /* 304:  2.9691821e-03  4.3156953e-18  5.4675977e-19 */
    { 0xe15b2e96,0xc1a0bc53,0xc0fed3fc }, /* 305: -2.5269961e+20 -2.0091955e+01 -7.9633770e+00 */
    { 0x41b03f49,0xb3dd5521,0x32de1224 }, /* 306:  2.2030901e+01 -1.0306599e-07  2.5852451e-08 */
    { 0xc1ae0d74,0x40bc1144,0xc0840204 }, /* 307: -2.1756569e+01  5.8771076e+00 -4.1252460e+00 */
    { 0x3f350d16,0xbf22b655,0x3d92b608 }, /* 308:  7.0723093e-01 -6.3559467e-01  7.1636260e-02 */
    { 0xbfc9d87b,0x30845c87,0xae64edc0 }, /* 309: -1.5769190e+00  9.6305619e-10 -5.2052362e-11 */
    { 0xc1a4c559,0xbd8c3426,0xbd7078f0 }, /* 310: -2.0596361e+01 -6.8458840e-02 -5.8709085e-02 */
    { 0xbce11098,0x36ee2912,0xb6b8a1e4 }, /* 311: -2.7473733e-02  7.0977339e-06 -5.5024739e-06 */
    { 0x59fa2a70,0x46be8297,0x4692f6c3 }, /* 312:  8.8019256e+15  2.4385295e+04  1.8811381e+04 */
    { 0xc155417c,0x3f6c47eb,0xbed051cc }, /* 313: -1.3328487e+01  9.2297238e-01 -4.0687406e-01 */
    { 0x41157105,0x3b692dbe,0x39923610 }, /* 314:  9.3400927e+00  3.5580243e-03  2.7887570e-04 */
    { 0x3feedabb,0xbfaaf934,0x3f07c30e }, /* 315:  1.8660501e+00 -1.3357301e+00  5.3032005e-01 */
    { 0xbf295e79,0xae7cda80,0xaddf4000 }, /* 316: -6.6159779e-01 -5.7492233e-11 -2.5380587e-11 */
    { 0x43237260,0xbd1d50e0,0x3cc589c0 }, /* 317:  1.6344678e+02 -3.8407207e-02  2.4113536e-02 */
    { 0x3facc5ec,0x3de0f647,0x3d01a6d8 }, /* 318:  1.3497901e+00  1.0984474e-01  3.1653255e-02 */
    { 0x3fe318b3,0x3e7a2466,0x3d838d9c }, /* 319:  1.7741913e+00  2.4427947e-01  6.4234942e-02 */
    { 0xc1cfd078,0x3cf5e922,0xbc32483c }, /* 320: -2.5976791e+01  3.0018393e-02 -1.0881480e-02 */
    { 0xbfee72c0,0x3dc219ed,0xbd7e7ed2 }, /* 321: -1.8628769e+00  9.4776012e-02 -6.2132664e-02 */
    { 0x4ff430e3,0xc5446080,0x4406d000 }, /* 322:  8.1936891e+09 -3.1420312e+03  5.3925000e+02 */
    { 0x3fb83abe,0x3cbccec0,0x3c293a00 }, /* 323:  1.4392927e+00  2.3047805e-02  1.0328770e-02 */
    { 0xbf52507c,0x398d55ae,0xb91a2bfc }, /* 324: -8.2154059e-01  2.6957452e-04 -1.4702970e-04 */
    { 0xc4ab6153,0xbf1077a4,0xbe96d1d8 }, /* 325: -1.3710414e+03 -5.6432557e-01 -2.9456973e-01 */
    { 0xc16deca3,0x409ab8ee,0xbebae7c0 }, /* 326: -1.4870273e+01  4.8350744e+00 -3.6504936e-01 */
    { 0x44afb7a4,0xbfd875af,0x3ee233bc }, /* 327:  1.4057388e+03 -1.6910914e+00  4.4180095e-01 */
    { 0xc0c05db7,0x394a74de,0xb92a70fc }, /* 328: -6.0114398e+00  1.9307758e-04 -1.6254553e-04 */
    { 0xc1623a95,0x40c4ec53,0xbfea7210 }, /* 329: -1.4139302e+01  6.1538482e+00 -1.8316059e+00 */
    { 0x3f0e7a22,0x2e25f406,0x2c201880 }, /* 330:  5.5655110e-01  3.7733393e-11  2.2750968e-12 */
    { 0xbfd2517d,0x3f2b2eba,0xbe9c8b0c }, /* 331: -1.6431118e+00  6.6868174e-01 -3.0574834e-01 */
    { 0xc1ca70e2,0x3e16087f,0xbdd57758 }, /* 332: -2.5305119e+01  1.4651679e-01 -1.0423154e-01 */
    { 0x43be1c0b,0x3c390f22,0x3b469d10 }, /* 333:  3.8021909e+02  1.1295112e-02  3.0306019e-03 */
    { 0xc0c16763,0x3e722653,0xbe072e45 }, /* 334: -6.0438704e+00  2.3647432e-01 -1.3201244e-01 */
    { 0xc28a2433,0x3efc85e9,0xbcaf7940 }, /* 335: -6.9070702e+01  4.9320915e-01 -2.1420121e-02 */
    { 0xbd3a46ab,0xa9a8153e,0xa78718a0 }, /* 336: -4.5477550e-02 -7.4643837e-14 -3.7496726e-15 */
    { 0xbe281299,0x315aff95,0xb13622d3 }, /* 337: -1.6413344e-01  3.1868457e-09 -2.6504281e-09 */
    { 0xc2b10767,0xbf356e47,0xbf22491c }, /* 338: -8.8514458e+01 -7.0871395e-01 -6.3392806e-01 */
    { 0xbefdb86b,0x3d097f1d,0xbcd19f84 }, /* 339: -4.9554762e-01  3.3568490e-02 -2.5588758e-02 */
    { 0x40e76f52,0x3e193ab6,0x3d4ba080 }, /* 340:  7.2323389e+00  1.4963803e-01  4.9713612e-02 */
    { 0xc80accdd,0xc00390e3,0xbf93aa4e }, /* 341: -1.4213145e+05 -2.0557182e+00 -1.1536348e+00 */
    { 0x4235ec47,0xbba34b29,0x3b3f10d4 }, /* 342:  4.5480740e+01 -4.9833250e-03  2.9154317e-03 */
    { 0xc08c5dc0,0xbde863a8,0xbd98a510 }, /* 343: -4.3864441e+00 -1.1347133e-01 -7.4533582e-02 */
    { 0x3f066df3,0x3ea717bb,0x3e4b8856 }, /* 344:  5.2511519e-01  3.2635292e-01  1.9876227e-01 */
    { 0x3f191d43,0xbca2c618,0x3b038c80 }, /* 345:  5.9810275e-01 -1.9869849e-02  2.0072758e-03 */
    { 0x40ca7898,0x3f4a51aa,0x3b9bb800 }, /* 346:  6.3272209e+00  7.9030859e-01  4.7521591e-03 */
    { 0x3f2801a5,0xbb2a5385,0x3aaedc28 }, /* 347:  6.5627509e-01 -2.5989723e-03  1.3340758e-03 */
    { 0xbfff7736,0xbf09f90d,0xbec2068a }, /* 348: -1.9958255e+00 -5.3895646e-01 -3.7895614e-01 */
    { 0xbff5f6e9,0xbf1ccfeb,0xbdabf088 }, /* 349: -1.9215976e+00 -6.1254758e-01 -8.3954871e-02 */
    { 0xbe2cdad9,0x3da20d43,0xbc2cd960 }, /* 350: -1.6880359e-01  7.9126857e-02 -1.0549873e-02 */
    { 0x43666c27,0xbdaec642,0x3be37e80 }, /* 351:  2.3042247e+02 -8.5339084e-02  6.9425702e-03 */
    { 0xbf3f0d48,0xbe3fff39,0xbe3c3775 }, /* 352: -7.4629641e-01 -1.8749703e-01 -1.8380530e-01 */
    { 0x3e36bf70,0x3d2ec13c,0x3bffc680 }, /* 353:  1.7846465e-01  4.2664751e-02  7.8056455e-03 */
    { 0x39fb5fe2,0x34dd705c,0x343f0cd0 }, /* 354:  4.7945889e-04  4.1246210e-07  1.7792922e-07 */
    { 0x41a4f2d8,0x80ff3ad5,0x00339cc1 }, /* 355:  2.0618576e+01 -2.3439156e-38  4.7398430e-39 */
    { 0xc1f67be4,0x3d73d9c3,0xbd010131 }, /* 356: -3.0810493e+01  5.9533846e-02 -3.1495277e-02 */
    { 0x444e07f6,0xbc9834fd,0x3c2c5192 }, /* 357:  8.2412439e+02 -1.8579954e-02  1.0517495e-02 */
    { 0x3f61ab63,0x92b17c83,0x11fee89c }, /* 358:  8.8152140e-01 -1.1200965e-27  4.0217491e-28 */
    { 0x3fea6e26,0x21b7665d,0x20e63374 }, /* 359:  1.8314865e+00  1.2427658e-18  3.8997564e-19 */
    { 0xc17466aa,0x3f12708b,0xbecdf904 }, /* 360: -1.5275064e+01  5.7202977e-01 -4.0229046e-01 */
    { 0xc0bc2c2a,0x3d4b2c7c,0xbcdf27b0 }, /* 361: -5.8803911e+00  4.9602970e-02 -2.7240604e-02 */
    { 0xc2f87a5c,0xc0f2df13,0xc0336920 }, /* 362: -1.2423898e+02 -7.5897307e+00 -2.8032913e+00 */
    { 0xbf06d297,0xa71c0578,0xa67b7860 }, /* 363: -5.2665085e-01 -2.1652314e-15 -8.7246257e-16 */
    { 0x59ab9ab4,0x40d58510,0x4055a760 }, /* 364:  6.0377899e+15  6.6724930e+00  3.3383408e+00 */
    { 0xbe2b6055,0x3ddc6da6,0xbd74a608 }, /* 365: -1.6735967e-01  1.0763101e-01 -5.9728652e-02 */
    { 0xbd18f97d,0xbcf9c670,0xbbe0b228 }, /* 366: -3.7347306e-02 -3.0490130e-02 -6.8571754e-03 */
    { 0x3f1b0f4a,0x367fbd1f,0x35b65bfe }, /* 367:  6.0570204e-01  3.8108044e-06  1.3586830e-06 */
    { 0x3f0de97b,0x3dfb8e13,0x3d81138c }, /* 368:  5.5434388e-01  1.2282958e-01  6.3025564e-02 */
    { 0xbfda315d,0xbf354c96,0xbe93931c }, /* 369: -1.7046314e+00 -7.0819986e-01 -2.8823173e-01 */
    { 0x40c7b0d8,0x3b3cc648,0x3aa235a0 }, /* 370:  6.2403374e+00  2.8804708e-03  1.2375601e-03 */
    { 0x43de02f7,0x3de7613e,0x3c9278d0 }, /* 371:  4.4402316e+02  1.1297844e-01  1.7879874e-02 */
    { 0xbfd702f5,0xbef6360a,0xbe72d36c }, /* 372: -1.6797777e+00 -4.8088104e-01 -2.3713464e-01 */
    { 0xc12ec53f,0x338795e2,0xb2da7b20 }, /* 373: -1.0923156e+01  6.3136909e-08 -2.5434531e-08 */
    { 0xbfdea308,0x3eff3664,0xbe79d1e8 }, /* 374: -1.7393503e+00  4.9846184e-01 -2.4396479e-01 */
    { 0x41f9ae8a,0x3ff78325,0x3e8ad940 }, /* 375:  3.1210224e+01  1.9336897e+00  2.7118874e-01 */
    { 0xbe5285f8,0x2f76c477,0xae8c5098 }, /* 376: -2.0558918e-01  2.2443368e-10 -6.3807792e-11 */
    { 0x3c7430bf,0x9009af0a,0x0fc352a8 }, /* 377:  1.4904200e-02 -2.7153331e-29  1.9260323e-29 */
    { 0xbf32521c,0x3f2a596f,0xbcff15a0 }, /* 378: -6.9656539e-01  6.6542715e-01 -3.1138241e-02 */
    { 0xbd6c7900,0x3a370a9c,0xb9f9b410 }, /* 379: -5.7732582e-02  6.9824769e-04 -4.7627138e-04 */
    { 0x3f2ab516,0xbe6edb8e,0x3e4d1d3c }, /* 380:  6.6682565e-01 -2.3325941e-01  2.0030683e-01 */
    { 0xbf153e8f,0xbe23d601,0xbdd2f072 }, /* 381: -5.8298582e-01 -1.5999605e-01 -1.0299768e-01 */
    { 0xbf07f53b,0x3cb0da56,0xbc545ea0 }, /* 382: -5.3108567e-01  2.1588486e-02 -1.2962013e-02 */
    { 0x41563dcb,0xbeeb24f5,0x3d92267c }, /* 383:  1.3390086e+01 -4.5926633e-01  7.1362466e-02 */
    { 0x414bbb7f,0x406eeabe,0x3fc45b84 }, /* 384:  1.2733275e+01  3.7330775e+00  1.5340428e+00 */
    { 0x3f1e58ae,0xbc84a85a,0x3b50c320 }, /* 385:  6.1854064e-01 -1.6193558e-02  3.1854585e-03 */
    { 0x3e27096f,0xbb36b942,0x3ab8c598 }, /* 386:  1.6312192e-01 -2.7881418e-03  1.4096973e-03 */
    { 0xc4e8e123,0x414a12a7,0xc0cfb736 }, /* 387: -1.8630355e+03  1.2629554e+01 -6.4911146e+00 */
    { 0x3f033162,0x3e4565b5,0x3e01fa1e }, /* 388:  5.1247227e-01  1.9277079e-01  1.2693068e-01 */
    { 0x3dc8a1d1,0xbce09f4c,0x3c80a960 }, /* 389:  9.7964890e-02 -2.7419709e-02  1.5705764e-02 */
    { 0x3f286715,0x3f0035f9,0x3e20c470 }, /* 390:  6.5782291e-01  5.0082356e-01  1.5699935e-01 */
    { 0xbf5d4742,0xb5fa661d,0xb45748c8 }, /* 391: -8.6436856e-01 -1.8656170e-06 -2.0049913e-07 */
    { 0xd6105825,0xc136c04f,0xc0befaaa }, /* 392: -3.9677063e+13 -1.1421950e+01 -5.9680986e+00 */
    { 0xbf0d61e2,0xbe1bf7c5,0xbdc34072 }, /* 393: -5.5227482e-01 -1.5231235e-01 -9.5337763e-02 */
    { 0x4b91dc20,0x3ff5c772,0x3f8425ae }, /* 394:  1.9118144e+07  1.9201491e+00  1.0323999e+00 */
    { 0x3e90b09d,0x3d831a05,0x3cd96980 }, /* 395:  2.8259745e-01  6.4014472e-02  2.6539564e-02 */
    { 0xbfc8524b,0x3efda60d,0xbda15c14 }, /* 396: -1.5650114e+00  4.9540749e-01 -7.8788906e-02 */
    { 0xc00acddc,0xbd3b8bfe,0xbc8986bc }, /* 397: -2.1688147e+00 -4.5787804e-02 -1.6787879e-02 */
    { 0x48e79456,0xbcf20e84,0x3c0c7878 }, /* 398:  4.7427469e+05 -2.9547937e-02  8.5736439e-03 */
    { 0xc140ae75,0xb883c5a9,0xb8456ede }, /* 399: -1.2042592e+01 -6.2833838e-05 -4.7071713e-05 */
    { 0x40038934,0x8bf0af41,0x09d46f20 }, /* 400:  2.0552492e+00 -9.2708330e-32  5.1141645e-33 */
    { 0x473f432e,0x413b0430,0x413a5ec0 }, /* 401:  4.8963180e+04  1.1688522e+01  1.1648132e+01 */
    { 0xc0743d95,0xbdbfb958,0xbd92bce0 }, /* 402: -3.8162587e+00 -9.3615234e-02 -7.1649313e-02 */
    { 0xc7d76a5e,0xbf4d24fb,0xbeb02c54 }, /* 403: -1.1029273e+05 -8.0134553e-01 -3.4408820e-01 */
    { 0xc1d9863f,0xbfee49ef,0xbf9058de }, /* 404: -2.7190550e+01 -1.8616313e+00 -1.1277120e+00 */
    { 0x4bba6685,0xc0f2d6c8,0x40442b40 }, /* 405:  2.4431882e+07 -7.5887184e+00  3.0651398e+00 */
    { 0xc1e532b6,0xc15185b5,0xc01d6808 }, /* 406: -2.8649761e+01 -1.3095143e+01 -2.4594746e+00 */
    { 0xc24865fd,0x4152c35e,0xc1294dda }, /* 407: -5.0099598e+01  1.3172697e+01 -1.0581507e+01 */
    { 0x4129a95c,0x3f43d291,0x3f28e463 }, /* 408:  1.0603848e+01  7.6493174e-01  6.5973490e-01 */
    { 0x3c7fdbd9,0xbc692f50,0x3ab56448 }, /* 409:  1.5616381e-02 -1.4232472e-02  1.3839090e-03 */
    { 0xc4496c06,0xc1cb9193,0xc186dff3 }, /* 410: -8.0568787e+02 -2.5446081e+01 -1.6859350e+01 */
    { 0x739dbe84,0x3e1aa64b,0x3d164234 }, /* 411:  2.4995566e+31  1.5102498e-01  3.6684230e-02 */
    { 0xc76a94f9,0xc3940b52,0xc3731b98 }, /* 412: -6.0052973e+04 -2.9608844e+02 -2.4310779e+02 */
    { 0xc256672b,0xc2195739,0xc1743fc8 }, /* 413: -5.3600750e+01 -3.8335178e+01 -1.5265572e+01 */
    { 0xc1038c6f,0x2ffe6dbf,0xafdf868b }, /* 414: -8.2217855e+00  4.6280310e-10 -4.0659062e-10 */
    { 0x41b74569,0xbfdf89a9,0x3e52c7d8 }, /* 415:  2.2908892e+01 -1.7463886e+00  2.0584047e-01 */
    { 0xbdfcb291,0x34fad283,0xb4d7178b }, /* 416: -1.2338746e-01  4.6719296e-07 -4.0064000e-07 */
    { 0x42e1ac15,0xc0b02c12,0x402e9fd0 }, /* 417:  1.1283610e+02 -5.5053797e+00  2.7285042e+00 */
    { 0x44f76ff0,0xc0fa4063,0x3f727148 }, /* 418:  1.9794980e+03 -7.8203597e+00  9.4704103e-01 */
    { 0x3f08add9,0xbdd8bb31,0x3b9c6d30 }, /* 419:  5.3390270e-01 -1.0582579e-01  4.7737584e-03 */
    { 0xbf216dea,0x3d4358b6,0xbc2d7588 }, /* 420: -6.3058341e-01  4.7692023e-02 -1.0587104e-02 */
    { 0xc36dddb6,0x374f8669,0xb68a791c }, /* 421: -2.3786606e+02  1.2369456e-05 -4.1268195e-06 */
    { 0x42dd825e,0xbfbcb037,0x3e47bb18 }, /* 422:  1.1075462e+02 -1.4741277e+00  1.9504964e-01 */
    { 0xee38da74,0xbc989c94,0xbc3574e0 }, /* 423: -1.4302334e+28 -1.8629350e-02 -1.1075228e-02 */
    { 0xbf64721c,0x3efda701,0xbecb3d37 }, /* 424: -8.9236617e-01  4.9541476e-01 -3.9695141e-01 */
    { 0xbf659742,0xb8ee9b1c,0xb86927d0 }, /* 425: -8.9683926e-01 -1.1377616e-04 -5.5588607e-05 */
    { 0xbfecc40f,0x3f72e00f,0xbf66a80f }, /* 426: -1.8497332e+00  9.4873136e-01 -9.0100187e-01 */
    { 0x3f39ef7e,0xbefc245d,0x3e6f753e }, /* 427:  7.2631061e-01 -4.9246493e-01  2.3384568e-01 */
    { 0xc055efbd,0xbfef286a,0xbfbcb710 }, /* 428: -3.3427575e+00 -1.8684208e+00 -1.4743366e+00 */
    { 0xc40da397,0xc0ccbb3b,0xc062de70 }, /* 429: -5.6655609e+02 -6.3978553e+00 -3.5448265e+00 */
    { 0x41021b62,0xbf1a9216,0x3e909604 }, /* 430:  8.1316853e+00 -6.0379159e-01  2.8239453e-01 */
    { 0xbdfadaba,0x3d19d204,0xbc20fda0 }, /* 431: -1.2248750e-01  3.7553802e-02 -9.8260939e-03 */
    { 0xd82b6b8e,0x3faa7551,0xbf83fc9b }, /* 432: -7.5391373e+14  1.3317052e+00 -1.0311464e+00 */
    { 0x3f3cc3c3,0x3c40b1d6,0x3c05deec }, /* 433:  7.3736209e-01  1.1761149e-02  8.1708245e-03 */
    { 0x3eff16c9,0xbd7ae87c,0x3c05c9a0 }, /* 434:  4.9822071e-01 -6.1256871e-02  8.1657469e-03 */
    { 0xbf318c69,0x3f2626cd,0xbd3659c0 }, /* 435: -6.9354874e-01  6.4902955e-01 -4.4519186e-02 */
    { 0xbfb7cc86,0xb919d021,0xb6a84460 }, /* 436: -1.4359291e+00 -1.4668751e-04 -5.0147501e-06 */
    { 0x43444486,0x3ffcd4eb,0x3f37d83e }, /* 437:  1.9626767e+02  1.9752477e+00  7.1814334e-01 */
    { 0xc23c3a67,0x24c625d9,0xa47bc432 }, /* 438: -4.7057034e+01  8.5932928e-17 -5.4593133e-17 */
    { 0x3f271c57,0x3f2019f1,0x3ce04cc0 }, /* 439:  6.5277618e-01  6.2539583e-01  2.7380347e-02 */
    { 0x3e5fc994,0x3e1593f3,0x3d946b42 }, /* 440:  2.1854240e-01  1.4607219e-01  7.2470203e-02 */
    { 0xbff7db32,0x3f3888d2,0xbefd4980 }, /* 441: -1.9363768e+00  7.2083771e-01 -4.9470139e-01 */
    { 0xbf08f539,0xbb900a29,0xbb4b9e3e }, /* 442: -5.3499180e-01 -4.3957424e-03 -3.1069661e-03 */
    { 0xbe852ffb,0x19880f78,0x991b4690 }, /* 443: -2.6013169e-01  1.4068318e-23 -8.0275622e-24 */
    { 0x42e46242,0x3d9838ca,0x3cd13000 }, /* 444:  1.1419191e+02  7.4327067e-02  2.5535583e-02 */
    { 0xbfd755a6,0xbef0c04f,0xbe8b15ab }, /* 445: -1.6823013e+00 -4.7021720e-01 -2.7164969e-01 */
    { 0x406d9f3d,0xb9c91960,0x39a13b60 }, /* 446:  3.7128441e+00 -3.8356613e-04  3.0752551e-04 */
    { 0x410184d4,0xbe2ad3c5,0x3db30020 }, /* 447:  8.0949287e+00 -1.6682346e-01  8.7402582e-02 */
    { 0xc089f6e4,0x3ddb0b3d,0xbd07eef0 }, /* 448: -4.3113880e+00  1.0695503e-01 -3.3186853e-02 */
    { 0xbeb509c2,0x3b851c14,0xb93cb680 }, /* 449: -3.5359007e-01  4.0621851e-03 -1.7997064e-04 */
    { 0x3f1ff2f6,0x363843b9,0x35d693b2 }, /* 450:  6.2480104e-01  2.7457556e-06  1.5987227e-06 */
    { 0x3fdb4ae2,0xbf06d52b,0x3e08590c }, /* 451:  1.7132227e+00 -5.2669019e-01  1.3315219e-01 */
    { 0xc0cb5ebd,0x3cb929c5,0xbb7f1e18 }, /* 452: -6.3553147e+00  2.2602925e-02 -3.8927849e-03 */
    { 0xbdccfe4f,0xbce7e011,0xbc78b212 }, /* 453: -1.0009443e-01 -2.8305085e-02 -1.5179174e-02 */
    { 0xbb40d853,0xba9ff20c,0xba03991c }, /* 454: -2.9425814e-03 -1.2202873e-03 -5.0200685e-04 */
    { 0xbe15c0a3,0xbc38b8bb,0xbc33616c }, /* 455: -1.4624266e-01 -1.1274512e-02 -1.0948520e-02 */
    { 0xbe62cbd4,0x39f9d162,0xb9cc2660 }, /* 456: -2.2148067e-01  4.7648983e-04 -3.8938504e-04 */
    { 0x41d6ed97,0x40f2e4f8,0x40830774 }, /* 457:  2.6866011e+01  7.5904503e+00  4.0946598e+00 */
    { 0xbef50211,0x3e74a580,0xba392200 }, /* 458: -4.7853139e-01  2.3891258e-01 -7.0622563e-04 */
    { 0xbf234990,0x3e19d72a,0xbd172660 }, /* 459: -6.3784122e-01  1.5023485e-01 -3.6901832e-02 */
    { 0x41362667,0xbeab9200,0x3ea6fae0 }, /* 460:  1.1384376e+01 -3.3509827e-01  3.2613277e-01 */
    { 0x40a2d07a,0x3ff9e784,0x3f9772e0 }, /* 461:  5.0879488e+00  1.9523778e+00  1.1831932e+00 */
    { 0xbfd94dcd,0x3fd587c7,0xbcf18180 }, /* 462: -1.6976868e+00  1.6682061e+00 -2.9480696e-02 */
    { 0xc297f3c0,0x4174b7fc,0xc16cbe10 }, /* 463: -7.5976074e+01  1.5294918e+01 -1.4796402e+01 */
    { 0x40de8a9c,0x3feaa3a6,0x3fba3f7e }, /* 464:  6.9544201e+00  1.8331192e+00  1.4550626e+00 */
    { 0xc0f650d8,0xc09e5c9c,0xc02fe878 }, /* 465: -7.6973686e+00 -4.9488049e+00 -2.7485638e+00 */
    { 0x501adfd3,0x3b806f52,0x3ad5f300 }, /* 466:  1.0393439e+10  3.9195204e-03  1.6323030e-03 */
    { 0xc0bbcd68,0xb5b1f2d7,0xb5471a80 }, /* 467: -5.8688240e+00 -1.3258203e-06 -7.4171840e-07 */
    { 0xc1945c5a,0x3fe53c42,0xbf22d618 }, /* 468: -1.8545094e+01  1.7909014e+00 -6.3607931e-01 */
    { 0x40d63ae9,0xbef3a978,0x3d035000 }, /* 469:  6.6946912e+00 -4.7590232e-01  3.2058716e-02 */
    { 0xc1b10247,0x3d2097a1,0xbc59fd30 }, /* 470: -2.2126112e+01  3.9207105e-02 -1.3304994e-02 */
    { 0xc3499e0c,0xbc95a451,0xbbd11f4c }, /* 471: -2.0161737e+02 -1.8266829e-02 -6.3819047e-03 */
    { 0xc9f4e7a5,0xb8e91ff8,0xb7a0f680 }, /* 472: -2.0062606e+06 -1.1116260e-04 -1.9188272e-05 */
    { 0xbf8d3596,0x84be9efd,0x8424b58a }, /* 473: -1.1031978e+00 -4.4814793e-36 -1.9361466e-36 */
    { 0x4321c19f,0xb371b007,0x328cbf88 }, /* 474:  1.6175633e+02 -5.6272281e-08  1.6385243e-08 */
    { 0xc1395012,0xbd1b3681,0xbcc8449e }, /* 475: -1.1582048e+01 -3.7893776e-02 -2.4446782e-02 */
    { 0xc1bf7a2f,0xbfd889ba,0xbe806b10 }, /* 476: -2.3934660e+01 -1.6917031e+00 -2.5081682e-01 */
    { 0xbf0ed8d1,0x3b095e87,0xb9e4c5d0 }, /* 477: -5.5799586e-01  2.0960884e-03 -4.3634931e-04 */
    { 0x41282d3f,0xbf3d77a6,0x3e192370 }, /* 478:  1.0511046e+01 -7.4010694e-01  1.4954925e-01 */
    { 0xcaa95ca0,0xbb4187d3,0xba2f98dc }, /* 479: -5.5496480e+06 -2.9530420e-03 -6.6984980e-04 */
    { 0x4117e87d,0x3f427976,0x3ec1ac90 }, /* 480:  9.4942598e+00  7.5966585e-01  3.7826967e-01 */
    { 0x3db463de,0x365a795e,0x364e7abe }, /* 481:  8.8081107e-02  3.2555176e-06  3.0767837e-06 */
    { 0x3fab7ea4,0xb5feae21,0x356ab33c }, /* 482:  1.3398023e+00 -1.8975153e-06  8.7432613e-07 */
    { 0x4635f075,0x40b40438,0x409d8f68 }, /* 483:  1.1644114e+04  5.6255150e+00  4.9237556e+00 */
    { 0x411f2601,0xbee4ac18,0x3df7d840 }, /* 484:  9.9467783e+00 -4.4662547e-01  1.2101793e-01 */
    { 0x425df0fa,0x3cca0457,0x3cc7afb1 }, /* 485:  5.5485329e+01  2.4660273e-02  2.4375768e-02 */
    { 0x418d6236,0x3de5d93f,0x3d57f4ba }, /* 486:  1.7672955e+01  1.1223077e-01  5.2723624e-02 */
    { 0xc3128d52,0x411b46ee,0xbf7ad2e0 }, /* 487: -1.4655203e+02  9.7048168e+00 -9.7978020e-01 */
    { 0xbf0557a8,0x3dc8a633,0xbcfdf904 }, /* 488: -5.2086878e-01  9.7973250e-02 -3.1002529e-02 */
    { 0x43af4e3a,0x3fbc155f,0x3f64b75c }, /* 489:  3.5061115e+02  1.4694022e+00  8.9342284e-01 */
    { 0xc235ae0e,0xbdcaa587,0xbb2a5e60 }, /* 490: -4.5419975e+01 -9.8948531e-02 -2.5996193e-03 */
    { 0xbf4eecda,0xbe8cdd85,0xbe841eaa }, /* 491: -8.0830157e-01 -2.7512756e-01 -2.5804645e-01 */
    { 0xc00a6dfa,0x3f2f3e96,0xbddfe130 }, /* 492: -2.1629624e+00  6.8454874e-01 -1.0931623e-01 */
    { 0x3fc96efc,0xbf219802,0x3e9f5be8 }, /* 493:  1.5736995e+00 -6.3122571e-01  3.1124806e-01 */
    { 0xc885476d,0x3f2c2fff,0xbf13b138 }, /* 494: -2.7295541e+05  6.7260736e-01 -5.7692289e-01 */
    { 0xc13cdccb,0xbb5965c5,0xbaa08004 }, /* 495: -1.1803905e+01 -3.3172232e-03 -1.2245183e-03 */
    { 0xbdfd485b,0xbda068bb,0xbd39bf40 }, /* 496: -1.2367316e-01 -7.8324758e-02 -4.5348406e-02 */
    { 0x410b4754,0xbcd73895,0x3c10feb2 }, /* 497:  8.7049141e+00 -2.6272098e-02  8.8497866e-03 */
    { 0x3f523e80,0xbc4c7a05,0x3c24a4bb }, /* 498:  8.2126617e-01 -1.2480264e-02  1.0049040e-02 */
    { 0x3fc7d2cf,0x389f574e,0x382dbbc8 }, /* 499:  1.5611209e+00  7.5979726e-05  4.1421299e-05 */
    { 0x40981d30,0x3f309db8,0x3f1d3730 }, /* 500:  4.7535629e+00  6.8990660e-01  6.1412334e-01 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, y, z;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	y.lo = pgm_read_dword (& t[i].y);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = fmod (x.fl, y.fl);
	/* Comparison is integer to verify the zero sign.	*/
	if (v.lo != z.lo)
	    x_exit (i+1);
    }
    return 0;
}
