/*
   eeprom.h

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef _EEPROM_H_
#define _EEPROM_H_ 1

#define __need_size_t
#include <stddef.h>

#include <io.h>

/* return 1 if EEPROM is ready for a new read/write operation, 0 if not */
#define eeprom_is_ready() bit_is_clear(EECR, EEWE)

#ifdef __cplusplus
extern "C" {
#endif

/* read one byte from EEPROM address ADDR */
extern unsigned char eeprom_rb(unsigned int addr);

/* read one 16-bit word (little endian) from EEPROM address ADDR */
extern unsigned int eeprom_rw(unsigned int addr);

/* write a byte VAL to EEPROM address ADDR */
extern void eeprom_wb(unsigned int addr, unsigned char val);

/* read a block of SIZE bytes from EEPROM address ADDR to BUF */
extern void eeprom_read_block(void *buf, unsigned int addr, size_t n);


#ifdef __cplusplus
}
#endif

/* IAR C compatibility defines */
#define _EEPUT(addr, val) eeprom_wb(addr, val)
#define _EEGET(var, addr) (var) = eeprom_rb(addr)

#endif /* _EEPROM_H_ */
