#!/bin/sh
#
# install script for RedHat 5.0 -- this should be SRPMed..
#

linuxroot=/usr/src/linux
destdir=$linuxroot/drivers/sound/lowlevel

setup_config () {
	tmpconfig=/tmp/awe_config.$$
	tmpconfig2=/tmp/awe_conf2.$$
	rm -f $tmpconfig $tmpconfig2
	cp awe_config.h $tmpconfig
}

define_condition () {
	sed -e "s@^#undef $1\$@#define $1@" $tmpconfig > $tmpconfig2
	mv -f $tmpconfig2 $tmpconfig
}

undef_condition () {
	sed -e "s@^#define $1\$@#undef $1@" $tmpconfig > $tmpconfig2
	mv -f $tmpconfig2 $tmpconfig
}

define_value () {
	sed -e "s@^#define $1 [0-9]*@#define $1 $2@" $tmpconfig > $tmpconfig2
	mv -f $tmpconfig2 $tmpconfig
}

sources="awe_wave.c awe_hw.h awe_version.h awe_compat.h README.awe ChangeLog.awe"
headers="awe_voice.h"

# patch the kernel tree
if [ ! -f $destdir/awe_wave.c ]; then
	echo "applying a patch to sound driver directory"
	patch -d $linuxroot -p1 < rh5.0.diff
fi

setup_config

undef_condition AWE_NEW_KERNEL_INTERFACE
undef_condition HAS_LOWLEVEL_H
undef_condition AWE_OBSOLETE_VOXWARE
undef_condition AWE_NO_PATCHMGR
undef_condition AWE_OSS38
define_condition AWE_MODULE_SUPPORT

echo -n "copying source files:"
for i in $sources; do
	echo -n " $i"
	rm -f $destdir/$i
	cp $i $destdir
done
echo

echo -n "copying header files:"
headdir=$linuxroot/include/linux
if [ x$sound_version = xVOXWARE ]; then
	headrel=../../include/linux
else
	headrel=../../../include/linux
fi
for i in $headers; do
	echo -n " $i"
	rm -f $headdir/$i $destdir/$i
	cp $i $headdir
	ln -s $headrel/$i $destdir/$i
done
echo

echo "copying config file"
rm -f $destdir/awe_config.h
mv $tmpconfig $destdir/awe_config.h

echo "done."
echo

echo "Please configure and remake linux kernel and modules."
echo "Answer 'Y' or 'M' to 'AWE32 synth support' under lowlevel support"
echo "in Sound menu when configuring your kernel."
echo "If you configure it as a module, the new module sbawe.o will be created."
echo "Also, you should keep other SoundBlaster options, too."

exit 0
