/*================================================================
 * awe_effect.h
 *	convert NRPN parameters to Emu8000 raw effects
 *
 * Copyright (C) 1996-1998 Takashi Iwai
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *================================================================*/

#ifndef AWE_EFFECT_H_DEF
#define AWE_EFFECT_H_DEF

struct awe_effect_rec {
	int awe_effect;
	unsigned short (*convert)(int);
	char *name;
};
extern struct awe_effect_rec awe_effects[];
extern int num_awe_effects;

struct gs_effect_rec {
	int control;
	int awe_effect;
	unsigned short (*convert)(MidiInfo*, int);
	char *name;
};
extern struct gs_effect_rec gs_effects[];
extern int num_gs_effects;

struct xg_effect_rec {
	int control;
	int awe_effect;
	unsigned short (*convert)(MidiInfo*, int);
	char *name;
};
extern struct xg_effect_rec xg_effects[];
extern int num_xg_effects;


#endif
