/*
    AWFFull - A Webalizer Fork, Full o' features

    Copyright (C) 1997-2001  Bradford L. Barrett (brad@mrunix.net)
    Copyright (C) 2004, 2005 by Stephen McInerney (spm@stedee.id.au)
    Copyright (C) 2006 by John Heaton (john@manchester.ac.uk)

    $Id: hashtab.h 415 2007-06-19 11:47:01Z steve $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/

/***************************************************************************
 ***************************************************************************
 * hastab.h
 *
 *  Hashing Tables definitions/includes
 *
 ***************************************************************************
 ***************************************************************************/

#ifndef AWFFULL_HASHTAB_H
#define AWFFULL_HASHTAB_H

typedef struct hnode *HNODEPTR;                 /* site node (host) pointer     */
typedef struct unode *UNODEPTR;                 /* url node pointer             */
typedef struct rnode *RNODEPTR;                 /* referrer node                */
typedef struct anode *ANODEPTR;                 /* user agent node pointer      */
typedef struct snode *SNODEPTR;                 /* Search string node pointer   */
typedef struct inode *INODEPTR;                 /* user (ident) node pointer    */
typedef struct enode *ENODEPTR;                 /* error page pointer           */

/* Object flags */
#define OBJ_REG  0                              /* Regular object               */
#define OBJ_HIDE 1                              /* Hidden object                */
#define OBJ_GRP  2                              /* Grouped object               */

struct hnode {
    char *string;                               /* host hash table structure    */
    int flag;
    unsigned long count;
    unsigned long files;
    unsigned long visit;                        /* visit information            */
    unsigned long pages;
    unsigned long tstamp;
    bool lasturl_is_entry;                      /* If the last url was the entry page => true */
    char *lasturl;
    unsigned long long xfer;
    struct hnode *next;
};

struct unode {
    char *string;                               /* url hash table structure     */
    int flag;                                   /* Object type (REG, HIDE, GRP) */
    unsigned long count;                        /* requests counter             */
    unsigned long pcount;                       /* 206 requests counter         */
    unsigned long files;                        /* files counter                */
    unsigned long entry;                        /* entry page counter           */
    unsigned long exit;                         /* exit page counter            */
    unsigned long single_access;                /* Single Access Counter        */
    unsigned long long xfer;                    /* xfer size in bytes           */
    unsigned long long pxfer;                   /* 206 xfer size in bytes       */
    struct unode *next;
};                                              /* pointer to next node         */

struct rnode {
    char *string;                               /* referrer hash table struct   */
    int flag;
    unsigned long count;
    struct rnode *next;
};

struct anode {
    char *string;
    int flag;
    unsigned long count;
    struct anode *next;
};

struct snode {
    char *string;                               /* search string struct      */
    unsigned long count;
    struct snode *next;
};

struct inode {
    char *string;                               /* host hash table struct    */
    int flag;
    unsigned long count;
    unsigned long files;
    unsigned long visit;
    unsigned long tstamp;
    unsigned long long xfer;
    struct inode *next;
};

struct enode {
    char *error_request;                        /* error page hash table struct   */
    char *url;                                  /* The errored request */
    char *referer;                              /* who have called this error page */
    unsigned long count;
    struct enode *next;
};

extern HNODEPTR sm_htab[MAXHASH];               /* hash tables               */
extern HNODEPTR sd_htab[MAXHASH];
extern UNODEPTR um_htab[MAXHASH];               /* for hits, sites,          */
extern RNODEPTR rm_htab[MAXHASH];               /* referrers and agents...   */
extern ANODEPTR am_htab[MAXHASH];
extern SNODEPTR sr_htab[MAXHASH];               /* search string table       */
extern INODEPTR im_htab[MAXHASH];               /* ident table (username)    */
extern ENODEPTR ep_htab[MAXHASH];               /* error page                */

extern int put_hnode(char *, int, unsigned long, unsigned long, unsigned long long, unsigned long *, unsigned long, unsigned long, unsigned long, char *, char *, HNODEPTR *, bool,
                     bool, bool *);
extern int put_unode(char *, int, unsigned long, unsigned long long, unsigned long *, unsigned long, unsigned long, unsigned long, int, UNODEPTR *);
extern int put_inode(char *, int, unsigned long, unsigned long, unsigned long long, unsigned long *, unsigned long, unsigned long, INODEPTR *, bool);
extern int put_rnode(char *, int, unsigned long, unsigned long *, RNODEPTR *);
extern int put_anode(char *, int, unsigned long, unsigned long *, ANODEPTR *);
extern int put_snode(char *, unsigned long, SNODEPTR *);
extern int put_enode(char *, char *, int, unsigned long, unsigned long *, ENODEPTR *);

extern void del_htabs(void);                    /* delete hash tables        */
extern void del_hlist(HNODEPTR *);              /* delete host htab          */
extern void del_ulist(UNODEPTR *);              /* delete url htab           */
extern void del_rlist(RNODEPTR *);              /* delete referrer htab      */
extern void del_alist(ANODEPTR *);              /* delete host htab          */
extern void del_slist(SNODEPTR *);              /* delete host htab          */
extern void del_ilist(INODEPTR *);              /* delete host htab          */
extern void del_elist(ENODEPTR *);              /* delete errorpage htab     */

extern void month_update_exit(unsigned long);
extern unsigned long tot_visit(HNODEPTR *);
extern char *find_url(char *);

#endif          /* AWFFULL_HASHTAB_H */
