/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nz.net.catalyst.ELog;
import nz.net.catalyst.Log;
import nz.net.catalyst.Main;
import nz.net.catalyst.StringPair;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.Transmission;

public class IndexFiles
extends Main {
    private static final IndexFiles instance = new IndexFiles();
    private static final String PORT_PROPERTY = "LuceneServerPort";
    private static final String HOST_PROPERTY = "LuceneServerHost";
    private static final String APPLICATION_PROPERTY = "Application";
    private static int port;
    private static String host;
    private static String application;
    private static final Map sums;
    private int count = 0;
    private long sum = 0L;

    static {
        sums = new HashMap();
    }

    public static void main(String[] args) {
        Log.debug("In main");
        instance.init(args);
    }

    public static void Start(String[] args) throws Exception {
        Log.debug("Starting");
        port = Integer.getInteger(PORT_PROPERTY, 22222);
        host = System.getProperty(HOST_PROPERTY, "localhost");
        application = System.getProperty(APPLICATION_PROPERTY, "test");
        Socket socket = new Socket(host, port);
        PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"), 0x100000), false);
        Date start = new Date();
        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
        int i = 0;
        while (i < args.length) {
            IndexFiles.indexDocs(out, in, new File(args[i]));
            ++i;
        }
        if (args.length == 0) {
            String line;
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            while ((line = stdin.readLine()) != null) {
                IndexFiles.indexDocs(out, in, new File(line.trim()));
            }
        }
        socket.close();
        Date end = new Date();
        Iterator it = sums.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String key = (String)e.getKey();
            IndexFiles stat = (IndexFiles)e.getValue();
            System.out.println(String.valueOf(key) + ": Count: " + stat.count + ", Total: " + stat.sum / 1000L + " secs, Average: " + stat.sum / (long)stat.count + " ms");
        }
        System.out.print(end.getTime() - start.getTime());
        Log.log(ELog.INFO, " total milliseconds");
    }

    public static void indexDocs(PrintWriter out, BufferedReader in, File file) throws Exception {
        if (file.isDirectory()) {
            String[] files = file.list();
            int i = 0;
            while (i < files.length) {
                IndexFiles.indexDocs(out, in, new File(file, files[i]));
                ++i;
            }
        } else {
            Log.log(ELog.INFO, "adding " + file);
            long beforeTransmission = System.currentTimeMillis();
            Transmission command = new Transmission(ECommand.INDEX);
            command.add("Serial", file.getPath());
            command.add("Id", file.getPath());
            command.add(APPLICATION_PROPERTY, application);
            command.add("Published", String.valueOf(file.lastModified() / 1000L));
            command.add("Body", "Text");
            long longFileSize = file.length();
            if (longFileSize > Integer.MAX_VALUE) {
                longFileSize = Integer.MAX_VALUE;
            }
            int fileSize = (int)longFileSize;
            long beforeReadingBody = System.currentTimeMillis();
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            char[] buffer = new char[fileSize];
            fileSize = isr.read(buffer);
            command.setBody(new String(buffer));
            long beforeSending = System.currentTimeMillis();
            command.write(out);
            long beforeReceiving = System.currentTimeMillis();
            Transmission response = Transmission.create(in);
            long finished = System.currentTimeMillis();
            if (response == null) {
                System.err.println("Input closed while we were waiting for a response!");
            } else {
                response.write(new PrintWriter(System.out));
                response.add("Response Time", String.valueOf(finished - beforeReceiving));
                Iterator it = response.getHeadersView().iterator();
                while (it.hasNext()) {
                    StringPair entry = (StringPair)it.next();
                    try {
                        long value = Long.parseLong(entry.getValueString());
                        String key = entry.getKeyString();
                        IndexFiles stat = (IndexFiles)sums.get(key);
                        if (stat == null) {
                            stat = new IndexFiles();
                            sums.put(key, stat);
                        }
                        ++stat.count;
                        stat.sum += value;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            System.err.println("Creating transmission: " + (beforeReadingBody - beforeTransmission) + " ms");
            System.err.println("Reading Body: " + (beforeSending - beforeReadingBody) + " ms");
            System.err.println("Sending command: " + (beforeReceiving - beforeSending) + " ms");
            System.err.println("Response time: " + (finished - beforeReceiving) + " ms");
        }
    }
}

