/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst;


/**
 * An immutable pair of objects
 *
 */

public class Pair
{
  private final Object key;
  private final Object value;

  public Pair(Object key, Object value)
  {
    this.key = key;
    this.value = value;
  }

  public final Object getKey()
  {
    return key;
  }

  public final Object getValue()
  {
    return value;
  }

  public boolean equals(Object other)
  {
    if (this == other)
      return true;

    if (!(other instanceof Pair))
      return false;

    Pair that = (Pair)other;
    return (this.key == null ? that.key == null : this.key.equals(that.key)) &&
      (this.value == null ? that.value == null : this.value.equals(that.value));
  }

  public int hashCode()
  {
    return (key == null ? 0 : key.hashCode()) ^
           (value == null ? 0 : value.hashCode());
  }
}
