/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst;

import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * Implements Java 1.4 nested-exception functionality.  Don't bother
 * with this class if you know you're implementing in Java 1.4
 */

public class RtException extends RuntimeException
{
  private Throwable origin = null;

  public RtException()
  {
    super();
  }

  public RtException(String message)
  {
    super(message);
    System.err.println("Error occured at " + new java.util.Date());
  	System.err.println("\tMessage: " + message);
  }

  public RtException(String message, Throwable origin)
  {
    super(message);
    this.origin = origin;
  }
  public RtException(Throwable origin)
  {
    super();
    this.origin = origin;
  }

  public Throwable getOrigin() {
    return origin;
  }

  public synchronized Throwable initOrigin(Throwable origin) {
    if (this.origin != null)
      throw new IllegalStateException("Can't overwrite origin");
    if (origin == this)
      throw new IllegalArgumentException("Self-causation not permitted");
    this.origin = origin;
    return this;
  }

  public void printStackTrace(PrintStream s)
  {
    synchronized (s)
    {
      super.printStackTrace(s);
      if (origin != null && origin != this)
      {
        s.print("due to: ");
        origin.printStackTrace(s);
      }
    }
  }

  public void printStackTrace(PrintWriter s)
  {
    synchronized (s)
    {
      super.printStackTrace(s);
      if (origin != this && origin != this)
      {
        s.print("due to: ");
        origin.printStackTrace(s);
      }
    }
  }
}
