/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
//import java.io.BufferedInputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

/**
 * This class contains basic scripts for testing the XML part of the
 * LuceneServer.
 * 
 * @author  hamish
 */
public class SocketTestXMLStuff {
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting   = 9999L;
        long tClosedConnection = 9999L;
        
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;

        try {
            echoSocket = new Socket("localhost", 22222);
        	//echoSocket = new Socket("192.168.4.20", 22222); //production
            //echoSocket = new Socket("192.168.4.20", 22223); //staging/test
            //echoSocket = new Socket("192.168.4.20", 22224); //development
        	//echoSocket = new Socket("levy.catalyst.net.nz", 22225); //wrms dual mp box
            
            OutputStreamWriter echoOut = new OutputStreamWriter(echoSocket.getOutputStream(), "UTF-8");
            
            out = new PrintWriter(echoOut, true);
            in = new BufferedReader(new InputStreamReader(
                                        echoSocket.getInputStream(), "UTF-8"));
        } catch (java.net.UnknownHostException e) {
            System.err.println("Unknown Host Exception. Cannot resolve host.");
            System.exit(1);
        } catch (java.io.IOException e) {
            System.err.println("Couldn't get I/O for the connection.");
            System.exit(1);
        }

        tOpenedConnection = System.currentTimeMillis();

		String index =  "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
					   	"<LuceneIndexRequest>" +
					   	"<Application>stuff</Application>" +
					   	//"<Domain>sos</Domain>" +
					   	"<Serial>abc123</Serial>" +
					   	//"<Id>04</Id>" +
					   	"<Fields>" +
    						"<Field name=\"Id\" type=\"text\" indexed=\"true\" stored=\"true\" >04</Field>" +
					   		"<Field name=\"Name\" type=\"text\" indexed=\"true\" stored=\"true\" >cat</Field>" +
					   		"<Field name=\"Details\" type=\"text\" indexed=\"false\" stored=\"false\" >\u015d free</Field>" +
					   		"<Field name=\"Teaser\">\u2665\u9421\u1ecb\u0110j\u006a\u006a\u006a</Field>" +
					   		"<Field name=\"Location\">10</Field>" +
					   		"<Field name=\"Category\">10</Field>" +
					   		"<Field name=\"DisplayStartDate\">2002-12-10</Field>" +
					   		"<Field name=\"SaleStartDate\">2002-12-10</Field>" +
					   		"<Field name=\"EndDate\">2002-12-25</Field>" +
					   		"<Field name=\"Cancelled\">N</Field>" +
    						"<Field name=\"Date3\" type=\"date\" indexed=\"true\" stored=\"false\">2003-12-25</Field>" +
					   	"</Fields>" +	
					   	"</LuceneIndexRequest>\n\n";
		String query = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
				    	"<LuceneQueryRequest>" +
				    	"<Application>stuff</Application>" +
				    	"<Serial>123abc</Serial>" +
				    	"<Query><![CDATA[   " +
				    		//"Name:fatcat\n" +
    						"Id:04\n" +
				    		//"    Details:\u005a" + 
				    		//"\u0061-\u007a-\u00c0-\u00d6-\u00d8-\u00f6-\u00f8-\u00ff-\u0100-\u1fff-\u3040-\u318f-\u3300-\u337f-\u3400-\u3d2d-\u4e00-\u9fff-\uf900-\ufaff-\n" +
				    	"]]></Query>" +
				    	//"<Sort limit=\"100\">RANK:desc</Sort>" +
    				    //"<Sort>RANK:desc</Sort>" +
    				    "<Return>Name Details</Return>" + 
				    	"<Limit>3</Limit>" +
				    	//"<Range field=\"DisplayStartDate\">" +
				    	//	"<From>2002/01/29</From>" +
				    	//	"<To>2003/01/29</To>" +
				    	//"</Range>" +
    					"</LuceneQueryRequest>";
    	String query_all = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
    					"<LuceneQueryRequest>" +
    					"<Application>stuff</Application>" +
    					//"<Return>Title Date1</Return>" +
    					//"<Query>+Body:water +Body:he +Body:they +Body:when +Body:son* +Body:father +Boolean1:N +(Title:c* Title:black)</Query>" +
    					"<Limit>0</Limit>" +
						//"<Range field=\"Date1\">" +
						//	"<To>2002/07/29</To>" +
						//"</Range>" +
				    	//"<Range field=\"Date2\">" +
				    	//	"<From>2002/08/29</From>" +
				    	//"</Range>" +
    					"</LuceneQueryRequest>";
    	String query_with_defined_fields = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
    					"<LuceneQueryRequest>" +
    					"<Application>stuff</Application>" +
    					"<Query><![CDATA[   " +
    						"Title:cat  \n" +
    					//	"Id:04" +
    					"]]></Query>" +
    					"<Return>Title Date3</Return>" +
    					"<Limit>3</Limit>" +
  //  					"<Range field=\"DisplayStartDate\">" +
    //						"<From>2000/01/29</From>" +
    //						"<To>2004/01/29</To>" +
    //					"</Range>" +
				    	"<Fields>" +
				    		"<Field name=\"Details\" type=\"text\" indexed=\"yes\" stored=\"false\" />" +
				    		"<Field name=\"Date3\" type=\"date\" indexed=\"false\" stored=\"true\" />" +
				    	"</Fields>" +
    					"</LuceneQueryRequest>";
		String old = "QUERY\nApplication:sos\nQuery: Name:cat\nLimit:0\nEND\n";
    	String query_test = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" +
    					"<LuceneQueryRequest>" +
    					"<Serial><![CDATA[12<\"3\u014aa&bc]]></Serial>" +
    					"<Application>stuff</Application>" +
    					"<Query default-field=\"Name\">cat</Query>" +
    					"<Return>Name</Return>" +
    					//"<Default-Field>Name</Default-Field>" +
    					"<Limit>1</Limit>"+
    					//"<Offset>2</Offset>"+
    					"<Sort limit=\"10\">RANK:desc</Sort>" +
    					//"<First>"
    					"</LuceneQueryRequest>";

    	String command = query_with_defined_fields;
    	        
        //System.out.println(command);
    	System.out.println("===================================================");        
		//send command to server.
        out.println(command);
    	echoSocket.getOutputStream().write(command.getBytes("UTF-8")); //this uses UNICODE!
    	out.println("\n");
                        
/*
    	BufferedInputStream in_bytes = new BufferedInputStream(echoSocket.getInputStream());
	   	int theByte;
    	int byteCount = 0;
    	byte[] someBytes = new byte[50];
    	do {
	   		byteCount = in_bytes.read(someBytes);
    		System.out.print(new String(someBytes, "UTF-8"));

    	} while (byteCount > 0);
//*/
  //*
        String serverOutput;
        java.io.BufferedReader br = new java.io.BufferedReader(in);
        while ( (serverOutput = br.readLine()) != null ) System.out.println(serverOutput);
        if (serverOutput != null) System.out.println(serverOutput);
    	br.close();
  //*/  	       
        tAfterExecuting = System.currentTimeMillis();
        
		out.close();
		in.close();
		echoSocket.close();
        
        tClosedConnection = System.currentTimeMillis();
        
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
    }
}





/*
IndexReader r = IndexReader.open( "prdb_index");

int num = r.numDocs();
for ( int i = 0; i < num; i++) {
	if ( ! r.isDeleted( i)) {
		Document d = r.document( i);
	    System.out.println( "d=" +d);
	}
}
r.close();
*/