/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import nz.net.catalyst.Log;
import nz.net.catalyst.Util;
import nz.net.catalyst.lucene.server.Session;

public class SocketClient
implements Runnable {
    Socket clientSocket;
    private static String encoding = null;

    public SocketClient(Socket clientSocket) {
        this.clientSocket = clientSocket;
    }

    public void run() {
        String name = Util.name(this.clientSocket);
        BufferedReader input = null;
        PrintWriter output = null;
        if (encoding == null) {
            encoding = System.getProperty("nz.net.catalyst.SocketEncoding");
            Log.debug("socket Encoding set to: " + encoding);
            if (encoding == null) {
                encoding = "US-ASCII";
                Log.debug("no encoding specified using internal default: US-ASCII");
            }
        }
        try {
            try {
                input = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream(), encoding));
                output = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.clientSocket.getOutputStream()), encoding)));
                new Session().communicate(input, output, name);
            }
            catch (IOException e) {
                throw new RuntimeException("Error initialising new client connection " + name, e);
            }
        }
        finally {
            try {
                input.close();
                output.close();
                this.clientSocket.close();
                input = null;
                output = null;
                this.clientSocket = null;
            }
            catch (IOException e) {
                Log.error("IOException during closure of client socket connection " + name);
                Log.error(e.toString());
            }
        }
    }
}

