/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.util.HashMap;
import java.util.Map;
import nz.net.catalyst.Util;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.StopList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class AnalyzerPool
implements IPackage,
Constants {
    private static final Map pool = new HashMap();

    public static synchronized Analyzer get(String[] stopwords) {
        StopList stopList = StopList.create(stopwords);
        Analyzer analyzer = (Analyzer)pool.get(stopList);
        if (analyzer != null) {
            return analyzer;
        }
        analyzer = stopwords.length == 0 ? new StandardAnalyzer() : new StandardAnalyzer(stopList.getStopWords());
        pool.put(stopList, analyzer);
        return analyzer;
    }

    public static Analyzer get(String stopwords) {
        return AnalyzerPool.get(Util.split(stopwords == null ? "" : stopwords));
    }
}

