<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-login.php                                          */
/* Author:      Paul Waite                                              */
/* Description: Axyl login page.                                        */
/*              Most website provide login forms on one of the main     */
/*              website pages, however if you need a dedicated page     */
/*              to do it, then this one will suffice.                   */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("form-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Member Login", "main", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

// -----------------------------------------------------------------------
// MAIN CONTENT
// Provide your main page content here, then plug it into the template.

  $s  = "";
  $s .= "<form name=login_fm method=POST>";

  $Tlog = new table("auth");
  $Tlog->setwidth("");
  $Tlog->setpadding(2);
  $Tlog->setalign("center");
  $Tlog->setstyle("padding-top:30px");
  $Tlog->tbody("font-size:8pt;");
  if ($RESPONSE->ismemberof_group("Guest")) {
    // Username..
    $username_F = new form_textfield("tbxUsername", "NAME");
    $username_F->setcss("loginentry");
    $Tlog->tr();
    $Tlog->td( "Username:" );
    $Tlog->td_alignment("right");
    $Tlog->td( $username_F->render() );
    $Tlog->td( "&nbsp;" );

    // Password..
    $password_F = new form_passwordfield("tbxPassword", "PASSWD");
    $password_F->setcss("loginentry");
    $Tlog->tr();
    $Tlog->td( "Password:" );
    $Tlog->td_alignment("right");
    $Tlog->td( $password_F->render() );
    // Login button..
    $loginbtn = new form_imagebutton("login", "Login", "", "$LIBDIR/img/_logon.gif", "Click to Login", 77, 17);
    $Tlog->td( $loginbtn->render() );
  }
  else {
    $Tlog->tr();
    $Tlog->td( "Logged in as: " . $RESPONSE->name);
    $Tlog->td_alignment("center");

    // Logout button..
    $logoutbtn = new form_imagebutton("logout", "Logout", "", "$LIBDIR/img/_logoff.gif", "Logout", 77, 17);
    $logout_F = new form_hiddenfield("tbxLogoff", "Logoff");
    $Tlog->tr();
    $Tlog->td( $logoutbtn->render() . $logout_F->render() );
    $Tlog->td_alignment("center");
  }
  $s .= $Tlog->render();
  $s .= "</form>";

$RESPONSE->plugin("MAIN_CONTENT", $s);
if ($RESPONSE->microsite_detected != "") {
  $RESPONSE->plugin("MAIN_MENU", "main_menu()");
}

// #######################################################################
// OUTPUT..
$RESPONSE->send();
?>