<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    setup-orgs.php                                          */
/* Author:      Paul Waite                                              */
/* Description: Organisation setup page                                 */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
$HEADING = "Webpages Setup";

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($HEADING, "maint", $theme);

// -----------------------------------------------------------------------
// Include library modules..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");
include_once("layout-defs.php");

// -----------------------------------------------------------------------
// Include the various formatting choice templates..
include_once($RESPONSE->site_docroot . "$INCDIR/cm-formats.inc");

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "edit";  // Determines the action(s) we take
$recvalid = false;

// -----------------------------------------------------------------------
// MAIN CONTENT

//debug_on(DBG_SQL|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);

// #######################################################################
// POST PROCESSING
if (!isset($CMDIR)) {
  $CMDIR = "var/cm";
  mkpath($CMDIR);
}

// SAVE SETUP
if (isset($save_x)) {
  if (isset($page_id)) {
    // PAGE DETAILS
    if (isset($page_path) && $page_path != "" && isset($page_title) && $page_title != "") {
      if ($mode == "add") {
        $nofile = false;
        $doinsert = true;
        // If content-managed, then create the page using our
        // content management template webpage..
        if (isset($managed)) {
          if (isset($TemplateOption)) {
            debugbr("selected format for managed content template: $TemplateOption");
            $of = new outputfile($RESPONSE->site_docroot . "$CMDIR/cm-template.php");
            $of->write($head.$$TemplateOption.$tail);
            $of->closefile();
          }

          // Generate the new layout name/ID..
          $layoutname = str_replace(" ", "_", $page_id . "_" . $page_title);

          // Make sure page path is prefixed to point where it should. We
          // forbid creating content anywhere except underneath $CMDIR..
          $page_path = str_replace('../', '', $page_path);
          $page_path = $CMDIR . "/" . $page_path;

          if (!file_exists($RESPONSE->site_docroot . $page_path)) {
            $nofile = true;

            // Make a physical page from the template..
            $template_page = $RESPONSE->site_docroot . "$CMDIR/cm-template.php";
            if (!file_exists($template_page)) {
              $template_page = $RESPONSE->site_docroot . "/$INCDIR/cm-template.inc";
            }
            if (!isset($page_template) || $page_template == "") {
              $page_template = "main";
            }
            if ($template_page != "" && file_exists($template_page)) {
              debugbr("Making the new sitepage $page_path from $template_page");
              // Make our new page on disk..
              $newpage = new outputfile($RESPONSE->site_docroot . $page_path);
              $newpage->template($template_page);
              $newpage->replace("cm-template.php",  $page_path);
              $newpage->replace("My Layout Title",  $page_title);
              $newpage->replace("My Layout ID",     $layoutname);
              $newpage->replace("My Template Name", $page_template);
              $newpage->closefile();
            }
            else {
              $errmsgs[] = "Template '$template_page': failed to create new managed page '$page_path'";
            }
          }
          else {
            // if the file exists, save the record in the database anyway, and report what was actually
            // done. but only if the file they entered in, actually exists.

            // First, select from the database to see if the ax_sitepage.page_path contains the
            // name of the file that was entered. if it does, do nothing. of not, insert new record.
            $dbrec = new dbrecords("SELECT * FROM ax_sitepage WHERE page_path='" . strtolower($page_path) . "'");
            if (!$dbrec->hasdata) {
              $errmsgs[] = "Warning: Managed page '$page_path' already exists. Creating Database record for page.";
            }
            else {
              $errmsgs[] = "Warning: Managed page '$page_path' already exists.";
              $doinsert = false;
            }
          }
        }
        // Else its a non-content-managed Axyl page that is a starting place for a
        // developer to customise, so we create the page using our standard vanilla
        // Axyl webpage..
        else {
          // Ensure page path is specified absolute to document root..
          if (substr($page_path, 0, 1) != "/") {
            $page_path = "/$page_path";
          }
          if (!is_writeable(dirname($RESPONSE->site_docroot . $page_path))
          && (!file_exists($RESPONSE->site_docroot . $page_path))
          ) {
            $errmsgs[] = "Error: no permission to write to website directory '"
                      . dirname($RESPONSE->site_docroot . $page_path) . "'";
            $doinsert = false;
          }
          else {
            if (!file_exists($RESPONSE->site_docroot . $page_path)) {
              $nofile = true;

              // Make a physical page from the template..
              $template_page = $RESPONSE->site_docroot . "/$INCDIR/axyl-template.inc";
              if (!isset($page_template) || $page_template == "") {
                $page_template = "main";
              }
              if ($template_page != "" && file_exists($template_page)) {
                // Make our new page on disk..
                $newpage = new outputfile($RESPONSE->site_docroot . $page_path);
                $newpage->template($template_page);
                $newpage->replace("axyl-template.inc", $page_path);
                $newpage->replace("My Page Title", $page_title);
                $newpage->replace("My Template Name", $page_template);
                $newpage->closefile();
                $errmsgs[] = "NOTE: your new Axyl page has been saved to '$page_path'";
              }
              else {
                $errmsgs[] = "Template '$template_page': failed to create new Axyl page '$page_path'";
              }
            }
            else {
              // If the file exists, save the record in the database anyway, and report what was actually
              // done. but only if the file they entered in, actually exists.
              // First, select from the database to see if the ax_sitepage.page_path contains the
              // name of the file that was entered. if it does, do nothing. of not, insert new record.
              $dbrec = new dbrecords("SELECT * FROM ax_sitepage WHERE page_path='" . strtolower($page_path) . "'");
              if (!$dbrec->hasdata) {
                $errmsgs[] = "Warning: Axyl page '$page_path' already exists. Creating Database record for page.";
              }
              else {
                $errmsgs[] = "Warning: Axyl page '$page_path' already exists.";
                $doinsert = false;
              }
              // endif file_exists($page_path)
            }
          }
        }

        // Create a new website page record for it..
        start_transaction();
        if ($doinsert) {
          $SPin = new dbinsert("ax_sitepage");
          $SPin->set("page_id",    $page_id);
          $SPin->set("page_title", $page_title);
          $SPin->set("page_path",  $page_path);
          $SPin->set("managed",    isset($managed));
          $SPin->set("enabled",    isset($enabled));
          $SPin->execute();
        }

        // For content-managed pages, this entity groups all layout
        // versions for this layout and provides the linkage to the
        // page it is displayed on..
        if (isset($managed) && $nofile == true) {
          $LSin = new dbinsert("ax_layout_set");
          $LSin->set("layout_name", $layoutname);
          $LSin->set("page_id",     $page_id);
          $LSin->execute();
        }
        commit();
      }
      else {
        // Set up DB update..
        $SPup = new dbupdate("ax_sitepage");
        $SPup->set("page_title", $page_title);
        $SPup->set("page_path",  $page_path);
        $SPup->set("managed",    isset($managed));
        $SPup->set("enabled",    isset($enabled));
        $SPup->where("page_id=$page_id");
        $SPup->execute();
      }

      // Update the page group perms..
      $chkQ = dbrecordset("SELECT * FROM ax_sitepage WHERE page_id=$page_id");
      if ($chkQ->hasdata) {
        $pgdel = new dbdelete("ax_sitepage_group");
        $pgdel->where("page_id=$page_id");
        $pgdel->execute();
        if (isset($ugroup_restrict) && is_array($ugroup_restrict)) {
          if (count($ugroup_restrict) > 0) {
            if (!in_array("Any", $ugroup_restrict)) {
              foreach($ugroup_restrict as $group_info) {
                $bits = explode("~", $group_info);
                $group_id = $bits[0];
                $spgin = new dbinsert("ax_sitepage_group");
                $spgin->set("page_id", $page_id);
                $spgin->set("group_id", $group_id);
                $spgin->execute();
              }
            }
          }
        }
      }
    }
    $mode = "edit";

  } // isset page_id
}
// DELETE PAGE
elseif ($mode == "remove") {
  if (isset($page_id)) {
    $pQ = dbrecordset("SELECT * FROM ax_sitepage WHERE page_id=$page_id");
    if ($pQ->hasdata) {
      $path = $pQ->field("page_path");
      $title = $pQ->field("page_title");
      $managed = $pQ->istrue("managed");
      $docroot = $RESPONSE->site_docroot;
      if (substr($path, 0, 1) != "/") {
        $docroot .= "/";
      }
      if ($managed && file_exists($docroot . $path)) {
        // Delete from disk and database..
        if (unlink($docroot . $path)) {
          debugbr("successfully deleted file '$path' from disk");
          // Notes: the following delete process will effectively cascade
          // delete the related layout_set(s), layout(s), and layout_cells..
          start_transaction();
          $q  = "SELECT layout_id";
          $q .= "  FROM ax_layout_set ls, ax_layout l";
          $q .= " WHERE ls.page_id=$page_id";
          $q .= "   AND ls.layout_name=l.layout_name";
          $layout = dbrecordset($q);
          if ($layout->hasdata) {
            do {
              $lay = new layout($layout->field("layout_id"));
              $lay->delete();
            } while ($layout->get_next());
          }
          dbcommand("DELETE FROM ax_sitepage WHERE page_id=$page_id");
          dbcommand("DELETE FROM ax_menuoption WHERE sitepage='$path'");
          commit();
          $errmsgs[] = "Webpage '$title' was deleted";
        }
        else {
          debugbr("Error: failed to delete file '" . $docroot . $path . "' from disk");
          $errmsgs[] = "failed: could not delete file '" . $docroot . $path . "' from disk";
        }
      }
      else {
        // Delete from database only..
        // Notes: layout_set(s), layout(s), and layout_cells are left alone..
        dbcommand("DELETE FROM ax_sitepage WHERE page_id=$page_id");
        dbcommand("DELETE FROM ax_menuoption WHERE sitepage='" . $docroot . $path . "'");
        $errmsgs[] = "Webpage '$title' was removed from the database";
        if (!$managed && file_exists($docroot . $path)) {
          $errmsgs[] = "NB: this unmanaged webpage was NOT deleted from disk";
        }
      }
    }
  }
  $page_id = 0;
  $recvalid = false;
  $mode = "edit";
}
// ADD NEW PAGE
elseif (isset($add_x)) {
  $page_id = get_next_sequencevalue("seq_page_id", "ax_sitepage", "page_id");
  $page_title = "";
  $page_path = "";
  $managed = true;
  $enabled = true;
  $HEADING .= " - New";
  $ugroup_restrict = "Any";

  $recvalid = true;
  $mode = "add";
}
// CANCEL ADD
elseif (isset($cancel_x)) {
  $mode = "edit";
}

// -----------------------------------------------------------------------
// Get current page, if any..
if ($mode != "add" && isset($page_id) && $page_id != 0) {
  $pg = dbrecordset("SELECT * FROM ax_sitepage WHERE page_id=$page_id");
  if ($pg->hasdata) {
    $page_title = $pg->field("page_title");
    $page_path  = $pg->field("page_path");
    $managed    = $pg->istrue("managed");
    $enabled    = $pg->istrue("enabled");
    $HEADING .= " - $page_title";
    $recvalid = true;
    // Read in group perms too..
    $ugroup_restrict = array();
    $q  = "SELECT * FROM ax_sitepage_group sg, ax_group g";
    $q .= " WHERE sg.page_id=$page_id";
    $q .= "   AND g.group_id=sg.group_id";
    $groups = dbrecordset($q);
    if ($groups->hasdata) {
      do {
        $ugroup_restrict[] = $groups->field("group_id") . "~" . $groups->field("group_desc");
      } while ($groups->get_next());
    }
  }
}

// #######################################################################
// FORM ELEMENTS

// -----------------------------------------------------------------------
// CONTROL BUTTONS
$addbtn = new image_button("add",    "Add",    "", "", "$LIBDIR/img/_add.gif",    57, 15, "Add new item");
$canbtn = new image_button("cancel", "Cancel", "", "", "$LIBDIR/img/_cancel.gif", 57, 15, "Cancel this operation");
$rembtn = new image_button("remove", "Remove", "", "", "$LIBDIR/img/_remove.gif", 57, 15, "Remove this item");
$savbtn = new image_button("save",   "Save",   "", "", "$LIBDIR/img/_save.gif",   57, 15, "Save changes");
$rembtn->set_onclick("delWarn()");
$Tbtns = new table("buttons");
$Tbtns->setpadding(2);
$Tbtns->tr();
$Tbtns->td();
if ($recvalid) {
  $Tbtns->td_content( "&nbsp;" . $savbtn->render() );
}
if ($mode != "add") {
  $Tbtns->td_content( "&nbsp;" . $addbtn->render() );
  if ($recvalid) {
    $Tbtns->td_content( "&nbsp;" . $rembtn->render() );
  }
}
else {
  $Tbtns->td_content( "&nbsp;" . $canbtn->render() );
}
$Tbtns->td_content("&nbsp;");
$Tbtns->td_alignment("right", "bottom");
$CONTROL_BUTTONS = $Tbtns->render();

// Put in some javascript to prevent accidental deletes..
$RESPONSE->body->add_script(
    "function delWarn() {\n"
  . " var msg = \"WARNING:\\n\\n\";\n"
  . " msg+=\"Do you really want to delete this item?\\n\\n\";\n"
  . " var rc = confirm(msg);\n"
  . " if (rc) {\n"
  . "   document.forms.main_fm.mode.value='remove';\n"
  . "   document.forms.main_fm.submit();\n"
  . " }\n"
  . " else alert(\"Item survives to fight another day.\");\n"
  . "}\n"
);

// -----------------------------------------------------------------------
// SELECT MENU
$s = "";
if ($mode != "add") {
  $Sel_F = new form_combofield("page_id", "Site Pages", $page_id, EDITABLE, "width: 250px");
  $Sel_F->additem("");
  $Sel_F->set_onchange("document.forms.main_fm.submit()");
  $q = "SELECT * FROM ax_sitepage p";
  // Omit pages which belong to microsites. These are maintained
  // with the Microsite Admin screen..
  if ($RESPONSE->microsites_mode == MICROSITES_ENABLED) {
    $q .= " WHERE NOT EXISTS (";
    $q .= "  SELECT * FROM ax_microsite_page mp";
    $q .= "   WHERE mp.page_id=p.page_id";
    $q .= "     AND mp.corepage=FALSE";
    $q .= " )";
  }
  $q .= " ORDER BY page_title";
  $oQ = dbrecordset($q);
  if ($oQ->rowcount > 0) {
    do {
      $pgid = $oQ->field("page_id");
      $pgname = $oQ->field("page_title");
      $Sel_F->additem($pgid, $pgname);
    } while ($oQ->get_next());
  }
  $Tsel = new table("selector");
  $Tsel->setpadding(2);
  $Tsel->tr();
  $Tsel->td("<b>Select:</b>&nbsp;" . $Sel_F->render(), "formele");
  $Tsel->td_alignment("right");
  $s = $Tsel->render();
}
$PG_SELECT = $s;

// -----------------------------------------------------------------------
// DETAILS

$s = "";
if ($recvalid) {
  $Tdetail = new table("details");
  $Tdetail->setborder(0);
  $Tdetail->setpadding(2);
  $Tdetail->tr();
  $Tdetail->td("<h4>Details</h4>" );


  // FORM..
  $pgform = new subform();

  // FIELD - Page ID
  if ($mode == "add") {
    $pgid_F = new form_hiddenfield("page_id", $page_id);
  }
  else {
    $pgid_F = new form_labelfield("Page ID", $page_id);
  }
  $pgform->add($pgid_F);

  // FIELD - Page title
  $title_F = new form_textfield("page_title", "Title", $page_title);
  $title_F->setstyle("width: 300px");
  $pgform->add($title_F);

  // FIELD - Path
  $path_F = new form_textfield("page_path", "Path", $page_path);
  $path_F->setstyle("width: 300px");
  $pgform->add($path_F);
  $pgform->add_annotation(
         "<span style=\"font-size:85%;font-style:italic;padding-right:20%\">"
       . "The recommended approach is to just enter the filename above, which will be placed "
       . "into $CMDIR for you (relative to website root). Any references to this new page should "
       . "therefore be prefixed with \$CMDIR/ ($CMDIR/). If your application has pre-defined "
       . "directories below $CMDIR, you should instead prefix your filename with "
       . "\$CMDIR/your/dir to put your new page in the correct place.</span>"
       );

  if ($mode == "add") {
    $pgtemplate_F = new form_combofield("page_template", "Template");
    $pgtemplate_F->setstyle("width:$ewidth;");
    $pgtemplate_F->setclass("txtfel");
    if ($handle = opendir($RESPONSE->site_docroot . $TEMPLATESDIR)) {
      while (false !== ($file = readdir($handle))) {
        $fname = basename($file);
        if (substr($fname, 0, 9) == "template_") {
          $fname = get_file_stem( substr($fname, 9) );
          $pgtemplate_F->additem( $fname );
        }
      }
      closedir($handle);
    }
    $pgtemplate_F->setvalue("main");
    $pgform->add($pgtemplate_F);
  }

  // FIELD - Managed content
  $managed_F = new form_checkbox("managed", "Managed content");
  $managed_F->checked = $managed;
  if ($mode == "add") {
    $RESPONSE->add_script(
        "function showhide_formats() {\n"
      . " var divObj = null;\n"
      . " if (document.getElementById) {divObj=document.getElementById(\"cmformats\");}\n"
      . " else {\n"
      . "  if (document.all) divObj=eval('document.all[\"cmformats\"]');\n"
      . "  else {\n"
      . "   if (document.layers) divObj=eval('document.layers[\"cmformats\"]');\n"
      . "  }\n"
      . " }\n"
      . " if (divObj != null) {\n"
      . "  if (document.forms.main_fm.managed.checked) divObj.style.visibility='visible';\n"
      . "  else divObj.style.visibility='hidden';\n"
      . " }\n"
      . "}\n"
      );
    $managed_F->set_onclick("showhide_formats()");
  }
  $pgform->add($managed_F);

  // FIELD - Enabled flag
  $enb_F = new form_checkbox("enabled", "Enabled");
  $enb_F->checked = $enabled;
  $pgform->add($enb_F);

  // User Group Restriction options..
  $ugr = new form_combofield("ugroup_restrict", "Permitted groups", $ugroup_restrict, EDITABLE, "", 5, MULTISELECT);
  $ugr->setcss("width:$ewidth;");
  $ugr->additem("Any", "Any");
  $Q = dbrecordset("SELECT * from ax_group");
  if ($Q->hasdata) {
    do {
      $group_id = $Q->field("group_id");
      $group_desc = $Q->field("group_desc");
      $ugr->additem("$group_id~$group_desc", $group_desc);
    } while ($Q->get_next());
  }
  if (count($ugroup_restrict) == 0) {
    $ugr->setvalue("Any");
  }
  $pgform->add($ugr);
  $pgform->add_annotation(
        "<span style=\"font-size:85%;font-style:italic;padding-right:20%\">"
      . "To restrict access by Group select the user group(s) that you want to allow access to "
      . "this page. For example, if you only want Admins and Editors to view this page, then hold down "
      . "the control key, and select \"Admin\" and \"Editor\" from the list box. If you want ALL "
      . "users to have access to this page, then select only \"Any\"."
      . "</span>"
      );

  $Tdetail->tr();
  $Tdetail->td( $pgform->render() );
  $Tdetail->td_alignment("center", "top");
  $s = $Tdetail->render();
}
$PG_DETAILS = $s;

if ($mode == "add") {
  // The content-managed page template options..
  $opt1 = new form_radiobutton("TemplateOption", "", "option1");
  $opt1->check();
  $opt2 = new form_radiobutton("TemplateOption", "", "option2");
  $opt3 = new form_radiobutton("TemplateOption", "", "option3");
  $opt4 = new form_radiobutton("TemplateOption", "", "option4");
  $Temp = new table("TemplateOptionTable");
  $Temp->setborder(0);
  $Temp->setwidth("100%");
  $Temp->tr();
  $Temp->td("Formats for managed content", "font-weight:bold");
  $Temp->td_alignment("center");
  $Temp->td_colspan(4);
  $Temp->tr();
  $blurb  = "When you create a new managed content page, you can select from the following "
          . "basic formats. The first is simply a single content-managed area in the main "
          . "part of the page. The second and third variants have two separate content-managed "
          . "areas - the main plus a sidebar. The fourth has sidebar areas at each side of the "
          . "main content area. In every case the Template you select above is applied, and "
          . "this might over-ride your choice here - for example, if you picked a \"popup\" "
          . "template it would probably not be set up to render any sidebars. No errors would "
          . "result in that case, however the sidebar content would of course be missing.";
  $Temp->td($blurb, "padding-left:50px;padding-right:50px;padding-top:5px;padding-bottom:10px;");
  $Temp->td_colspan(4);
  $Temp->tr();
  $Temp->td("Option 1");
  $Temp->td_alignment("center");
  $Temp->td("Option 2");
  $Temp->td_alignment("center");
  $Temp->td("Option 3");
  $Temp->td_alignment("center");
  $Temp->td("Option 4");
  $Temp->td_alignment("center");
  $Temp->tr();
  $Temp->td($opt1->render());
  $Temp->td_alignment("center");
  $Temp->td($opt2->render());
  $Temp->td_alignment("center");
  $Temp->td($opt3->render());
  $Temp->td_alignment("center");
  $Temp->td($opt4->render());
  $Temp->td_alignment("center");
  $Temp->tr();

  // option 1 - Header, Footer, NO Side Bars
  $O1 = new table("option1");
  $O1->setwidth(100);
  $O1->setborder(1);
  $O1->tr();
  $O1->td("&nbsp;");
  $O1->tr();
  $O1->td("&nbsp;");
  $O1->td_height(50);
  $O1->tr();
  $O1->td("&nbsp;");
  $Temp->td($O1->render());
  $Temp->td_alignment("center");

  // option 2 - Header, Footer, NO Side Bars
  $O2 = new table("option2");
  $O2->setwidth(100);
  $O2->setborder(1);
  $O2->tr();
  $O2->td("&nbsp;");
  $O2->td_colspan(2);
  $O2->tr();
  $O2->td("&nbsp;");
  $O2->td_width("15%");
  $O2->td("&nbsp;");
  $O2->td_height(50);
  $O2->tr();
  $O2->td("&nbsp;");
  $O2->td_colspan(2);
  $Temp->td($O2->render());
  $Temp->td_alignment("center");

  // option 3 - Header, Footer, NO Side Bars
  $O3 = new table("option3");
  $O3->setwidth(100);
  $O3->setborder(1);
  $O3->tr();
  $O3->td("&nbsp;");
  $O3->td_colspan(2);
  $O3->tr();
  $O3->td("&nbsp;");
  $O3->td("&nbsp;");
  $O3->td_width("15%");
  $O3->td_height(50);
  $O3->tr();
  $O3->td("&nbsp;");
  $O3->td_colspan(2);
  $Temp->td($O3->render());
  $Temp->td_alignment("center");

  // option 4 - Header, Footer, NO Side Bars
  $O4 = new table("option4");
  $O4->setwidth(100);
  $O4->setborder(1);
  $O4->tr();
  $O4->td("&nbsp;");
  $O4->td_colspan(3);
  $O4->tr();
  $O4->td("&nbsp;");
  $O4->td_width("15%");
  $O4->td("&nbsp;");
  $O4->td("&nbsp;");
  $O4->td_width("15%");
  $O4->td_height(50);
  $O4->tr();
  $O4->td("&nbsp;");
  $O4->td_colspan(3);
  $Temp->td($O4->render());
  $Temp->td_alignment("center");
  $Temp->tr();
  $Temp->td("No sides, Body");
  $Temp->td_alignment("center");
  $Temp->td("Left bar, Body");
  $Temp->td_alignment("center");
  $Temp->td("Right bar, Body");
  $Temp->td_alignment("center");
  $Temp->td("Both bars, Body");
  $Temp->td_alignment("center");
  $PG_CMFORMATS = $Temp->render();
}
// -----------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// -----------------------------------------------------------------------
// mode field
$mod = new form_hiddenfield("mode", "$mode");
$MODE_HIDDEN = $mod->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form name=main_fm method="post">
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width=100%>
    <tr class="axtitle">
      <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=2 class=error><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--CONTROL_BUTTONS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td colspan=2 valign=top width=70%><!--PG_SELECT--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--PG_DETAILS--></td>
    </tr>
  </table>
  <div id="cmformats">
  <table border=0 cellspacing=3 cellpadding=0 width=100%>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--PG_CMFORMATS--></td>
    </tr>
  </table>
  </div>
</form>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("ERROR_MSG",         $ERROR_MSG);
$RESPONSE->plugin("PG_SELECT",         $PG_SELECT);
$RESPONSE->plugin("CONTROL_BUTTONS",   $CONTROL_BUTTONS);
$RESPONSE->plugin("PG_DETAILS",        $PG_DETAILS);
$RESPONSE->plugin("PG_CMFORMATS",      $PG_CMFORMATS);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>
