/*
 * Ayttm
 *
 * Copyright (C) 2003, the Ayttm team
 * 
 * Ayttm is derivative of Everybuddy
 * Copyright (C) 1999-2002, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __VALUE_PAIR_H__
#define __VALUE_PAIR_H__

#include <stdio.h>

#include "prefs.h"
#include "llist.h"


typedef struct _value_pair
{
	char key[MAX_PREF_NAME_LEN];
	char value[MAX_PREF_LEN];
} value_pair;

#ifdef __cplusplus
extern "C" {
#endif

char * value_pair_get_value( LList * pairs, const char * key );
void value_pair_print_values( LList * pairs, FILE * file, int indent );
void value_pair_free( LList * pairs );
LList * value_pair_update(LList * pairs, LList * new_list);
LList * value_pair_add(LList * list, const char * key, const char * value); 
LList * value_pair_remove(LList * list, const char * key); 

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* __VALUE_PAIR_H__ */
